function Y=plot_transpose_v1(A, Z, Elem1, Elem2, col, row1, row2, cell_axis, cell_title)

%  Reference:
%  Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
%  Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% Y=plot_transpose_v1(A, Z, Elem1, Elem2, col, row1, row2, cell_axis, cell_title)
% This function plots the transpose of what is already plot on the figure
%
%
% Inputs:     A: Data array
%             Z: Clustering from linkage
%         Elem1: Objects in Cluster 1
%         Elem2: Objects in Cluster 2
%           col: color code
%          row1: line handle of first cluster
%          row2: line handle of second cluster
%     cell_axis: axisscale of original data
%    cell_title: mode names
%
% Output:    Y : Original data whose second and third modes are switched.
%
%
% Last modified: 05/21/2007

original_axis=cell_axis;
original_title=cell_title;
if (size(cell_axis,1)==0)
    scales=cell(length(size(permute(A,[1 3 2]))),1);
else
    temp=cell_axis{2,1};
    cell_axis{2,1}=cell_axis{3,1};
    cell_axis{3,1}=temp;
    clear temp
    scales=cell_axis;
end
if (size(cell_title,1)==0)
    titles=cell(length(size(A)),1);
else
    temp=cell_title{2,1};
    cell_title{2,1}=cell_title{3,1};
    cell_title{3,1}=temp;
    clear temp
    titles=cell_title;
end


subplot(2,2,2,'replace');
nb_of_clicks=2;
for i=1:nb_of_clicks
    eval(['Mean' num2str(i) '=squeeze(mean(A(Elem' num2str(i) ',:,:)));']);
    if (isempty(scales{3,1})==0)
        eval(['m' num2str(i) '=plot(scales{3,1}, mean(transpose(Mean' num2str(i) ')),col{i});']);
    else
        eval(['m' num2str(i) '=plot(mean(transpose(Mean' num2str(i) ')),col{i});']);
    end
    hold on
    eval(['linelabel(m' num2str(i) ',Elem' num2str(i) ');']);
end
if (isempty(titles{3,1})==0)
    xlabel(titles{3,1});
end
Y=permute(A,[1 3 2]);
legend('Average of Cluster1','Average of Cluster2');

position1=[0.58,0.5,0.2,0.03];
u4=uicontrol(gcf,'style','checkbox','string','Add Individual Profiles','Units', 'Normal','position',position1,...
    'callback', {@checkbox2_Callback, Y, A, Z, Elem1, Elem2, col, row1, row2, cell_axis, original_axis, original_title});

position2=[0.80,0.5,0.1,0.03];
u2=uicontrol(gcf,'style','pushbutton','string','SELECT POINT','Units','Normal','position',position2,...
        'callback', {@select_point,Y, cell_axis, cell_title});

position3=[0.70,0.5,0.1,0.03];
u5=uicontrol(gcf,'style','checkbox','string','Transpose','Units', 'Normal','position',position3,...
      'callback', {@checkbox3_Callback, A, Z, Elem1, Elem2, col, row1, row2, original_axis, original_title});

%--------------------------------------------------------------------------
function select_point(no_use1, no_use2, Y, cell_axis, cell_title)

h=subplot(2,2,2);
Y=dataset(Y);
for i=1:3
    Y.axisscale{i,1}=cell_axis{i,1};
    Y.title{i,1}=cell_title{i,1};
end
get_point_v1(h,Y);

%--------------------------------------------------------------------------
function checkbox2_Callback(no_use1,no_use2, Y, A, Z, Elem1, Elem2, col, row1, row2, cell_axis, original_axis, original_title)
hObject=gcbo;
if (get(hObject,'Value') == get(hObject,'Max'))
    hold on;
    subplot(2,2,2)  
    add_indiv_v1(Y, Elem1, Elem2, col, cell_axis);
else
    plot_transpose_v1(A, Z, Elem1, Elem2, col, row1, row2, original_axis, original_title);
end

%--------------------------------------------------------------------------
function checkbox3_Callback(no_use1,no_use2, A, Z, Elem1, Elem2, col, row1, row2, original_axis, original_title)

figure2=subplot(2,2,2,'replace');
plot_data_v1(A,Z,row1,row2,col, original_axis, original_title);

