function [Elem1, Elem2]=plot_data_v1(A,Z,row1,row2,col, cell_axis, cell_title)

%  Reference:
%  Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
%  Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% [Elem1, Elem2]=plot_data_v1(A,Z,row1,row2,col)
% This function takes as input the selected clusters and plots the average of
% cluster1 and cluster2 on the same plot.
%
% Inputs:    A: original data array
%            Z: clustering from linkage
%         row1: selected cluster 1
%         row2: selected cluster 2
%         col : array for coloring
%   cell_axis : axisscale of original data
%  cell_title : mode names
%
% Outputs: Elem1: Objects in Cluster 1
%          Elem2: Objects in Cluster 2
%
%
% Last modified: 05/21/2007

if (size(cell_axis,1)==0)
    scales=cell(length(size(A)),1);
else
    scales=cell_axis;
end
if (size(cell_title,1)==0)
    titles=cell(length(size(A)),1);
else
    titles=cell_title;
end

nb_of_clicks=2;
leaf_nodes=size(A,1);
order=length(size(A));
if (order==2)
    for i=1:nb_of_clicks
        eval(['Elem' num2str(i) '=[cluster_elements(Z,Z(row' num2str(i) ',1),leaf_nodes) cluster_elements(Z,Z(row' num2str(i) ',2),leaf_nodes)];']);
        eval(['Mean' num2str(i) '=mean(A(Elem' num2str(i) ',:));']);
        if (isempty(scales{2,1})==0)
            eval(['m(i)=plot(scales{2,1},Mean' num2str(i) ',col{i});']);
        else
            eval(['m(i)=plot(Mean' num2str(i) ',col{i});']);
        end
        hold on;
        eval(['linelabel(m(i),Elem' num2str(i) ');']);
        if (isempty(titles{2,1})==0)
            xlabel(title{2,1});
        end
    end
    legend('Average of Cluster1','Average of Cluster2');
elseif (order==3)
    for i=1:nb_of_clicks
        eval(['Elem' num2str(i) '=[cluster_elements(Z,Z(row' num2str(i) ',1),leaf_nodes) cluster_elements(Z,Z(row' num2str(i) ',2),leaf_nodes)];']); 
        eval(['Mean' num2str(i) '=squeeze(mean(A(Elem' num2str(i) ',:,:)));']);
        if (isempty(scales{3,1})==0)
            eval(['m(i)=plot(scales{3,1},mean(Mean' num2str(i) '),col{i});']);
        else
            eval(['m(i)=plot(mean(Mean' num2str(i) '),col{i});']);
        end
        hold on
        eval(['linelabel(m(i),Elem' num2str(i) ');']);
    end
    if (isempty(titles{2,1})==0)
        xlabel(titles{3,1});
    end
    legend('Average of Cluster1','Average of Cluster2');
end

position1=[0.58,0.5,0.2,0.03];
u1=uicontrol(gcf,'style','checkbox','string','Add Individual Profiles','Units','Normal','position',position1,...
         'callback', {@checkbox1_Callback, A, Z, Elem1, Elem2, col, row1,row2, cell_axis, cell_title});

if (order==3)
    position2=[0.80,0.5,0.1,0.03];
    u2=uicontrol(gcf,'style','pushbutton','string','SELECT POINT','Units','Normal','position',position2,...
            'callback', {@select_point,A, cell_axis, cell_title});
    position3=[0.70,0.5,0.1,0.03];
    u2=uicontrol(gcf,'style','checkbox','string','Transpose','Units','Normal','position',position3,...
            'callback', {@plot_transpose,A, Z, Elem1, Elem2, col, row1, row2, cell_axis, cell_title});
end

%--------------------------------------------------------------------------
function select_point(no_use1, no_use2, A, cell_axis, cell_title)

h=subplot(2,2,2);
A=dataset(A);
for i=1:3
    A.axisscale{i,1}=cell_axis{i,1};
    A.title{i,1}=cell_title{i,1};
end
get_point_v1(h,A)

%--------------------------------------------------------------------------
function checkbox1_Callback(no_use1,no_use2, A, Z, Elem1, Elem2, col, row1,row2, cell_axis, cell_title)

hObject=gcbo;
if (get(hObject,'Value') == get(hObject,'Max'))
    subplot(2,2,2)
    add_indiv_v1(A, Elem1, Elem2, col, cell_axis);    
else
    subplot(2,2,2,'replace');
    plot_data_v1(A,Z,row1,row2,col, cell_axis, cell_title);
end

%--------------------------------------------------------------------------
function plot_transpose(no_use1,no_use2,A, Z, Elem1, Elem2, col, row1, row2, cell_axis, cell_title)

plot_transpose_v1(A, Z, Elem1, Elem2, col, row1, row2, cell_axis, cell_title);
