function Y=pdist_threeway(Data)

%  Reference:
%  Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
%  Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% Y=pdist_threeway(Data)
% This function computes the frobenius norm of the differences between each
% pair of samples in the object mode of a three-way data
% Input: Data: 3-way array
% Output:   Y: Distances as returned by pdist ( not a distance matrix)
%
%
% Last modified: 05/21/2007

N=size(Data,1);
for i=1:N
    for j=(i+1):N
        DistMatrix(i,j)=norm(squeeze(Data(i,:,:)-Data(j,:,:)),'fro');
        Y((i-1)*(N-i/2)+j-i)=DistMatrix(i,j);        
    end
end


