function linelabel(state,ind)

%linelabel      
%Identify a plotted line by clicking on it.
%Most of the code taken from Scott Hirsch
%Modified by Evrim Acar, 2006

if nargin==0
    state = flipud(findobj(gca,'Type','line'));
    %Find lines.  Flip, since findobj returns in reverse order.
end;

if ~isstr(state) % Set the WindowButtonDownFcn (turn on linelabel)
    %User call: specify handles to lines
    handles = state;
    if ~all(ishandle(handles))
        error('Input argument must be a vector of line handles');
    end;
    set(gcf,'WindowButtonDownFcn','linelabel down')
    set(gcf,'DoubleBuffer','on');       %eliminate flicker
           
    if ~iscell(ind)     %  User specifies a vector.
        ind={num2str(ind)};
    else                %  User specifies a cell array of strings
        if length(ind) ~= length(handles)
            error('Index cell array must be of same length as handle vector');
        end;
    end;
    
    for ii=1:length(handles)
        setappdata(handles(ii),'Index',ind{ii});
    end;
    
elseif strcmp(state,'down') % Execute the WindowButtonDownFcn.  Add label
    htype = get(gco,'Type');
    tag = get(gco,'Tag');
    
    if strcmp(htype,'line')      %Line - Add text object
        
        %User-selected point
        cp = get(gca,'CurrentPoint');
        x = cp(1,1);       %first xy values
        y = cp(1,2);       %first xy values
        
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %EA
        selected_point=cp;        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        %Which line is this?
        lineno = getappdata(gco,'Index');
        th = text(x,y,lineno,'HorizontalAlignment','center');

 
        mh = uicontextmenu('Tag','DeleteObject', ...
            'Callback','delete(gco);');
        
        set(th,'UIContextMenu',mh);
        
    elseif strcmp(htype,'text')     %Clicked on label - switch to moving
        set(gco,'EraseMode','xor')
        set(gcf,'WindowButtonMotionFcn','linelabel move', ...
            'WindowButtonUpFcn','linelabel up');
    end
    
elseif strcmp(state,'move') % Execute the WindowButtonMotionFcn. move label
    htype = get(gco,'Type');
    tag = get(gco,'Tag');
    if ~isempty(gco)
        th = gco;
        cp = get(gca,'CurrentPoint');
        pt = cp(1,[1 2]);
        x = cp(1,1);       %first xy values
        y = cp(1,2);       %first xy values
        set(th,'Position', [x y 0])
        drawnow
    end;
elseif strcmp(state,'up') % Execute the WindowButtonUpFcn
    htype = get(gco,'Type');
    tag = get(gco,'Tag');
    if strcmp(htype,'text')
        set(gco,'EraseMode','Normal')
        set(gcf,'WindowButtonMotionFcn','')
    end;
elseif strcmp(state,'off') % Unset the WindowButton...Fcns
    set(gcf,'WindowButtonDownFcn','','WindowButtonUpFcn','')
end

