function get_point_v1(state,A)

% Reference:
% Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
% Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% get_point_v1(state,A)
% This function plots the spectrum of all samples in the figure when
% a certain point is selected.
%
%
% Inputs: state: state of the push buttom
%            A : original data
% Output: Plot of the spectrum at a certain point
%
% Modified get_line function by Evrim Acar, 2006
% Last modified: 05/21/2007

if nargin==0
    state = flipud(findobj(gca,'Type','line'));
    %Find lines.  Flip, since findobj returns in reverse order.
end;
if ~isstr(state) % Set the WindowButtonDownFcn 
    %User call: specify handles to lines
    handles = state;
    if ~all(ishandle(handles))
        error('Input argument must be a vector of line handles');
    end;
    set(gcf,'WindowButtonDownFcn','get_point_v1 down')              
    set(gcf,'DoubleBuffer','on');   
    set(gcf,'UserData',A);    
elseif strcmp(state,'down') % Execute the WindowButtonDownFcn
    A=get(gcf,'UserData');
    cell_axis=A.axisscale;
    cell_title=A.title;
    if (size(cell_axis,1)==0)
        scales=cell(length(size(A)),1);
    else
        scales=cell_axis;
    end
    if (size(cell_title,1)==0)
        titles=cell(length(size(A)),1);
    else
        titles=cell_title;
    end
    state = flipud(findobj(gca,'Type','line'));
    input=[];
    class=[];
    for aaa=1:size(state,1)
        lineno = getappdata(state(aaa),'Index');
        lineno = str2num(lineno);
        if isempty(intersect(lineno,input))
            input = [input lineno];
            class=[class aaa*ones(1,size(lineno,2))];
        end
    end    
    cp = get(gca,'CurrentPoint');
    if (isempty(scales{3,1})==1)
        x = cp(1,1);       %first xy values
    else
        x = cp(1,1);
        difference= abs(scales{3,1}-x);
        [min_dif, min_index]=min(difference);
        x = min_index;
    end
    subplot(2,2,4,'replace');  
    for i=1:size(input,2)        
        k=A.data(input(i),:,floor(x));
        if (class(i)==1)
            if (isempty(scales{2,1})==1)
                t=plot(1:size(k,2),k,'b');hold on;shg
            else
                t=plot(scales{2,1},k,'b');hold on;shg
            end
        else
            if (isempty(scales{2,1})==1)
                t=plot(1:size(k,2),k,'g');hold on;shg
            else
                t=plot(scales{2,1},k,'g');hold on;shg
            end
        end
        word=strcat('Sample ', num2str(input(i)), '  x=', num2str(floor(cp(1,1))), '');
        linelabel(t,{word});
    end
    if (isempty(titles{2,1})==0)
        xlabel(titles{2,1});
    end        
    clear class
    clear input
    set(gcf,'WindowButtonDownFcn','','WindowButtonUpFcn','')
    hold off
end


