function R=cluster_elements_color(Z, row_nb, leaf_nodes)
%  Reference:
%  Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
%  Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% Last modified: 05/21/2007


R=[];
if ((Z(row_nb,1)<=leaf_nodes) & (Z(row_nb,2)<=leaf_nodes))
    R=[row_nb];
    return;
else
    R=[R row_nb];
    if (Z(row_nb,1)>leaf_nodes) 
        row_nb1=Z(row_nb,1)-leaf_nodes;
        D=cluster_elements_color(Z,row_nb1,leaf_nodes);
        R=[R D];
    end
    if (Z(row_nb,2)>leaf_nodes) 
        row_nb2=Z(row_nb,2)-leaf_nodes;
        E=cluster_elements_color(Z,row_nb2,leaf_nodes);
        R=[R E];
    end
end
