function C=cluster_elements(Z,index, leaf_nodes)

%  Reference:
%  Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
%  Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% C=cluster_elements(Z,index, leaf_nodes)
% This function traces back all elements in a cluster to the leaf nodes
% Inputs:            Z: clusters from linkage
%                index: row number of Z
%           leaf_nodes: number of leaf nodes
% Output:   C:  all elements in cluster 'index'
% 
%
%
% Last modified: 05/21/2007

C=[];
if (index<=leaf_nodes)
    C=[index];
    return;
else
    new_index1=Z(index-leaf_nodes,1);
    new_index2=Z(index-leaf_nodes,2);
    D=cluster_elements(Z,new_index1,leaf_nodes);
    E=cluster_elements(Z,new_index2,leaf_nodes);
    C=[C D E];
end
