function add_indiv_v1(A, Elem1, Elem2,col, cell_axis)

%  Reference:
%  Evrim Acar, Rasmus Bro, Bonnie Schmidt, New Exploratory Metabonomic
%  Tools, Submitted to Journal of Chemometrics, 2007.
%
%
% add_indiv_v1(A, Elem1, Elem2, col, cell_axis)
% This function adds the individual profile of each sample to the plot.
%
%
% Inputs:     A: Data array
%         Elem1: Objects in Cluster 1
%         Elem2: Objects in Cluster 2
%           col: Color code
%    cell_axis : axisscale of original data
%
%
% Last modified: 05/21/2007
           
if (size(cell_axis,1)==0)
    scales=cell(length(size(A)),1);
else
    scales=cell_axis;
end


color1=col{1}; color2=col{2};
if (length(size(A))==2)
    for i=1:size(Elem1,2)
        if (isempty(scales{2,1})==0)
            s(i)= plot(scales{2,1}, transpose(A(Elem1(i),:)),color1);
        else
            s(i)= plot(transpose(A(Elem1(i),:)),color1);
        end
        hold on;
        word= num2str(Elem1(i));
        linelabel(s(i),{word});
    end
    hold on;
    for i=1:size(Elem2,2)
        if (isempty(scales{2,1})==0)
            t(i)= plot(scales{2,1},transpose(A(Elem2(i),:)),color2);
        else
            t(i)= plot(transpose(A(Elem2(i),:)),color2);
        end
        hold on;
        word= num2str(Elem2(i));
        linelabel(t(i),{word});
    end        
elseif (length(size(A))==3)
    for i=1:size(Elem1,2)
        if (isempty(scales{3,1})==0)
            s(i) = plot(scales{3,1}, mean(squeeze(A(Elem1(i),:,:))),color1);
        else
            s(i) = plot(mean(squeeze(A(Elem1(i),:,:))),color1);
        end
        hold on;
        word= num2str(Elem1(i));
        linelabel(s(i),{word});
    end
    hold on;
    for i=1:size(Elem2,2)
        if (isempty(scales{3,1})==0)
            t(i)= plot(scales{3,1}, mean(squeeze(A(Elem2(i),:,:))),color2);
        else
            t(i)= plot(mean(squeeze(A(Elem2(i),:,:))),color2);
        end
        hold on;
        word= num2str(Elem2(i));
        linelabel(t(i),{word});
    end        
end
