function [X1,A,B,C] = simdata_gcms(na,nb,nc,ncomp,noiselevel)

load SixMass

B = zeros(nb,ncomp,nc);
x = 0:14;
y = [];
for i = 2:ncomp
y(i,:) = gaussmf(x,[rand(1)*5+1,7]);
y(i,:) = (y(i,:)-y(i,1));
y(i,:) = y(i,:)./max(y(i,:));
end


peakcenter = randperm(nb-27,ncomp)+13;
peakheight = (rand(ncomp,1)+0.1)*1e6;


a = [];
a(:,1) = peakheight(1)/2*ones(nb,1);
for i = 2:ncomp
    a(:,i) = zeros(nb,1);
    a(peakcenter(i)-7:peakcenter(i)+7,i) = peakheight(i)*y(i,:);
end

rtshift = round(2*randn(nc,1));
rtshift(rtshift>7) = 7;
rtshift(rtshift<-7) = -7;

for i = 1:nc
    B(:,1,i) = a(:,1);
    if rtshift(i)<0
        B(1:(end+rtshift(i)),2:ncomp,i) = a(1-1*rtshift(i):end,2:ncomp);
    else
        B(1+rtshift(i):end,2:ncomp,i) = a(1:(end-rtshift(i)),2:ncomp);
    end
end
pause(0.01)


A = A00(1:na,randperm(6,ncomp));
ccenter = randi([1,5],ncomp,1);
C = [];
for i = 1:ncomp
    C(:,i) = ccenter(i)+sqrt(ccenter(i))*rand(nc,1);
end

Asr = diag(sqrt(sum(A.^2)).^-1);
Asr(isinf(Asr)) = 0;
Csr = diag(sqrt(sum(C.^2)).^-1);
Csr(isinf(Csr)) = 0;
A = A*Asr;
C = C*Csr;

X = zeros(na,nb,nc);
for i = 1:nc
    Di = zeros(ncomp,ncomp);
    for ii = 1:ncomp
        Di(ii,ii) = C(i,ii);
    end
    X(:,:,i) = A*Di*B(:,:,i)';
end

noise = randn(size(X));
noise = noise*(std(X(:))/std(noise(:))*noiselevel);
X1 = X+noise;