function varargout = setparameters(varargin)
% SETPARAMETERS M-file for setparameters.fig
%      SETPARAMETERS, by itself, creates a new SETPARAMETERS or raises the existing
%      singleton*.
%
%      H = SETPARAMETERS returns the handle to a new SETPARAMETERS or the handle to
%      the existing singleton*.
%
%      SETPARAMETERS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SETPARAMETERS.M with the given input arguments.
%
%      SETPARAMETERS('Property','Value',...) creates a new SETPARAMETERS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before setparameters_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to setparameters_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help setparameters

% Last Modified by GUIDE v2.5 25-Jan-2004 21:57:23

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @setparameters_OpeningFcn, ...
                   'gui_OutputFcn',  @setparameters_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before setparameters is made visible.
function setparameters_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to setparameters (see VARARGIN)

% Choose default command line output for setparameters
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

movegui(handles.fSetParameters,'center');
InitialiseGUI(handles);

% UIWAIT makes setparameters wait for user response (see UIRESUME)
uiwait(handles.fSetParameters);


% --- Outputs from this function are returned to the command line.
function varargout = setparameters_OutputFcn(hObject, eventdata, handles)

varargout{1} = handles.CrossVal;
varargout{2} = handles.Comp;

delete(handles.fSetParameters);

%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
function cbCrossValidation_Callback(hObject, eventdata, handles)

%figure(handles.fSetParameters);

%-------------------------------------------------------------------------
function etComponents_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%-------------------------------------------------------------------------
function etComponents_Callback(hObject, eventdata, handles)

val = str2double(get(handles.etComponents,'String'));
if isnan(val) | rem(val,1)
  errordlg('An integer number of components must be enteret!','Wrong input format','modal');
  set(handles.pbOK,'Enable','off');
  return
end

set(handles.pbOK,'Enable','on');

%figure(handles.fSetParameters);

%-------------------------------------------------------------------------
function pbOK_Callback(hObject, eventdata, handles)

handles.CrossVal = get(handles.cbCrossValidation,'Value');
handles.Comp     = str2num(get(handles.etComponents,'String'));
guidata(hObject,handles);

uiresume(handles.fSetParameters);

%-------------------------------------------------------------------------
function pbCancel_Callback(hObject, eventdata, handles)

handles.CrossVal = [];
handles.Comp     = [];
guidata(hObject,handles);

uiresume(handles.fSetParameters);

%--------------------------------------------------------------------------
function fSetParameters_KeyPressFcn(hObject, eventdata, handles)

CurChar = get(hObject,'CurrentCharacter');
CurVal  = double(CurChar);
if isempty(CurVal)
  return
end
if isequal(CurVal,27)
  pbCancel_Callback(hObject, eventdata, handles);
elseif isequal(CurVal,13)
  pbOK_Callback(hObject, eventdata, handles);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function InitialiseGUI(handles);

fSensable = findobj('Tag','fSensable');
if ~isempty(fSensable)
  fSensableHandles = guidata(fSensable);
  if ~isempty(fSensableHandles.DataSet.CrossValidation)
    set(handles.cbCrossValidation,'Value',fSensableHandles.DataSet.CrossValidation);
  end
  if ~isempty(fSensableHandles.DataSet.Components)
    set(handles.etComponents,'String',num2str(fSensableHandles.DataSet.Components));
    set(handles.pbOK,'Enable','on');
  end
end
