function varargout = sensable(varargin)
% SENSABLE M-file for sensable.fig
%      SENSABLE, by itself, creates a new SENSABLE or raises the existing
%      singleton*.
%
%      H = SENSABLE returns the handle to a new SENSABLE or the handle to
%      the existing singleton*.
%
%      SENSABLE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SENSABLE.M with the given input arguments.
%
%      SENSABLE('Property','Value',...) creates a new SENSABLE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before sensable_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to sensable_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help sensable

% Last Modified by GUIDE v2.5 10-Feb-2005 13:05:59

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @sensable_OpeningFcn, ...
                   'gui_OutputFcn',  @sensable_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% Opening/Closing functions %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes just before sensable is made visible.
function sensable_OpeningFcn(hObject, eventdata, handles, varargin)

% Choose default command line output for sensable
handles.output = hObject;

% Position GUI
movegui(handles.fSensable,'center');

% Set accelerators:
set(handles.mFileImportData, 'Accelerator','I');
set(handles.mFileSaveData,   'Accelerator','S');

% Initialisation of varibles
handles.SaveDataRequired  = false;
handles.SaveModelRequired = false;
handles.LoadPreviousFiles = '';     % name of previously used file if selected from file menu
handles.MaxPreviousFiles  = 4;
handles.ModelPlotHandles  = [];

% Store opening path
handles.ProgramPath = pwd;
if ~exist(fullfile(handles.ProgramPath,'sensable.m'),'file') & ...
   ~exist(fullfile(handles.ProgramPath,'sensable.exe'),'file') % Workspace version
  p = which('sensable.m');
  [pathstr,name,ext,versn] = fileparts(p);
  handles.ProgramPath = pathstr;
end

% Open initalisation file
fid = fopen('sensable.ini','rt');
str = [];
while ~feof(fid)
  str = strvcat(str,fgetl(fid));
end
fclose(fid);

% Last four files accessed
I = strmatch('[PREVIOUSFILES]',str);
if ~isequal(size(str,1),I)                            % Last row?
  if ~strcmpi(str(I+1,1),'[') & ~isempty(str(I+1,:))  % Not an "indicator line" ([) and not empty
    handles.PreviousFiles = '';
    count = 1;
    while ~strcmpi(str(I+count,1),'[') & ~isempty(str(I+count,:)) & count < 10
      handles.PreviousFiles = strvcat(handles.PreviousFiles,str(I+count,:));
      count = count + 1;
    end
  else
    handles.PreviousFiles = '';
  end
else
  handles.PreviousFiles = '';
end

% Change to directory last used
I = strmatch('[LASTPATH]',str);
if ~isequal(size(str,1),I)                            % Last row?
  if ~strcmpi(str(I+1,1),'[') & ~isempty(str(I+1,:))  % Not an "indicator line" ([) and not empty
    if exist(deblank(str(I+1,:)),'dir')
      handles.LastPath = deblank(str(I+1,:));
    else
      handles.LastPath = pwd; % 'c:\';
    end
  else
    handles.LastPath = pwd; % 'c:\';
  end
else
  handles.LastPath = pwd; % 'c:\';
end

cd(handles.LastPath);

% Update File menu if previous worked-on data sets exist
handles = UpdateFileMenu(handles);

% Update handles structure
guidata(hObject, handles);

% Initialise GUI
InitialiseGUI(handles);

% UIWAIT makes sensable wait for user response (see UIRESUME)
% uiwait(handles.fSensable);

% --- Outputs from this function are returned to the command line.
function varargout = sensable_OutputFcn(hObject, eventdata, handles)

% Get default command line output from handles structure
varargout{1} = handles.output;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Callbacks %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --------------------------------------------------------------------
function mFPF_Callback(hObject, eventdata, handles); % FPF = FilePreviousFiles
% This function is called if one of the "previous four" in the file menu is
% selected.

index = find(handles.mFilePreviousFiles == hObject);
handles.LoadPreviousFiles = deblank(handles.PreviousFiles(index,:));

guidata(hObject,handles);

mFileImportData_Callback(hObject, eventdata, handles);

% --------------------------------------------------------------------
function mFile_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mFileImportData_Callback(hObject, eventdata, handles)

set(handles.fSensable,'Pointer','watch');

if isfield(handles,'DataSet')
  answer = questdlg(['A data set allready exist!',char(10),'Do you want to replace existing data?'],...
                     'Owerwrite existing data?','Yes','No','No');
  switch answer
    case 'Yes'
      handles = rmfield(handles,'DataSet');
      handles.SaveDataRequired  = false;
      handles.SaveModelRequired = false;
      InitialiseGUI(handles);
      axes(handles.aRawData);
      cla;
      axes(handles.aTransformedData);
      cla;
      set([handles.etProcessInfo handles.etModelInfo],'String','');
%      set([handles.mFileSaveData handles.mFileSaveModel handles.mFileExportData handles.mFileExportModel],'Enable','off');
    case 'No'
      set(handles.fSensable,'Pointer','arrow');
      return;
  end
end

if isempty(handles.LoadPreviousFiles)
  [filename,pathname] = uigetfile({'*.mat','MATLAB-file (*.MAT)'; ...
                                   '*.txt','ASCII-file (*.txt)'; ...
                                   '*.*'  ,'All files (*.*)'}, ...
                                   'Select import file name');
  if isnumeric(filename) & isnumeric(pathname)  % Cancel pressed!
    set(handles.fSensable,'Pointer','arrow');
    return;
  end
elseif ~isempty(handles.LoadPreviousFiles)    % One of the previously used data sets have been selected
  if exist(handles.LoadPreviousFiles,'file')  % Selected file exist
    [pathname,filename,ext,versn] = fileparts(handles.LoadPreviousFiles);
    filename = [filename,ext];
    handles.LoadPreviousFiles = '';
  elseif ~exist(handles.LoadPreviousFiles,'file') % Selected file does NOT exist (e.g. on a network drive not mapped
    uiwait(msgbox(['File "',handles.LoadPreviousFiles,'" does not exist!'],'Error loading data!','error','modal'));
    handles.LoadPreviousFiles = '';
    guidata(hObject,handles);
    set(handles.fSensable,'Pointer','arrow');
    return;
  end
end

% Update file menu to include last selection
I = strmatch(fullfile(pathname,filename),handles.PreviousFiles);
if ~isempty(I)
  handles.PreviousFiles(I,:) = [];   % Remove previous instance of current file
  handles.PreviousFiles      = strvcat(fullfile(pathname,filename),handles.PreviousFiles);
else
  handles.PreviousFiles = strvcat(fullfile(pathname,filename),handles.PreviousFiles);
  if size(handles.PreviousFiles,1) > handles.MaxPreviousFiles
    handles.PreviousFiles = handles.PreviousFiles(1:handles.MaxPreviousFiles,:);
  end
end
handles = UpdateFileMenu(handles);

if ~isequal(filename,0) | ~isequal(pathname,0)
  set(handles.fSensable,'Pointer','watch');
  handles.FileName = filename;
  handles.PathName = pathname;
  [pathstr,name,ext,versn] = fileparts(filename);
  switch lower(ext(2:end))
    case 'mat'
      temp = load(fullfile(pathstr,filename));
      fn   = fieldnames(temp);
      % 'fn' must be equal to NoseData
      if ~strcmp(fn{1},'NoseData')
        errordlg('Selected file does not contain a struct-variable named "NoseData"','Wrong variable name','modal');
        return
      end
      % 'fn' must be of class struct
      if ~isstruct(temp.NoseData)
        errordlg('Selected file does not contain a struct-variable!','Struct does not exist...','modal');
        return
      end
      % 'fn' must contain a field named 'data'
      if ~isfield(temp.NoseData,'data')
        errordlg('Imported struct does not contain a field named "data"!','Field named "data" does not exist...','modal');
        return
      end
%      handles.DataSet.OriginalStructName = fn{1};
      [X,Y,Z] = size(temp.NoseData.data);
      handles.DataSet.Samples   = X;
      handles.DataSet.Time      = Y;
      handles.DataSet.Sensors   = Z;
      handles.DataSet.IncludedX = {true(X,1),true(Y,1),true(Z,1)};
      handles.DataSet.data      = temp.NoseData.data;
      fields = {'labels','mode','date','author','name','ref'};
      for i = 1:length(fields)
        if isfield(temp.NoseData,fields{i})       % Field exist
          % MANGLER: CHECK IF EXISTING FIELDS HAVE APPROPRIATE SIZE
          content = temp.NoseData.(fields{i});
        elseif ~isfield(temp.NoseData,fields{i})  % Field does not exist
          switch fields{i}
            case 'labels'
              content = {num2str([1:handles.DataSet.Samples]'),num2str([1:handles.DataSet.Time]'),num2str([1:handles.DataSet.Sensors]')};
              handles.SaveDataRequired = true;
            case 'mode'
              content = {'Objects';'Time';'Sensors'};
              handles.SaveDataRequired = true;
            case 'date'
              content = date;
              handles.SaveDataRequired = true;
            case 'author'
              content = '';
              handles.SaveDataRequired = true;
            case 'name'
              content = '';
              handles.SaveDataRequired = true;
            case 'ref'
              content = [];
              handles.SaveDataRequired = true;
          end
        end
        handles.DataSet.(fields{i}) = content;
      end
      if isempty(handles.DataSet.ref)
        handles.DataSet.IncludedY = NaN;
      else
        handles.DataSet.IncludedY = true(size(handles.DataSet.ref.data,2),1);
      end
      handles.DataSet.Model     = NaN;
      
    case 'txt'
      handles.DataSet.Samples   = NaN;
      handles.DataSet.Time      = NaN;
      handles.DataSet.Sensors   = NaN;
      handles.DataSet.data      = NaN;
      handles.DataSet.labels    = cell(1,3);
      handles.DataSet.mode      = cell(3,1);
      handles.DataSet.date      = '';
      handles.DataSet.author    = '';
      handles.DataSet.name      = '';
      handles.DataSet.ref       = [];
      handles.DataSet.IncludedX = NaN;
      handles.DataSet.IncludedY = NaN;
      handles.DataSet.Model     = NaN;
      
      fid = fopen(fullfile(pathname,filename),'rt');
      fseek(fid,0,'eof');
      EndPos = ftell(fid);
      fseek(fid,0,'bof');
      HW = waitbar(0,['Reading file: ',filename]);
      set(get(allchild(HW),'Title'),'Interpreter','none');
      set(HW,'Name','Importing file');
      counter = 0;
      while ~feof(fid)
        counter = counter + 1;
        str{counter} = fgetl(fid);
        pos = ftell(fid);
        waitbar(pos/EndPos,HW);
      end
      fclose(fid);
      close(HW);
      str = strvcat(str{:});
      Nlines = size(str,1);
      
      handles.DataSet.OriginalStructName = 'NoseData';
      
      I = strmatch('[DATASIZE]',str);
      if ~isequal(Nlines,I) & ~strcmpi(str(I+1,1),'[') & ~isempty(str(I+1,:))  % Not last row & Not an "indicator line" ([) & Not empty
        DataSize = str2num(str(I+1,:));
        handles.DataSet.Samples = DataSize(1);
        handles.DataSet.Time    = DataSize(2);
        handles.DataSet.Sensors = DataSize(3);
      else
        errordlg('No data size specified!','Error importing data!','modal');
        return
      end
      
      I = strmatch('[NAME OF MODES]',str);
      if ~isequal(Nlines,I)                                    % Last row?
        for i = 1:3
          if ~strcmpi(str(I+i,1),'[') & ~isempty(str(I+i,:))   % Not an "indicator line" ([) and not empty     
            handles.DataSet.mode{i} = fliplr(deblank(fliplr(deblank(str(I+i,:)))));
          end
        end
      end

      I = strmatch('[DATE]',str);
      if ~isequal(Nlines,I) & ~strcmpi(str(I+1,1),'[') & ~isempty(str(I+1,:))  % Not last row & Not an "indicator line" ([) & Not empty
        handles.DataSet.date = fliplr(deblank(fliplr(deblank(str(I+1,:)))));
      end

      I = strmatch('[AUTHOR]',str);
      if ~isequal(Nlines,I) & ~strcmpi(str(I+1,1),'[') & ~isempty(str(I+1,:))  % Not last row & Not an "indicator line" ([) & Not empty
        handles.DataSet.author = fliplr(deblank(fliplr(deblank(str(I+1,:)))));
      end

      I = strmatch('[NAME]',str);
      if ~isequal(Nlines,I) & ~strcmpi(str(I+1,1),'[') & ~isempty(str(I+1,:))  % Not last row & Not an "indicator line" ([) & Not empty
        handles.DataSet.name = fliplr(deblank(fliplr(deblank(str(I+1,:)))));
      end

      I = strmatch('[DATA]',str);
      if ~isequal(Nlines,I)                                             % Last row?
        handles.DataSet.data = zeros(handles.DataSet.Samples,handles.DataSet.Time,handles.DataSet.Sensors);
        count = 0;
        for i = 1:handles.DataSet.Samples
          for j = 1:handles.DataSet.Time
            count = count + 1;
            if ~strcmpi(str(I+count,1),'[') & ~isempty(str(I+count,:))   % Not an "indicator line" ([) and not empty     
              temp = str2num(str(I+count,:));
              handles.DataSet.data(i,j,:) = temp;
            else
              errordlg('Data does not correspond to the specified size!','Error importing data!','modal');
              return
            end
          end
        end
      end
      
      I = strmatch('[LABELS MODE1]',str);
      if ~isequal(Nlines,I)                                    % Last row?
        temp = [];
        for i = 1:handles.DataSet.Samples
          if ~strcmpi(str(I+i,1),'[') & ~isempty(str(I+i,:))   % Not an "indicator line" ([) and not empty     
            temp = strvcat(temp,fliplr(deblank(fliplr(deblank(str(I+i,:))))));
          end
        end
      end
      handles.DataSet.labels{1} = temp;

      I = strmatch('[LABELS MODE2]',str);
      if ~isequal(Nlines,I)                                    % Last row?
        temp = [];
        for i = 1:handles.DataSet.Time
          if ~strcmpi(str(I+i,1),'[') & ~isempty(str(I+i,:))   % Not an "indicator line" ([) and not empty     
            temp = strvcat(temp,fliplr(deblank(fliplr(deblank(str(I+i,:))))));
          end
        end
      end
      handles.DataSet.labels{2} = temp;

      I = strmatch('[LABELS MODE3]',str);
      if ~isequal(Nlines,I)                                    % Last row?
        temp = [];
        for i = 1:handles.DataSet.Sensors
          if ~strcmpi(str(I+i,1),'[') & ~isempty(str(I+i,:))   % Not an "indicator line" ([) and not empty     
            temp = strvcat(temp,fliplr(deblank(fliplr(deblank(str(I+i,:))))));
          end
        end
      end
      handles.DataSet.labels{3} = temp;

      I = strmatch('[REFDATA]',str);
      if ~isequal(Nlines,I)                                         % Last row?
        for i = 1:handles.DataSet.Samples
          if (Nlines >= I+i)
            if ~strcmpi(str(I+i,1),'[') & ~isempty(str(I+i,:))      % Not an "indicator line" ([) AND not empty
              handles.DataSet.ref.data(i,:) = str2num(str(I+i,:));
            end
          end
        end
      end

      if isempty(handles.DataSet.ref)
        set(handles.mModelYvariables,'Enable','off');
      else
        set(handles.mModelYvariables,'Enable','on');  % Required if a second set containing Y is imported, after one without Y
      end

      I = strmatch('[LABELS REFDATA]',str);
      if ~isequal(Nlines,I) & ~isempty(handles.DataSet.ref)    % Last row?
        for i = 1:size(handles.DataSet.ref.data,2)
          if (Nlines >= I+i)
            if ~strcmpi(str(I+i,1),'[') & ~isempty(str(I+i,:))      % Not an "indicator line" ([) AND not empty     
              handles.DataSet.ref.label{i,1} = fliplr(deblank(fliplr(deblank(str(I+i,:)))));
            end
          end
        end
      end
      
      handles.DataSet.IncludedX = {true(handles.DataSet.Samples,1),true(handles.DataSet.Time,1),true(handles.DataSet.Sensors,1)};
      if isempty(handles.DataSet.ref)
        handles.DataSet.IncludedY = NaN;
      else
        handles.DataSet.IncludedY = true(size(handles.DataSet.ref.data,2),1);
      end
      
      handles.SaveDataRequired = true;
      set(handles.fSensable,'Name',['SENSABLE - Program for analysis of electronic nose data - ',fullfile(pathname,filename),'*']);
    otherwise
      errordlg(['The program only supports files of the type:',char(10),'*.MAT',char(10),'*.TXT'],'Unsupported file format!');
      return;
  end
  
  % DefinedGroups are currently not store with data and must be defined 
  % each time data are loaded.
  handles.DataSet.DefinedGroups{1} = [1:handles.DataSet.Samples]';
  handles.DataSet.DefinedGroups{2} = [1:handles.DataSet.Sensors]';
  
elseif isequal(filename,0) | isequal(pathname,0)
%  set(handles.fSensable,'Pointer','arrow');
  return;
end

if    ~handles.SaveDataRequired
  set(handles.fSensable,'Name',['SENSABLE - Program for analysis of electronic nose data - ',fullfile(pathstr,filename)]);
elseif handles.SaveDataRequired
  set(handles.fSensable,'Name',['SENSABLE - Program for analysis of electronic nose data - ',fullfile(pathstr,filename),'*']);
end

handles.DataSet.preprocess.ID            = [];
handles.DataSet.preprocess.label         = [];
handles.DataSet.preprocess.FeatureSubset = [];
handles.DataSet.preprocess.data          = [];

handles.DataSet.CrossValidation          = [];
handles.DataSet.Components               = [];

handles = UpdatePreprocessStruct(handles);
handles = UpdateColorMap(handles);

UpdatePlot(handles);

guidata(hObject,handles);
set([handles.mFileSaveData handles.mFileExportData],   'Enable','on');
set([handles.mEdit handles.mPreprocess handles.mModel],'Enable','on');
set(get(handles.mModel,'Children'),'Checked','off');

set(handles.fSensable,'Pointer','arrow');

% --------------------------------------------------------------------
function mFileSave_Callback(hObject, eventdata, handles)

set(handles.fSensable,'Pointer','watch');

filename = [];
Continue = false;
while ~Continue
  [filename,pathname] = uiputfile({'*.mat','MATLAB-file (*.MAT)'; ...
                                   '*.*'  ,'All files (*.*)'}, ...
                                   'Save as','filename');
  if ~isequal(filename,0) | ~isequal(pathname,0)
    [pathstr,name,ext,versn] = fileparts(filename);
    switch lower(ext)
      case '.mat'
        Continue = true;
      case ''
        filename = [filename,'.mat'];
        if exist(fullfile(pathname,filename))
          ButtonName = questdlg(['"',fullfile(pathname,filename),'" already exists.',char(10),...
                                 'Do you want to replace it?'],'Save as','Yes','No','No');
          switch ButtonName
            case 'Yes'
              Continue = true;
            case 'No'
              % Take another turn in the while-loop
          end
        elseif ~exist(fullfile(pathname,filename))
          Continue = true;
        end
      otherwise
        errordlg(['Save can only be preformed to files of the type: *.MAT'],'Unsupported file format!');
        set(handles.fSensable,'Pointer','arrow');
        return;
    end   % Switch
  elseif isequal(filename,0) | isequal(pathname,0)
    set(handles.fSensable,'Pointer','arrow');
    return;
  end     % If
end       % While

switch get(hObject,'Tag')
  case 'mFileSaveData'
    fields = {'data','labels','mode','date','author','name','ref','IncludedX','IncludedY'};
    for i = 1:length(fields)
      NoseData.(fields{i}) = handles.DataSet.(fields{i});
    end
    save(fullfile(pathname,filename),'NoseData');

    handles.SaveDataRequired = false;
    if    ~handles.SaveDataRequired
      set(handles.fSensable,'Name',['SENSABLE - Program for analysis of electronic nose data - ',fullfile(pathstr,filename)]);
    elseif handles.SaveDataRequired
      set(handles.fSensable,'Name',['SENSABLE - rogram for analysis of electronic nose data - ',fullfile(pathstr,filename),'*']);
    end

  % Update file menu to include last selection
  I = strmatch(fullfile(pathname,filename),handles.PreviousFiles);
  if ~isempty(I)
    handles.PreviousFiles(I,:) = [];   % Remove previous instance of current file
    handles.PreviousFiles     = strvcat(fullfile(pathname,filename),handles.PreviousFiles);
  else
    handles.PreviousFiles     = strvcat(fullfile(pathname,filename),handles.PreviousFiles);
    if size(handles.PreviousFiles,1) > handles.MaxPreviousFiles
      handles.PreviousFiles   = handles.PreviousFiles(1:handles.MaxPreviousFiles,:);
    end
  end
  handles = UpdateFileMenu(handles);
  
  case 'mFileSaveModel'
    Model            = handles.DataSet.Model;
    PreprocessedData = handles.DataSet.preprocess;
    save(fullfile(pathname,filename),'Model','PreprocessedData');
    handles.SaveModelRequired = false;
end

guidata(hObject,handles);
set(handles.fSensable,'Pointer','arrow');

% --------------------------------------------------------------------
function mFileExport_Callback(hObject, eventdata, handles)

set(handles.fSensable,'Pointer','watch');

filename = [];
Continue = false;
while ~Continue
  [filename,pathname] = uiputfile({'*.txt','ASCII-file (*.TXT)'; ...
                                   '*.*'  ,'All files (*.*)'}, ...
                                   'Save as','filename');
  if ~isequal(filename,0) | ~isequal(pathname,0)
    [pathstr,name,ext,versn] = fileparts(filename);
    switch lower(ext)
      case '.txt'
        Continue = true;
      case ''
        filename = [filename,'.txt'];
        if exist(fullfile(pathname,filename))
          ButtonName = questdlg(['"',fullfile(pathname,filename),'" already exists.',char(10),...
                                 'Do you want to replace it?'],'Save as','Yes','No','No');
          switch ButtonName
            case 'Yes'
              Continue = true;
            case 'No'
              % Take another turn in the while-loop
          end
        elseif ~exist(fullfile(pathname,filename))
          Continue = true;
        end
      otherwise
        errordlg(['Exported can only be performed to files of the type: *.TXT'],'Unsupported file format!');
        set(handles.fSensable,'Pointer','arrow');
        return;
    end   % Switch
  elseif isequal(filename,0) | isequal(pathname,0)
    set(handles.fSensable,'Pointer','arrow');
    return;
  end     % If
end       % While

switch get(hObject,'Tag')
  case 'mFileExportData'
    fid = fopen(fullfile(pathname,filename),'wt');

    fprintf(fid,'%s\n','[DATASIZE]');
    fprintf(fid,'%d\t%d\t%d\n',handles.DataSet.Samples,handles.DataSet.Time,handles.DataSet.Sensors);
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[NAME OF MODES]');
    for i = 1:3
      fprintf(fid,'%s\n',handles.DataSet.mode{i});
    end
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[DATE]');
    fprintf(fid,'%s\n',handles.DataSet.date);
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[AUTHOR]');
    fprintf(fid,'%s\n',handles.DataSet.author);
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[NAME]');
    fprintf(fid,'%s\n',handles.DataSet.name);
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[DATA]');
    for i = 1:handles.DataSet.Samples
      for j = 1:handles.DataSet.Time
        fprintf(fid,'%d\t',squeeze(handles.DataSet.data(i,j,1:end-1))');
        fprintf(fid,'%d\n',handles.DataSet.data(i,j,end));
      end
    end
    fprintf(fid,'\n');
      
    fprintf(fid,'%s\n','[LABELS MODE1]');
    for i = 1:handles.DataSet.Samples
      fprintf(fid,'%s\n',fliplr(deblank(fliplr(deblank(handles.DataSet.labels{1}(i,:))))));
    end
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[LABELS MODE2]');
    for i = 1:handles.DataSet.Time
      fprintf(fid,'%d\n',handles.DataSet.labels{2}(i,1));
    end
    fprintf(fid,'\n');

    fprintf(fid,'%s\n','[LABELS MODE3]');
    for i = 1:handles.DataSet.Sensors
      fprintf(fid,'%s\n',fliplr(deblank(fliplr(deblank(handles.DataSet.labels{3}(i,:))))));
    end
    fprintf(fid,'\n');

    if ~isempty(handles.DataSet.ref)
      fprintf(fid,'%s\n','[REFDATA]');
      for i = 1:handles.DataSet.Samples
        fprintf(fid,'%d\t',handles.DataSet.ref.data(i,1:end-1));
        fprintf(fid,'%d\n',handles.DataSet.ref.data(i,end));
      end      
      fprintf(fid,'\n');

      fprintf(fid,'%s\n','[LABELS REFDATA]');
      for i = 1:size(handles.DataSet.ref.label,1)
        fprintf(fid,'%s\n',handles.DataSet.ref.label{i,1});
      end
    end
    
    % MANGLER: EXPORT AF INCLUDE/EXCLUDE - mske br det slet ikke
    % eksporteres!
    fclose(fid);
    uiwait(msgbox('Export completed!','Exporting'));
    
  case 'mFileExportModel'
    nosemodel(handles.DataSet.Model,fullfile(pathname,filename));    

    fid = fopen(fullfile(pathname,[filename(1:end-4),'_data',filename(end-3:end)]),'wt');
    for i = 1:size(handles.DataSet.preprocess.data,1)
      for j = 1:size(handles.DataSet.preprocess.data,2)
        fprintf(fid,'%d\t',squeeze(handles.DataSet.preprocess.data(i,j,1:end-1))');
        fprintf(fid,'%d\n',handles.DataSet.preprocess.data(i,j,end));
      end
    end
    fclose(fid);
end
set(handles.fSensable,'Pointer','arrow');

% --------------------------------------------------------------------
function mFileExit_Callback(hObject, eventdata, handles)

if handles.SaveDataRequired & ~handles.SaveModelRequired        % Data not saved
  answer = questdlg(['Do you want to quit?',char(10),'Unsaved data will be lost!'],'Save data before exit?','Yes','No','No');
  switch answer
    case 'Yes'
      delete(handles.ModelPlotHandles);
      delete(handles.fSensable);
    case 'No'
      return;
  end
elseif ~handles.SaveDataRequired & handles.SaveModelRequired    % Model not saved
  answer = questdlg(['Do you want to quit?',char(10),'Unsaved model will be lost!'],'Save model before exit?','Yes','No','No');
  switch answer
    case 'Yes'
      delete(handles.ModelPlotHandles);
      delete(handles.fSensable);
    case 'No'
      return;
  end
elseif handles.SaveDataRequired & handles.SaveModelRequired     % Both data and model not saved
  answer = questdlg(['Do you want to quit?',char(10),'Unsaved data and model will be lost!'],'Save data and model before exit?','Yes','No','No');
  switch answer
    case 'Yes'
      delete(handles.ModelPlotHandles);
      delete(handles.fSensable);
    case 'No'
      return;
  end
elseif ~handles.SaveDataRequired & ~handles.SaveModelRequired   % Both data and model saved - just quit!
  delete(handles.ModelPlotHandles);
  delete(handles.fSensable);
end

UpdateIniFile(handles);

% --------------------------------------------------------------------
function mFileHelp_Callback(hObject, eventdata, handles)

web(['file:///',fullfile(handles.ProgramPath,'FILE.htm')],'-browser')

% --------------------------------------------------------------------
function mEdit_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mEditIncludeExclude_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mEditIncludeExcludeDefine_Callback(hObject, eventdata, handles)

parent   = get(hObject,'Parent');
children = get(parent, 'Children');
child    = find(flipud(children) == hObject);
included = handles.DataSet.IncludedX{child};

set(handles.fSensable,'Pointer','watch','CloseRequestFcn','');
handles.CurrentOn = findobj(handles.fSensable,'Enable','on');
set(handles.CurrentOn,'Enable','off');
guidata(hObject,handles);

CurrentProgram                     = includeexclude;  % First call to open GUI
IncludeExcludeHandles              = guidata(CurrentProgram);
IncludeExcludeHandles.Mode         = child;
IncludeExcludeHandles.Labels       = handles.DataSet.labels{child};
% If Mode2 label - change from double to char
if isequal(IncludeExcludeHandles.Mode,2)
  IncludeExcludeHandles.Labels = num2str(IncludeExcludeHandles.Labels);
end
IncludeExcludeHandles.Included     = included;
IncludeExcludeHandles.IncludedOld  = included;
IncludeExcludeHandles.SaveRequired = handles.SaveDataRequired;
guidata(IncludeExcludeHandles.fIncludeExclude,IncludeExcludeHandles); % Update Editor handles before initialisation call

includeexclude('UpdateListBox',CurrentProgram, [], IncludeExcludeHandles);  % Second call to GUI for initalisation
figure(CurrentProgram);

% --------------------------------------------------------------------
function mEditDefineLabels_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mEditDefineLabelsEdit_Callback(hObject, eventdata, handles)

parent   = get(hObject,'Parent');
children = get(parent, 'Children');
child = find(flipud(children) == hObject);

set(handles.fSensable,'Pointer','watch','CloseRequestFcn','');
handles.CurrentOn = findobj(handles.fSensable,'Enable','on');
set(handles.CurrentOn,'Enable','off');
guidata(hObject,handles);

CurrentProgram                  = labeleditor;  % First call to open GUI
EditorHandles                   = guidata(CurrentProgram);
EditorHandles.Mode              = {child,handles.DataSet.mode{child}};
EditorHandles.Labels            = handles.DataSet.labels{child};
EditorHandles.Objects           = size(handles.DataSet.labels{child},1);
guidata(EditorHandles.fLabelEditor,EditorHandles); % Update Editor handles before initialisation call

set(CurrentProgram,'Pointer','watch');
labeleditor('InitialiseGUI',CurrentProgram,[],EditorHandles);  % Second call to GUI for initalisation
figure(CurrentProgram);

% --------------------------------------------------------------------
function mEditDefineGroups_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mEditDefineGroupsAll_Callback(hObject, eventdata, handles)

set(handles.fSensable,'Pointer','watch','CloseRequestFcn','');
CurrentOn = findobj(handles.fSensable,'Enable','on');
set(CurrentOn,'Enable','off');

parent   = get(hObject,'Parent');
children = flipud(get(parent, 'Children'));
child    = find(children == hObject);
set(children,       'Checked','off');
set(children(child),'Checked','on');

groups = definegroups;
set(children,'Checked','off');

if ~isempty(groups)  
  handles.DataSet.DefinedGroups{child} = groups;
  handles = UpdateColorMap(handles);
  guidata(hObject,handles);

  UpdatePlot(handles);
end
set(handles.fSensable,'Pointer','arrow','CloseRequestFcn','sensable(''mFileExit_Callback'',gcbo,[],guidata(gcbo))');
set(CurrentOn,'Enable','on');
figure(handles.fSensable);

% --------------------------------------------------------------------
function mEditColorBy_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mEditColorBySamples_Callback(hObject, eventdata, handles)

parent   = get(hObject,'Parent');
children = get(parent, 'Children');
set(children,'Checked','off');
set(hObject, 'Checked','on');

handles = UpdateColorMap(handles);
guidata(hObject,handles);

UpdatePlot(handles);

% --------------------------------------------------------------------
function mEditColorBySensors_Callback(hObject, eventdata, handles)

parent   = get(hObject,'Parent');
children = get(parent, 'Children');
set(children,'Checked','off');
set(hObject, 'Checked','on');

handles = UpdateColorMap(handles);
guidata(hObject,handles);

UpdatePlot(handles);

% --------------------------------------------------------------------
function mEditShowGrid_Callback(hObject, eventdata, handles)

if strcmpi(get(hObject,'Checked'),'on')
  set([handles.aRawData handles.aTransformedData],'XGrid','off','YGrid','off');
  set(hObject,'Checked','off');
elseif strcmpi(get(hObject,'Checked'),'off')
  set([handles.aRawData handles.aTransformedData],'XGrid','on','YGrid','on');
  set(hObject,'Checked','on');
end

% --------------------------------------------------------------------
function mEditHelp_Callback(hObject, eventdata, handles)

web(['file:///',fullfile(handles.ProgramPath,'EDIT.htm')],'-browser')

% --------------------------------------------------------------------
function mPreprocess_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mPreprocessBaseCorrection_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mPreprocessTransform_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mPreprocessFeature_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mPreprocessCenteringAndScaling_Callback(hObject, eventdata, handles)

% --------------------------------------------------------------------
function mPreprocessAll_Callback(hObject, eventdata, handles)
parent   = get(hObject,'Parent');
children = get(parent, 'Children');
set(children,'Checked','off');
set(hObject, 'Checked','on');

if strcmp(get(hObject,'Tag'),'mPreprocessFeatureSubset')
  subset = inputdlg(['Specify subset parameters: start (v) and step (w) separated by a white space:',char(10),...
                     'The time-mode contains ',num2str(sum(handles.DataSet.IncludedX{2})),' points'],...
                     'Specify how to select subset');
  if isempty(subset)          % Cancel pressed
    return;
  elseif ~isempty(subset)     % OK pressed
    subset = str2num(subset{1});
  end
  % Is the format of the input OK?
  if isempty(subset) | any(mod(subset,1)) | ~isequal(length(subset),2)
    msgbox(['Input should:',char(10),...
            '- be of integer precision',char(10),...
            '- consist of exactly two values',char(10),char(10),...
            'Values set to default: [1 1],',char(10),...
            'corresponding to the full matrix!'],'Error: wrong input','error',[],[],'modal');
    subset = [1 1];
  else    % Input OK
    if length([subset(1):subset(2):handles.DataSet.Time]) < 2
      msgbox(['The time mode should contain at least two points.',char(10),...
              'Possible values: [1,..,',num2str(handles.DataSet.Time),']',char(10),char(10),...
              'Values set to default: [1 1],',char(10),...
              'corresponding to the full matrix!'],'Error: wrong input','error',[],[],'modal');
      subset = [1 1];
    end
  end
  handles.DataSet.preprocess.FeatureSubset = subset;
end

handles = UpdatePreprocessStruct(handles);
guidata(hObject,handles);

UpdatePlot(handles);

% --------------------------------------------------------------------
function mPreprocessHelp_Callback(hObject, eventdata, handles)

web(['file:///',fullfile(handles.ProgramPath,'PREPRO.htm')],'-browser')

% --------------------------------------------------------------------
function mModel_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mModelSetParameters_Callback(hObject, eventdata, handles)

[CrossValidation,Components] = setparameters;

if isempty(CrossValidation) & isempty(Components)     % Cancel has been pressed
  return;
else
  handles.DataSet.CrossValidation = CrossValidation;
  handles.DataSet.Components      = Components;
  guidata(hObject,handles);
end

set([handles.mModelPCA handles.mModelPARAFAC handles.mModelPARAFAC2 handles.mModelPLS handles.mModelNPLS],'Enable','off');

if isequal(length(size(squeeze(handles.DataSet.preprocess.data))),2)          % 2-way data
  if  ~isequal(sum(handles.DataSet.IncludedX{1}),1)                           % More than one sample (mode = 1) included
    set(handles.mModelPCA,'Enable','on');
    if ~isempty(handles.DataSet.ref) & ~isempty(find(handles.DataSet.IncludedY))
      set(handles.mModelPLS,'Enable','on');
    end
  elseif isequal(sum(handles.DataSet.IncludedX{1}),1)                         % Only one sample (mode = 1) included
    set([handles.mModelPCA handles.mModelPLS],'Enable','off');
  end
else                                                                          % 3-way data
  set([handles.mModelPARAFAC handles.mModelPARAFAC2],'Enable','on');
  if ~isempty(handles.DataSet.ref) & ~isempty(find(handles.DataSet.IncludedY))
    set(handles.mModelNPLS,'Enable','on');
  end
end

% Update ModelInfo-box
UpdateModelInfo(handles,'');

% --------------------------------------------------------------------
function mModelYvariables_Callback(hObject, eventdata, handles)

set(handles.fSensable,'Pointer','watch','CloseRequestFcn','');
handles.CurrentOn = findobj(handles.fSensable,'Enable','on');
set(handles.CurrentOn,'Enable','off');
guidata(hObject,handles);

CurrentProgram                     = includeexclude;  % First call to open GUI
IncludeExcludeHandles              = guidata(CurrentProgram);
IncludeExcludeHandles.Mode         = 'Y';
IncludeExcludeHandles.Labels       = strvcat(handles.DataSet.ref.label{:});
IncludeExcludeHandles.Included     = handles.DataSet.IncludedY;
IncludeExcludeHandles.IncludedOld  = handles.DataSet.IncludedY;
IncludeExcludeHandles.SaveRequired = handles.SaveDataRequired;
guidata(IncludeExcludeHandles.fIncludeExclude,IncludeExcludeHandles); % Update Editor handles before initialisation call

includeexclude('UpdateListBox',CurrentProgram, [], IncludeExcludeHandles);  % Second call to GUI for initalisation
figure(CurrentProgram);

% --------------------------------------------------------------------
function mModelCalculate_Callback(hObject, eventdata, handles)

set(handles.fSensable,'Pointer','watch');

set(handles.mPlot,'Enable','on');
children = get(handles.mPlot,'Children');
set(children,'Enable','off');
CurrentOn = findobj(handles.fSensable,'Enable','on');
set(CurrentOn,'Enable','off');

set([handles.mModelPCA handles.mModelPARAFAC handles.mModelPARAFAC2 handles.mModelPLS handles.mModelNPLS],'Checked','off');

switch get(hObject,'Tag')
  case 'mModelPCA'
    set(hObject,'Checked','on');
    UpdateModelInfo(handles,'PCA');
    handles.DataSet.Model = nosemodel(squeeze(handles.DataSet.preprocess.data),[],handles.DataSet.Components,handles.DataSet.CrossValidation,1);
    set([handles.mPlotBi handles.mPlotLoadings handles.mPlotExplainedVariance handles.mPlotInfluence],'Enable','on');
    if isequal(sum(handles.DataSet.IncludedX{1}),1)
      set(handles.mPlotInfluence,'Enable','off');
    end
  case 'mModelPARAFAC'
    set(hObject,'Checked','on');
    UpdateModelInfo(handles,'PARAFAC');
    handles.DataSet.Model = nosemodel(squeeze(handles.DataSet.preprocess.data),[],handles.DataSet.Components,handles.DataSet.CrossValidation,1,1);
    set([handles.mPlotBi handles.mPlotLoadings handles.mPlotExplainedVariance handles.mPlotModelling],'Enable','on');    
  case 'mModelPARAFAC2'
    set(hObject,'Checked','on');
    UpdateModelInfo(handles,'PARAFAC2');
    handles.DataSet.Model = nosemodel(squeeze(handles.DataSet.preprocess.data),[],handles.DataSet.Components,handles.DataSet.CrossValidation,1,0);
    set([handles.mPlotBi handles.mPlotLoadings handles.mPlotExplainedVariance handles.mPlotModelling],'Enable','on');    
  case 'mModelPLS'
    set(hObject,'Checked','on');
    UpdateModelInfo(handles,'PLS');
    handles.DataSet.Model = nosemodel(squeeze(handles.DataSet.preprocess.data),...
                                      handles.DataSet.ref.data(handles.DataSet.IncludedX{1},handles.DataSet.IncludedY),...
                                      handles.DataSet.Components,handles.DataSet.CrossValidation,1);
    set([handles.mPlotBi handles.mPlotExplainedVariance handles.mPlotTU handles.mPlotPredictedMeasured],'Enable','on');    
  case 'mModelNPLS'
    set(hObject,'Checked','on');
    UpdateModelInfo(handles,'N-PLS');
    handles.DataSet.Model = nosemodel(squeeze(handles.DataSet.preprocess.data),...
                                      handles.DataSet.ref.data(handles.DataSet.IncludedX{1},handles.DataSet.IncludedY),...
                                      handles.DataSet.Components,handles.DataSet.CrossValidation,1);
    set([handles.mPlotBi handles.mPlotExplainedVariance handles.mPlotPredictedMeasured handles.mPlotTU],'Enable','on');    
end

handles.SaveModelRequired = true;
guidata(hObject,handles);

figure(handles.fSensable);

set([handles.mFileSaveModel handles.mFileExportModel handles.mPlotHelp],'Enable','on');
set(CurrentOn,'Enable','on');
set(handles.fSensable,'Pointer','arrow');

% --------------------------------------------------------------------
function mModelHelp_Callback(hObject, eventdata, handles)

web(['file:///',fullfile(handles.ProgramPath,'MODEL.htm')],'-browser')

% --------------------------------------------------------------------
function mPlot_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------
function mPlotAll_Callback(hObject, eventdata, handles)

ModelName = handles.DataSet.Model.name;
NcompMax  = handles.DataSet.Model.numbcomp;

switch get(hObject,'Tag')
  case 'mPlotBi'
    answer = inputdlg({['PC number for first axis: (1:',num2str(NcompMax),')'],...
                       ['PC number for second axis: (1:',num2str(NcompMax),')']},...
                        'Scores, Loadings, Bi-plot');
    empty  = cellfun('isempty',answer);
    ANSWER = str2num(strvcat(answer{:}));
    if isempty(empty)
      return;
    elseif any(empty) | any(ANSWER > NcompMax)
      errordlg('Wrong input specification!','Wrong input');
      return;
    end
    Method = [1,ANSWER(1),ANSWER(2)];
    Name   = strvcat([ModelName,': Scores (',  answer{1},' vs. ',answer{2},')'],...
                     [ModelName,': Loadings (',answer{1},' vs. ',answer{2},')'],...
                     [ModelName,': Bi-plot (', answer{1},' vs. ',answer{2},')']);
  case 'mPlotLoadings'
    switch handles.DataSet.Model.name
      case 'PCA'
        answer = inputdlg(['Which loading to plot? (1:',num2str(NcompMax),')'],'Loadings plots');
        empty  = cellfun('isempty',answer);
        ANSWER = str2num(strvcat(answer{:}));
        if isempty(empty)
          return;
        elseif any(empty) | any(ANSWER > NcompMax)
          errordlg('Wrong input specification!','Wrong input');
          return;
        end
        Method = [2,ANSWER(1)];
        Name   = strvcat([ModelName,': Loadings - line plot (',answer{1},')']);
      case 'PARAFAC'
        answer = inputdlg('Which mode? (Samples = 1, Time = 2, Sensors = 3)','Loadings');
        empty  = cellfun('isempty',answer);
        ANSWER = str2num(strvcat(answer{:}));
        if isempty(empty)
          return;
        elseif any(empty) | ANSWER > 3
          errordlg('Wrong input specification!','Wrong input');
          return;
        end
        Method = [2,ANSWER];
        switch ANSWER
          case 1,   Name   = strvcat([ModelName,': Loadings - Samples']);
          case 2,   Name   = strvcat([ModelName,': Loadings - Time']);
          case 3,   Name   = strvcat([ModelName,': Loadings - Sensors']);
        end
      case 'PARAFAC2'
        answerMODE = inputdlg('Which mode? (Samples = 1, Time = 2, Sensors = 3)','Loadings');
        empty  = cellfun('isempty',answerMODE);
        ANSWERMODE = str2num(strvcat(answerMODE{:}));
        if isempty(empty)
          return;
        elseif any(empty) | ANSWERMODE > 3
          errordlg('Wrong input specification!','Wrong input');
          return;
        end
        if isequal(ANSWERMODE,2)
          answerSLAB = inputdlg(['Which slab? (1:',num2str(handles.DataSet.Sensors),')'],'Loadings');
          empty  = cellfun('isempty',answerSLAB);
          ANSWERSLAB = str2num(strvcat(answerSLAB{:}));
          if isempty(empty)
            return;
          elseif any(empty) | ANSWERSLAB > handles.DataSet.Sensors
            errordlg('Wrong input specification!','Wrong input');
            return;
          end
          Method = [2,ANSWERMODE,ANSWERSLAB];
        else
          Method = [2,ANSWERMODE,1];
        end
        switch ANSWERMODE
          case 1,   Name   = strvcat([ModelName,': Loadings - Samples']);
          case 2,   Name   = strvcat([ModelName,': Loadings - Time (slab = ',answerSLAB{1},')']);
          case 3,   Name   = strvcat([ModelName,': Loadings - Sensors']);
        end
    end
  case 'mPlotExplainedVariance'
    Method = 3;
    if strmatch(handles.DataSet.Model.name,{'PLS','NPLS'})
      Name   = strvcat([ModelName,': Explained variance - X'],...
                       [ModelName,': Explained variance - Y']);
    else
      Name   = strvcat([ModelName,': Explained variance - X']);
    end      
  case 'mPlotInfluence'
    Method = 4;
    Name   = [ModelName,': Influence plot'];
  case 'mPlotModelling'
    answer = inputdlg('Which slab?','Modelling plots');
    empty  = cellfun('isempty',answer);
    ANSWER = str2num(strvcat(answer{:}));
    if isempty(empty)
      return;
    elseif any(empty) | any(ANSWER > handles.DataSet.Sensors)
      errordlg('Wrong input specification!','Wrong input');
      return;
    end
    Method = [5,ANSWER(1)];
    Name   = strvcat([ModelName,': Modelling plot - pre-processed data (',answer{1},')'],...
                     [ModelName,': Modelling plot - model (',answer{1},')'],...
                     [ModelName,': Modelling plot - residuals (',answer{1},')']);
  case 'mPlotTU'
    answer = inputdlg(['Number of components? (1:',num2str(NcompMax),')'],'T vs. U');
    empty  = cellfun('isempty',answer);
    ANSWER = str2num(strvcat(answer{:}));
    if isempty(empty)
      return;
    elseif any(empty) | any(ANSWER > NcompMax)
      errordlg('Wrong input specification!','Wrong input');
      return;
    end
    Method = [6,ANSWER(1)];
    Name   = strvcat([ModelName,': T vs. U (PC = ',answer{1},')']);
  case 'mPlotPredictedMeasured'
    if isequal(size(handles.DataSet.Model.ypredictions,3),1)  % Only one Y-variable included in the model
      answerCOMP = inputdlg(['Number of components? (1:',num2str(NcompMax),')'],'Predicted vs. Measured');
      empty  = cellfun('isempty',answerCOMP);
      ANSWERCOMP = str2num(strvcat(answerCOMP{:}));
      if isempty(empty)
        return;
      elseif any(empty) | any(ANSWERCOMP(1) > NcompMax)
        errordlg('Wrong input specification!','Wrong input');
        return;
      end
      answer{2} = 1;
      Method = [7,ANSWERCOMP,answer{2}];
    elseif ~isequal(size(handles.DataSet.Model.ypredictions,3),1)  % More than one Y-variable included in the model
      answer = inputdlg({['Number of components? (1:',num2str(NcompMax),')'],...
                         ['Which Y-variable? (1:',num2str(size(handles.DataSet.Model.ypredictions,2)),')']},'Predicted vs. Measured');
      empty  = cellfun('isempty',answer);
      ANSWER = str2num(strvcat(answer{:}));
      if isempty(empty)
        return;
      elseif any(empty) | any(ANSWER(1) > NcompMax) | any(ANSWER(2) > size(handles.DataSet.Model.ypredictions,2)) | ~find(ANSWER(2) == [1:size(handles.DataSet.Model.ypredictions,2)])
        errordlg('Wrong input specification!','Wrong input');
        return;
      end
      Method = [7,ANSWER(1),ANSWER(2)];
    end
    Name   = strvcat([ModelName,': Predicted vs. Measured (PC = ',answer{1},', Y-variable = ',answer{2},')']);
end

for i=1:size(Name,1)
  CurrentPlot = length(handles.ModelPlotHandles)+1;
  handles.ModelPlotHandles(CurrentPlot) = figure;
  if isequal(size(Name,1),1)
    noseplot(handles.DataSet.Model,handles.DataSet,handles.DataSet.preprocess,Method);
  else
    noseplot(handles.DataSet.Model,handles.DataSet,handles.DataSet.preprocess,[Method(1),i,Method(2:end)]);
  end
  set(handles.ModelPlotHandles(CurrentPlot),'CloseRequestFcn','sensable(''UpdateModelPlotHandles_Callback'',gcbo,[],guidata(gcbo))',...
                                            'Name',Name(i,:));    
end

guidata(hObject,handles);
set(handles.mPlotCloseAll,'Enable','on');

% --------------------------------------------------------------------
function mPlotCloseAll_Callback(hObject, eventdata, handles)

for i=1:length(handles.ModelPlotHandles)
  delete(handles.ModelPlotHandles(i));
end
handles.ModelPlotHandles = [];
guidata(hObject,handles);
set(hObject,'Enable','off');

% --------------------------------------------------------------------
function mPlotHelp_Callback(hObject, eventdata, handles)

web(['file:///',fullfile(handles.ProgramPath,'PLOT.htm')],'-browser')

% --------------------------------------------------------------------
function mAbout_Callback(hObject, eventdata, handles)

about;  % Call the About-GUI

% --------------------------------------------------------------------
function etProcessInfo_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
% --------------------------------------------------------------------
function etProcessInfo_Callback(hObject, eventdata, handles)


% --------------------------------------------------------------------
function etModelInfo_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
% --------------------------------------------------------------------
function etModelInfo_Callback(hObject, eventdata, handles)



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% User functions below %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function InitialiseGUI(handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MANGLER: Overfldige eller ikke implementeret endnu! %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%set(handles.mEditDefineGroups,'Enable','off');
%set(handles.mEditIncludeExcludeTime,'Enable','off');
set(handles.mPreprocessFeatureIntegral,'Enable','off');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

set([handles.mFileExportData handles.mFileExportModel handles.mFileSaveModel handles.mFileSaveData],'Enable','off');
set([handles.mEdit handles.mPreprocess handles.mPlot handles.mModel],'Enable','off');
set([handles.mModelPCA handles.mModelPARAFAC handles.mModelPARAFAC2 handles.mModelPLS handles.mModelNPLS],'Enable','off'); % Should only be accessable when model parameters have been set!

children = [get(handles.mPreprocessBaseCorrection,'Child');,...
            get(handles.mPreprocessTransform,'Child');,...
            get(handles.mPreprocessFeature,'Child');,...
            get(handles.mPreprocessCenteringAndScaling,'Child')];
set(children,'Checked','off');
set([handles.mPreprocessBaseCorrectionNone handles.mPreprocessTransformNone ...
     handles.mPreprocessFeatureNone handles.mPreprocessCenteringAndScalingNone],'Checked','on');
set([handles.mEditColorBySamples handles.mEditShowGrid],'Checked','on');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = UpdateFileMenu(handles);

% Create file menu
if ~isfield(handles,'mFilePreviousFiles')
  NumFileChildren = length(get(handles.mFile,'Children'));
  for i = 1:handles.MaxPreviousFiles     % Create blank and invisible menu-points
    if isequal(i,1)
      handles.mFilePreviousFiles(i) = uimenu('Callback', 'sensable(''mFPF_Callback'',gcbo,[],guidata(gcbo))',...
                                             'Enable',   'off',...
                                             'Parent',   handles.mFile,...
                                             'Position', NumFileChildren+i,...
                                             'Separator','on',...
                                             'Visible',  'off');
    else
      handles.mFilePreviousFiles(i) = uimenu('Callback', 'sensable(''mFPF_Callback'',gcbo,[],guidata(gcbo))',...
                                             'Enable',   'off',...
                                             'Parent',   handles.mFile,...
                                             'Position', NumFileChildren+i,...
                                             'Visible',  'off');
    end
  end
end

% Populate and enable menu-points
if ~isempty(handles.PreviousFiles)
  for i=1:size(handles.PreviousFiles,1)
    set(handles.mFilePreviousFiles(i),'Enable',  'on',...
                                      'Label',  ['&',num2str(i),' ',handles.PreviousFiles(i,:)],...
                                      'Tag',    ['FileMenuPreviourFiles',num2str(i)],...
                                      'Visible','on');
  end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function UpdateIniFile(handles);

% Update ini-file
fid = fopen(fullfile(handles.ProgramPath,'sensable.ini'),'wt');

fprintf(fid,'%s\n','[PREVIOUSFILES]');
for i = 1:size(handles.PreviousFiles,1)
  fprintf(fid,'%s\n',handles.PreviousFiles(i,:));
end
fprintf(fid,'\n');
fprintf(fid,'%s\n','[LASTPATH]');
fprintf(fid,'%s\n\n',pwd);

fclose(fid);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function UpdatePlot(varargin);

if isequal(nargin,1)
  handles = varargin{1};    % Call from fSensable
else
  handles = varargin{3};    % Call from model plots
end

set(handles.fSensable,'Pointer','watch');

cla(handles.aRawData);
reset(handles.aRawData);
cla(handles.aTransformedData);
reset(handles.aTransformedData);
set([handles.aRawData handles.aTransformedData],'NextPlot','add');

preprocess = strmatch('None',handles.DataSet.preprocess.label);

XaxisRaw         = [1:sum(handles.DataSet.IncludedX{2})];
XaxisTransformed = [1:size(handles.DataSet.preprocess.data,2)];
ID   = find(handles.DataSet.IncludedX{3});
for i = 1:length(ID)
  axes(handles.aRawData);
  set(handles.aRawData,'ColorOrder',handles.ColorMap(:,:,i));
  plot(XaxisRaw,squeeze(handles.DataSet.data(handles.DataSet.IncludedX{1},handles.DataSet.IncludedX{2},ID(i))))
end
if ~isequal(length(preprocess),4)  % Only plot preprocessed data if one or more selections have been made
  for i = 1:size(handles.DataSet.preprocess.data,3)
    axes(handles.aTransformedData);
    set(handles.aTransformedData,'ColorOrder',handles.ColorMap(:,:,i));
    plot(XaxisTransformed,squeeze(handles.DataSet.preprocess.data(:,:,i)))  % preprocessed data only contains included elements
  end
end

axes(handles.aRawData);
axis tight;
zoom on;
if all(preprocess)
  axes(handles.aTransformedData);
  axis tight;
  zoom on;
end

if strcmpi(get(handles.mEditShowGrid,'Checked'),'on')
  set([handles.aRawData handles.aTransformedData],'XGrid','on','YGrid','on');
end

set(handles.fSensable,'Pointer','arrow');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = UpdateColorMap(handles);

% ColorMap without defined-groups
%if     strcmpi(get(handles.mEditColorBySamples,'Checked'),'on')
%  map = colormap(jet(sum(handles.DataSet.IncludedX{1})));
%  map = repmat(map,[1,1,sum(handles.DataSet.IncludedX{3})]);
%elseif strcmpi(get(handles.mEditColorBySensors,'Checked'),'on')
%  map = colormap(jet(sum(handles.DataSet.IncludedX{3})));
%  map = repmat(map,[1,1,sum(handles.DataSet.IncludedX{1})]);
%  map = permute(map,[3,2,1]);
%end

if     strcmpi(get(handles.mEditColorBySamples,'Checked'),'on')
  Ngroups = length(find(diff(sort(handles.DataSet.DefinedGroups{1}))))+1;
  Gmap    = colormap(jet(Ngroups));
  for i = 1:Ngroups
    CurrentGroup = find(handles.DataSet.DefinedGroups{1} == i);
    if any(CurrentGroup)
      map(CurrentGroup,:) = ones(length(CurrentGroup),3)*diag(Gmap(i,:));
    end
  end
  map = map(handles.DataSet.IncludedX{1},:);
  map = repmat(map,[1,1,sum(handles.DataSet.IncludedX{3})]);
elseif strcmpi(get(handles.mEditColorBySensors,'Checked'),'on')
  Ngroups = length(find(diff(sort(handles.DataSet.DefinedGroups{2}))))+1;
  Gmap    = colormap(jet(Ngroups));
  for i = 1:Ngroups
    CurrentGroup = find(handles.DataSet.DefinedGroups{2} == i);
    if any(CurrentGroup)
      map(CurrentGroup,:) = ones(length(CurrentGroup),3)*diag(Gmap(i,:));
    end
  end
  map = map(handles.DataSet.IncludedX{3},:);
  map = repmat(map,[1,1,sum(handles.DataSet.IncludedX{1})]);
  map = permute(map,[3,2,1]);
end

handles.ColorMap = map;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = UpdatePreprocessStruct(handles);

ParentObjects = {handles.mPreprocessBaseCorrection,handles.mPreprocessTransform,...
                 handles.mPreprocessFeature,handles.mPreprocessCenteringAndScaling};
labels        = cell(length(ParentObjects),1);
IDs           = cell(length(ParentObjects),1);
for i=1:length(ParentObjects)
  children     = flipud(get(ParentObjects{i},'Children'));    % "flipud" due to objects ordered upside-down
  checked      = get(children,'Checked');
  ID           = strmatch('on',checked);
  IDs{i,1}     = ID - 1;                                      % "-1" due to None = 0
  label        = get(children(ID),'Label');
  ID           = strfind(label,'&');
  label(ID)    = [];      
  labels{i,1}  = label;
end

OldLabels = handles.DataSet.preprocess.label;
OldID     = handles.DataSet.preprocess.ID;
if ~isequal(OldID,IDs)
  handles.DataSet.preprocess.label = labels;
  handles.DataSet.preprocess.ID    = IDs;

  handles = UpdatePreprocessData(handles);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = UpdatePreprocessData(varargin);

if isequal(nargin,1)
  handles = varargin{1};    % Call from fSensable
else
  handles = varargin{3};    % Call from Include/Exclude
end

[baseline,transform,feature,centscal] = deal(handles.DataSet.preprocess.ID{:});
feature = [feature,handles.DataSet.preprocess.FeatureSubset];
options = 0;  % No plot to screen
%handles.DataSet.preprocess.data  = noseproc(handles.DataSet.data(handles.DataSet.IncludedX{1},...
%                                                                 handles.DataSet.IncludedX{2},...
%                                                                 handles.DataSet.IncludedX{3}),...
%                                                                 baseline,transform,feature,centscal,options);
handles.DataSet.preprocess.data  = noseproc(handles.DataSet,baseline,transform,feature,centscal,options);

UpdatePreprocessInfo(handles);
PreprocessEnableControl(handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function UpdatePreprocessInfo(handles);

% Update pre-process info
ParentObjects = {handles.mPreprocessBaseCorrection,handles.mPreprocessTransform,...
                 handles.mPreprocessFeature,handles.mPreprocessCenteringAndScaling};
TextString    = {'Base correction:','Transform:','Feature:','Centering & scaling:'};
str           = [];
for i=1:length(ParentObjects)
  if isequal(ParentObjects{i},handles.mPreprocessFeature) & isequal(handles.DataSet.preprocess.ID{i,1},1)
    str = strvcat(str,sprintf('%-22s%s',TextString{i},...
                  horzcat(handles.DataSet.preprocess.label{i},...
                          [' [',num2str(handles.DataSet.preprocess.FeatureSubset(1)),',',...
                               num2str(handles.DataSet.preprocess.FeatureSubset(2)),']'])));    
  else
    str = strvcat(str,sprintf('%-22s%s',TextString{i},handles.DataSet.preprocess.label{i}));
  end
end
set(handles.etProcessInfo,'String',str);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function PreprocessEnableControl(varargin);

if isequal(nargin,1)
  handles = varargin{1};    % Call from fSensable
else
  handles = varargin{3};    % Call from Include/Exclude
end

% Pre-processing
dim = size(squeeze(handles.DataSet.preprocess.data));
if isequal(length(dim),2)
  if ~strcmpi(get(handles.mPreprocessFeatureAbsoluteMaximum,'Checked'),'on') & ...
     ~strcmpi(get(handles.mPreprocessFeatureMaximalSlope,   'Checked'),'on') & ...
     ~strcmpi(get(handles.mPreprocessFeatureMinimalSlope,   'Checked'),'on') & ...
     ~strcmpi(get(handles.mPreprocessFeatureUnfold,   'Checked'),'on')
    set([handles.mPreprocessFeatureAbsoluteMaximum ...
         handles.mPreprocessFeatureMaximalSlope ...
         handles.mPreprocessFeatureMinimalSlope ...
         handles.mPreprocessFeatureUnfold],'Enable','off');            % A vector will result - this is not allowed
  end
  if isequal(sum(handles.DataSet.IncludedX{1}),1) | isequal(sum(handles.DataSet.IncludedX{3}),1)
    set(get(handles.mPreprocessCenteringAndScaling,'Children'),'Checked','off','Enable','off');
    set(handles.mPreprocessCenteringAndScalingNone,'Checked','on');
  end
elseif isequal(length(dim),3)
  set([handles.mPreprocessFeatureAbsoluteMaximum ...
       handles.mPreprocessFeatureMaximalSlope ...
       handles.mPreprocessFeatureMinimalSlope ...
       handles.mPreprocessFeatureUnfold],'Enable','on');
  set(get(handles.mPreprocessCenteringAndScaling,'Children'),'Enable','on');
end
% MANGLER: Ikke implementeret endnu!
set(handles.mPreprocessFeatureIntegral,'Enable','off');


% Modelling
if isempty(handles.DataSet.CrossValidation) & isempty(handles.DataSet.Components)
  set([handles.mModelPCA handles.mModelPLS handles.mModelPARAFAC handles.mModelPARAFAC2 handles.mModelNPLS],'Enable','off');
else
  dim = size(squeeze(handles.DataSet.preprocess.data));
  if isequal(length(dim),2)
    if  ~isequal(sum(handles.DataSet.IncludedX{1}),1)       % More than one sample reamining in first mode
      set(handles.mModelPCA,'Enable','on');
      if      isempty(find(handles.DataSet.IncludedY))
        set(handles.mModelPLS,'Enable','off');
      elseif ~isempty(find(handles.DataSet.IncludedY))
        set(handles.mModelPLS,'Enable','on');
      end
    elseif isequal(sum(handles.DataSet.IncludedX{1}),1)     % Only one sample reamining in first mode
      set([handles.mModelPCA handles.mModelPLS],'Enable','off');
    end
    set([handles.mModelPARAFAC handles.mModelPARAFAC2 handles.mModelNPLS],'Enable','off');
  elseif isequal(length(dim),3)
    set([handles.mModelPARAFAC handles.mModelPARAFAC2],'Enable','on');
    if      isempty(find(handles.DataSet.IncludedY))
      set(handles.mModelNPLS,'Enable','off');
    elseif ~isempty(find(handles.DataSet.IncludedY))
      set(handles.mModelNPLS,'Enable','on');
    end    
    set([handles.mModelPCA handles.mModelPLS],'Enable','off');
  end
end
set([handles.mModelPCA handles.mModelPLS handles.mModelPARAFAC handles.mModelPARAFAC2 handles.mModelNPLS],'Checked','off');

% Plotting
set(handles.mPlot,'Enable','off');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function UpdateModelInfo(varargin);

if isequal(nargin,2)
  handles = varargin{1};    % Call from fSensable
  model   = varargin{2};
else
  handles = varargin{3};    % Call from InfludeExclude
  model   = varargin{4};
end

str = [];
str = strvcat(str,sprintf('%-23s%s','Model:',model));
str = strvcat(str,sprintf('%-23s%d','Number of components:',handles.DataSet.Components));
if handles.DataSet.CrossValidation
  str = strvcat(str,sprintf('%-23s%s','Cross-validation:','Yes'));
elseif ~handles.DataSet.CrossValidation
  str = strvcat(str,sprintf('%-23s%s','Cross-validation:','No'));
end
switch model
  case {'','PLS','N-PLS'}
    ExcludedY = find(~handles.DataSet.IncludedY)';
    if isempty(ExcludedY)
      ID = 'None';
    else
      ID = num2str(ExcludedY);
    end
    str = strvcat(str,sprintf('%-23s%s','Excluded Y-variables:',ID));
  otherwise
    str = strvcat(str,sprintf('%-23s%s','Excluded Y-variables:','-'));
end
set(handles.etModelInfo,'String',str);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function UpdateModelPlotHandles_Callback(hObject, eventdata, FigureHandles);

SensableHandles = findobj('Tag','fSensable');
SensableHandles = guidata(SensableHandles);

I = find(SensableHandles.ModelPlotHandles == hObject);
SensableHandles.ModelPlotHandles(I) = [];
if isempty(SensableHandles.ModelPlotHandles)
  set(SensableHandles.mPlotCloseAll,'Enable','off');
end
guidata(SensableHandles.fSensable,SensableHandles);

delete(hObject);