function varargout = labeleditor(varargin)
% LABELEDITOR M-file for labeleditor.fig
%      LABELEDITOR, by itself, creates a new LABELEDITOR or raises the existing
%      singleton*.
%
%      H = LABELEDITOR returns the handle to a new LABELEDITOR or the handle to
%      the existing singleton*.
%
%      LABELEDITOR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LABELEDITOR.M with the given input arguments.
%
%      LABELEDITOR('Property','Value',...) creates a new LABELEDITOR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before labeleditor_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to labeleditor_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help labeleditor

% Last Modified by GUIDE v2.5 03-Jan-2004 19:37:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @labeleditor_OpeningFcn, ...
                   'gui_OutputFcn',  @labeleditor_OutputFcn, ...
                   'gui_LayoutFcn',  @labeleditor_LayoutFcn, ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before labeleditor is made visible.
function labeleditor_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to labeleditor (see VARARGIN)

% Choose default command line output for labeleditor
handles.output = hObject;

% If the program is run alone SaveRequired must be set in order to be able to
% close the program window.
handles.SaveRequired = false;

% Default settings (in pixel)
handles.DefaultObjIDWidth    = 50;
handles.DefaultObjLabelWidth = 150;
handles.DefaultCellHeight    = 21;
handles.DefaultSliderHW      = 16;
handles.DefaultGap           = 2;
handles.DefaultBorder        = 10;

% Position figure on screen
set(handles.fLabelEditor,'Units','Pixel');
pos = get(handles.fLabelEditor,'Position');
pos(3:4) = [handles.DefaultBorder+handles.DefaultObjIDWidth+handles.DefaultObjLabelWidth+handles.DefaultGap+handles.DefaultSliderHW, ...
            20*handles.DefaultCellHeight + 2*handles.DefaultBorder];
set(handles.fLabelEditor,'Position',pos);
%movegui(handles.fLabelEditor,'center');
set(handles.fLabelEditor,'Units','Character');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes labeleditor wait for user response (see UIRESUME)
% uiwait(handles.fLabelEditor);

% --- Outputs from this function are returned to the command line.
function varargout = labeleditor_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --------------------------------------------------------------------
% --------------------------------------------------------------------
% --------------------------------------------------------------------
function mExit_Callback(hObject, eventdata, handles)

SensableHandles = findobj('Tag','fSensable');
if ~isempty(SensableHandles)        % The LabelEditor GUI has been called from Sensable
  SensableHandles = guidata(SensableHandles);
  if handles.SaveRequired
    ButtonName=questdlg(['Data have been changed.',char(10),...
                         'Do you want to update data?'],'Exit label editor?','Yes','No','Cancel','Yes');
    switch ButtonName
      case 'Yes'
        temp = char(handles.Labels);
        if isequal(handles.Mode{1},2)
          temp = str2num(temp);
        end
        SensableHandles.DataSet.labels{handles.Mode{1}}  = temp;
        SensableHandles.SaveDataRequired                 = true;
%        SensableHandles = sensable('UpdateGUI',SensableHandles.fSensable,[],SensableHandles);

        guidata(SensableHandles.fSensable,SensableHandles); % Update LatentiX handles to store latest changes

        set(SensableHandles.fSensable,'Name',['SENSABLE - Program for analysis of electronic nose data - ',fullfile(SensableHandles.PathName,SensableHandles.FileName),'*']);  % Because of SaveDataRequired
        set(SensableHandles.CurrentOn,'Enable','on');
        set(SensableHandles.fSensable,'CloseRequestFcn','sensable(''mFileExit_Callback'',gcbo,[],guidata(gcbo))');
        set(SensableHandles.fSensable,'Pointer','arrow');
        delete(handles.fLabelEditor);
        figure(SensableHandles.fSensable);
      case 'No'
        set(SensableHandles.CurrentOn,'Enable','on');
        set(SensableHandles.fSensable,'CloseRequestFcn','sensable(''mFileExit_Callback'',gcbo,[],guidata(gcbo))');
        set(SensableHandles.fSensable,'Pointer','arrow');
        delete(handles.fLabelEditor);
        figure(SensableHandles.fSensable);
      case 'Cancel'
        return;
    end
  elseif ~handles.SaveRequired
    set(SensableHandles.CurrentOn,'Enable','on');
    set(SensableHandles.fSensable,'CloseRequestFcn','sensable(''mFileExit_Callback'',gcbo,[],guidata(gcbo))');
    set(SensableHandles.fSensable,'Pointer','arrow');
    delete(handles.fLabelEditor);
    figure(SensableHandles.fSensable);
  end
elseif isempty(SensableHandles)     % The LabelEditor GUI has been called from Sensable
  delete(handles.fLabelEditor);  
end

% --------------------------------------------------------------------
function VSlider_Callback(hObject, eventdata, handles)

Vpos = get(handles.VSlider,'Max')-round(get(handles.VSlider,'Value'))+1;

% "Move labels and ID
for i=1:handles.NumRow
  set(handles.CellHandles.ObjLabels(i),'String',handles.Labels(Vpos+i-1,:));
  set(handles.CellHandles.ObjID(i),    'String',num2str(Vpos+i-1));
end

% --------------------------------------------------------------------
function GridEdit_Callback(hObject, eventdata, handles)

str = fliplr(deblank(fliplr(deblank(get(hObject,'String')))));
ID = find(hObject == handles.CellHandles.ObjLabels);
if ~strcmpi(str,handles.Labels(ID,:))
  handles.Labels(ID,:) = str;
  handles.SaveRequired = true;
  guidata(hObject,handles);
  set(handles.fLabelEditor,'Name',['Edit label: ',handles.Mode{2},'*']);
end
figure(handles.fLabelEditor);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function handles = InitialiseGUI(hObject, eventdata, handles);

set(handles.fLabelEditor,'Pointer','watch','Units','pixel');
set(handles.fLabelEditor,'Name',['Edit label: ',handles.Mode{2}]);

% If Mode2 label - change from double to char
if isequal(handles.Mode{1},2)
  handles.Labels = num2str(handles.Labels);
end
handles.Labels = cellstr(handles.Labels);

% Get current figure size
pos = get(handles.fLabelEditor,'Position');

% Max number of visible rows containing data
handles.NumRow = floor((pos(4)-2*handles.DefaultBorder)/handles.DefaultCellHeight);
if handles.NumRow > handles.Objects
  handles.NumRow = handles.Objects;
  pos(4) = handles.NumRow*handles.DefaultCellHeight + 2*handles.DefaultBorder;
  set(handles.fLabelEditor,'Position',pos);
end
movegui(handles.fLabelEditor,'center');
figure(handles.fLabelEditor);
drawnow
%set(handles.fLabelEditor,'Visible','on');

Vpos = 1;
[handles,Vpos] = CreateGrid(handles,Vpos);

% Check if sliders should be enabled or not
if handles.NumRow < handles.Objects
  set(handles.VSlider,'Enable','on','Min',1,'Max',handles.Objects-handles.NumRow+1,...
                      'SliderStep',[1/(handles.Objects-handles.NumRow), 10/(handles.Objects-handles.NumRow)],...
                      'Value',handles.Objects-handles.NumRow+1);
end

set(handles.fLabelEditor,'Pointer','arrow','Units','pixel');

guidata(hObject,handles);
figure(handles.fLabelEditor);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [handles,Vpos] = CreateGrid(handles,Vpos);

% Get current figure size
pos = get(handles.fLabelEditor,'Position');

% Initialise handles variables
handles.CellHandles.ObjID     = zeros(1,handles.NumRow);
handles.CellHandles.ObjLabels = zeros(1,handles.NumRow);

% Create Row-labels and ID's
for i=1:handles.NumRow
  handles.CellHandles.ObjID(i) = uicontrol(...
    'Parent',               handles.fLabelEditor, ...
    'Style',                'pushbutton', ...
    'HorizontalAlignment',  'center', ...
    'Callback',             '',...
    'Clipping',             'on',...
    'Enable',               'inactive', ...
    'Tag',                  'LabelID', ...
    'Units',                'pixels', ...
    'Position',             [handles.DefaultBorder,pos(4)-i*handles.DefaultCellHeight-handles.DefaultBorder,handles.DefaultObjIDWidth,handles.DefaultCellHeight], ...
    'String',               num2str(i), ...
    'Visible',              'off');
  
  handles.CellHandles.ObjLabels(i) = uicontrol(...
    'Parent',               handles.fLabelEditor, ...
    'Style',                'edit', ...
    'HorizontalAlignment',  'right', ...
    'BackgroundColor',      [1,1,1], ...
    'Callback',             'labeleditor(''GridEdit_Callback'',gcbo,[],guidata(gcbo))',...
    'Clipping',             'on',...
    'Enable',               'on', ...
    'Tag',                  'Label', ...
    'Units',                'pixels', ...
    'Position',             [handles.DefaultBorder+handles.DefaultObjIDWidth,pos(4)-i*handles.DefaultCellHeight-handles.DefaultBorder,handles.DefaultObjLabelWidth,handles.DefaultCellHeight], ...
    'String',               deblank(fliplr(deblank(fliplr(handles.Labels(i,:))))), ...
    'Visible',              'off');
end

% Set units back to "characters" for scaling purposes
%set([handles.CellHandles.ObjLabels handles.CellHandles.ObjID],'Units','characters','Visible','on');
set([handles.fLabelEditor handles.CellHandles.ObjLabels handles.CellHandles.ObjID],'Units','characters','Visible','on');

VSliderPos = [handles.DefaultBorder+handles.DefaultObjIDWidth+handles.DefaultObjLabelWidth+handles.DefaultGap, pos(4)-handles.NumRow*handles.DefaultCellHeight-handles.DefaultBorder,...
              handles.DefaultSliderHW, handles.NumRow*handles.DefaultCellHeight];%pos(4)-handles.DefaultBorder];

% Create vertical slider
handles.VSlider = uicontrol('Parent',handles.fLabelEditor,...
                            'Style',      'Slider',...
                            'Callback',   'labeleditor(''VSlider_Callback'',gcbo,[],guidata(gcbo))',...
                            'Enable',     'off',...
                            'Units',      'pixel',...
                            'Position',   VSliderPos,...
                            'Visible',    'on');

% Set units back to "characters" for scaling purposes
set([handles.fLabelEditor handles.VSlider],'Units','characters');



% --- Creates and returns a handle to the GUI figure. 
function h1 = labeleditor_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

h1 = figure(...
'Units','characters',...
'PaperUnits',get(0,'defaultfigurePaperUnits'),...
'CloseRequestFcn','labeleditor(''mExit_Callback'',gcbo,[],guidata(gcbo))',...
'Color',[0.831372549019608 0.815686274509804 0.784313725490196],...
'Colormap',[0 0 0.5625;0 0 0.625;0 0 0.6875;0 0 0.75;0 0 0.8125;0 0 0.875;0 0 0.9375;0 0 1;0 0.0625 1;0 0.125 1;0 0.1875 1;0 0.25 1;0 0.3125 1;0 0.375 1;0 0.4375 1;0 0.5 1;0 0.5625 1;0 0.625 1;0 0.6875 1;0 0.75 1;0 0.8125 1;0 0.875 1;0 0.9375 1;0 1 1;0.0625 1 1;0.125 1 0.9375;0.1875 1 0.875;0.25 1 0.8125;0.3125 1 0.75;0.375 1 0.6875;0.4375 1 0.625;0.5 1 0.5625;0.5625 1 0.5;0.625 1 0.4375;0.6875 1 0.375;0.75 1 0.3125;0.8125 1 0.25;0.875 1 0.1875;0.9375 1 0.125;1 1 0.0625;1 1 0;1 0.9375 0;1 0.875 0;1 0.8125 0;1 0.75 0;1 0.6875 0;1 0.625 0;1 0.5625 0;1 0.5 0;1 0.4375 0;1 0.375 0;1 0.3125 0;1 0.25 0;1 0.1875 0;1 0.125 0;1 0.0625 0;1 0 0;0.9375 0 0;0.875 0 0;0.8125 0 0;0.75 0 0;0.6875 0 0;0.625 0 0;0.5625 0 0],...
'IntegerHandle','off',...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'MenuBar','none',...
'Name','Edit lable:',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'PaperSize',[20.98404194812 29.67743169791],...
'PaperType',get(0,'defaultfigurePaperType'),...
'Position',[100 30 1 1],...
'Renderer',get(0,'defaultfigureRenderer'),...
'RendererMode','manual',...
'Resize','off',...
'HandleVisibility','callback',...
'Tag','fLabelEditor',...
'UserData',[],...
'Visible','off');

setappdata(h1, 'GUIDEOptions',struct(...
'active_h', [], ...
'taginfo', struct(...
'figure', 2), ...
'override', 0, ...
'release', 13, ...
'resize', 'none', ...
'accessibility', 'callback', ...
'mfile', 1, ...
'callbacks', 1, ...
'singleton', 1, ...
'syscolorfig', 1, ...
'blocking', 0, ...
'lastSavedFile', 'N:\Henrik\DataAnalyse.dk\Elektronisk nse\labeleditor.m'));


h2 = uimenu(...
'Parent',h1,...
'Callback','labeleditor(''mExit_Callback'',gcbo,[],guidata(gcbo))',...
'Label','E&xit',...
'Tag','mExit');


hsingleton = h1;


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)


%   GUI_MAINFCN provides these command line APIs for dealing with GUIs
%
%      LABELEDITOR, by itself, creates a new LABELEDITOR or raises the existing
%      singleton*.
%
%      H = LABELEDITOR returns the handle to a new LABELEDITOR or the handle to
%      the existing singleton*.
%
%      LABELEDITOR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LABELEDITOR.M with the given input arguments.
%
%      LABELEDITOR('Property','Value',...) creates a new LABELEDITOR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before untitled_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to untitled_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".

%   Copyright 1984-2002 The MathWorks, Inc.
%   $Revision: 1.5 $ $Date: 2003/07/17 18:28:28 $

gui_StateFields =  {'gui_Name'
                    'gui_Singleton'
                    'gui_OpeningFcn'
                    'gui_OutputFcn'
                    'gui_LayoutFcn'
                    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);        
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [getfield(gui_State, gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % LABELEDITOR
    % create the GUI
    gui_Create = 1;
elseif numargin > 3 & ischar(varargin{1}) & ishandle(varargin{2})
    % LABELEDITOR('CALLBACK',hObject,eventData,handles,...)
    gui_Create = 0;
else
    % LABELEDITOR(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = 1;
end

if gui_Create == 0
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else
        feval(varargin{:});
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.
    
    % Do feval on layout code in m-file if it exists
    if ~isempty(gui_State.gui_LayoutFcn)
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        end
    end
    
    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    
    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig 
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA
        guidata(gui_hFigure, guihandles(gui_hFigure));
    end
    
    % If user specified 'Visible','off' in p/v pairs, don't make the figure
    % visible.
    gui_MakeVisible = 1;
    for ind=1:2:length(varargin)
        if length(varargin) == ind
            break;
        end
        len1 = min(length('visible'),length(varargin{ind}));
        len2 = min(length('off'),length(varargin{ind+1}));
        if ischar(varargin{ind}) & ischar(varargin{ind+1}) & ...
                strncmpi(varargin{ind},'visible',len1) & len2 > 1
            if strncmpi(varargin{ind+1},'off',len2)
                gui_MakeVisible = 0;
            elseif strncmpi(varargin{ind+1},'on',len2)
                gui_MakeVisible = 1;
            end
        end
    end
    
    % Check for figure param value pairs
    for index=1:2:length(varargin)
        if length(varargin) == index
            break;
        end
        try, set(gui_hFigure, varargin{index}, varargin{index+1}), catch, break, end
    end

    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end
    
    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});
    
    if ishandle(gui_hFigure)
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
        
        % Make figure visible
        if gui_MakeVisible
            set(gui_hFigure, 'Visible', 'on')
            if gui_Options.singleton 
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        rmappdata(gui_hFigure,'InGUIInitialization');
    end
    
    % If handle visibility is set to 'callback', turn it on until finished with
    % OutputFcn
    if ishandle(gui_hFigure)
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end
    
    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end
    
    if ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end    

function gui_hFigure = local_openfig(name, singleton)
try
    gui_hFigure = openfig(name, singleton, 'auto');
catch
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
end

