function varargout = includeexclude(varargin)
% INCLUDEEXCLUDE M-file for includeexclude.fig
%      INCLUDEEXCLUDE, by itself, creates a new INCLUDEEXCLUDE or raises the existing
%      singleton*.
%
%      H = INCLUDEEXCLUDE returns the handle to a new INCLUDEEXCLUDE or the handle to
%      the existing singleton*.
%
%      INCLUDEEXCLUDE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in INCLUDEEXCLUDE.M with the given input arguments.
%
%      INCLUDEEXCLUDE('Property','Value',...) creates a new INCLUDEEXCLUDE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before includeexclude_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to includeexclude_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help includeexclude

% Last Modified by GUIDE v2.5 01-Feb-2004 20:59:11

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @includeexclude_OpeningFcn, ...
                   'gui_OutputFcn',  @includeexclude_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before includeexclude is made visible.
function includeexclude_OpeningFcn(hObject, eventdata, handles, varargin)

% Choose default command line output for includeexclude
handles.output = hObject;

% Position GUI
movegui(handles.fIncludeExclude,'center');

% Add icons to buttons
load('sensableICONS.mat');
set(handles.pbInclude,'CData',icon.include)
set(handles.pbExclude,'CData',icon.exclude)

% Initialise variables
handles.Included = [];

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes includeexclude wait for user response (see UIRESUME)
% uiwait(handles.fIncludeExclude);


% --- Outputs from this function are returned to the command line.
function varargout = includeexclude_OutputFcn(hObject, eventdata, handles)

% Get default command line output from handles structure
varargout{1} = hObject;

%--------------------------------------------------------------------
%--------------------------------------------------------------------
%--------------------------------------------------------------------
function lbIncluded_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%--------------------------------------------------------------------
function lbIncluded_Callback(hObject, eventdata, handles)


%--------------------------------------------------------------------
function lbExcluded_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%--------------------------------------------------------------------
function lbExcluded_Callback(hObject, eventdata, handles)


%--------------------------------------------------------------------
function pbInclude_Callback(hObject, eventdata, handles)

excluded    = find(~handles.Included);           % Find ID for included samples only
selected    = get(handles.lbExcluded,'Value');   % Get index for selected samples
selected_id = excluded(selected);                % Get ID for selected samples

handles.Included(selected_id) = true;
handles.SaveRequired          = true;
guidata(hObject,handles);

UpdateListBox(handles);

%--------------------------------------------------------------------
function pbExclude_Callback(hObject, eventdata, handles)

included    = find(handles.Included);            % Find ID for included samples only
selected    = get(handles.lbIncluded,'Value');   % Get index for selected samples
selected_id = included(selected);                % Get ID for selected samples

handles.Included(selected_id) = false;
handles.SaveRequired          = true;
guidata(hObject,handles);

UpdateListBox(handles);

%--------------------------------------------------------------------
function pbOK_Callback(hObject, eventdata, handles)

if isequal(handles.Included,handles.IncludedOld)
  pbCancel_Callback(hObject, eventdata, handles);
else
  SensableHandles = findobj('Tag','fSensable');
  if ~isempty(SensableHandles)        % The LabelEditor GUI has been called from Sensable
    SensableHandles = guidata(SensableHandles);
    if isnumeric(handles.Mode)
      %MANGLER: TJEK OM ET ANDET MODE I FORVEJEN ER 1 - DEN GR IKKE!
      modes = [1:3];
      modes(handles.Mode) = [];
      dim = [sum(SensableHandles.DataSet.IncludedX{modes(1)}),sum(SensableHandles.DataSet.IncludedX{modes(2)})];
      if sum(handles.Included) < 1
        uiwait(errordlg(['At least one object should be included!',char(10),char(10),...
                         'Please include one or more objects in order to continue.'],'Include/Exclude not performed!','modal'));
        return;
      elseif (sum(handles.Included) == 1) & any(dim == 1)
        uiwait(errordlg(['An array smaller than a  2-way will result. This is not allowed!',char(10),char(10),...
                         'Please include one or more objects in order to continue.'],'Include/Exclude not performed!','modal'));
        return;
      elseif (sum(handles.Included) == 1) & (handles.Mode == 2)
        uiwait(errordlg(['The second mode (time) cannot be smaller than two points.',char(10),char(10),...
                         'Please include one or more objects in order to continue.'],'Include/Exclude not performed!','modal'));
        return;
      else
        if (sum(handles.Included) == 1) | any(dim == 1)
          SensableHandles.DataSet.preprocess.ID{3}    = 0;
          SensableHandles.DataSet.preprocess.label{3} = 'None';
          set([SensableHandles.mPreprocessFeatureAbsoluteMaximum ...
               SensableHandles.mPreprocessFeatureMaximalSlope ...
               SensableHandles.mPreprocessFeatureMinimalSlope],'Checked','off');
          set(SensableHandles.mPreprocessFeatureNone,           'Checked','on');
        end
        SensableHandles.DataSet.IncludedX{handles.Mode}  = handles.Included;
        SensableHandles = sensable('UpdatePreprocessData',SensableHandles.fSensable, [], SensableHandles);
        sensable('UpdatePlot',SensableHandles.fSensable, [], SensableHandles);
      end
    elseif ischar(handles.Mode)
      SensableHandles.DataSet.IncludedY = handles.Included;

      % Update ModelInfo-box
      children = get(SensableHandles.mModel,'Children');
      checked  = get(children,'Checked');
      child    = strmatch('on',checked,'exact');
      if ~isempty(child)
        label = get(children(child),'Label');
        ID    = strfind(label,'&');
        label(ID) = [];
        model = label;
      else
        model = '';
      end
      sensable('UpdateModelInfo',SensableHandles.fSensable,[],SensableHandles,model);
    
    end    
    SensableHandles.SaveDataRequired                       = handles.SaveRequired;

    guidata(SensableHandles.fSensable,SensableHandles); % Update SENSABLE handles to store latest changes

    set(SensableHandles.fSensable,'Name',['SENSABLE - Program for analysis of electronic nose data - ',fullfile(SensableHandles.PathName,SensableHandles.FileName),'*']);  % Because of SaveDataRequired
    set(SensableHandles.CurrentOn,'Enable','on');

    sensable('PreprocessEnableControl',SensableHandles.fSensable, [], SensableHandles);
  
    set(SensableHandles.fSensable,'CloseRequestFcn','sensable(''mFileExit_Callback'',gcbo,[],guidata(gcbo))');
    set(SensableHandles.fSensable,'Pointer','arrow');
    figure(SensableHandles.fSensable);
  end
  delete(handles.fIncludeExclude);
end

%--------------------------------------------------------------------
function pbCancel_Callback(hObject, eventdata, handles)

SensableHandles = findobj('Tag','fSensable');
if ~isempty(SensableHandles)        % The LabelEditor GUI has been called from Sensable
  SensableHandles = guidata(SensableHandles);
  set(SensableHandles.CurrentOn,'Enable','on');
  set(SensableHandles.fSensable,'CloseRequestFcn','sensable(''mFileExit_Callback'',gcbo,[],guidata(gcbo))');
  set(SensableHandles.fSensable,'Pointer','arrow');
  figure(SensableHandles.fSensable);
end

delete(handles.fIncludeExclude);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function UpdateListBox(varargin);

if isequal(nargin,1)
  handles = varargin{1};
  lbtI = get(handles.lbIncluded,'ListBoxTop');
  lbtE = get(handles.lbExcluded,'ListBoxTop');
else
  handles = varargin{3};
  lbtI = 1;
  lbtE = 1;
end

IncludedID = find( handles.Included);
ExcludedID = find(~handles.Included);

set([handles.pbInclude handles.pbExclude],'Enable','on');

set(handles.lbIncluded,'String',horzcat(num2str(IncludedID),char(ones(length(IncludedID),2)*diag([58,32])),handles.Labels(IncludedID,:)),'Value',[]);
set(handles.lbExcluded,'String',horzcat(num2str(ExcludedID),char(ones(length(ExcludedID),2)*diag([58,32])),handles.Labels(ExcludedID,:)),'Value',[]);

if isempty(IncludedID)
  set(handles.pbExclude,'Enable','off');
%  set(handles.lbIncluded,'ListBoxTop',1);
else
  set(handles.pbExclude,'Enable','on');
%  if lbtI < sum(IncludedID), set(handles.lbIncluded,'ListBoxTop',lbtI);
%  else                     , set(handles.lbIncluded,'ListBoxTop',1);
%  end
end
if isempty(ExcludedID)
  set(handles.pbInclude,'Enable','off');
%  set(handles.lbExcluded,'ListBoxTop',1);
else
  set(handles.pbInclude,'Enable','on');
%  if lbtE < sum(ExcludedID), set(handles.lbExcluded,'ListBoxTop',lbtE);
%  else                     , set(handles.lbExcluded,'ListBoxTop',1);
%  end
end
