function varargout = definegroups(varargin)
% DEFINEGROUPS M-file for definegroups.fig
%      DEFINEGROUPS, by itself, creates a new DEFINEGROUPS or raises the existing
%      singleton*.
%
%      H = DEFINEGROUPS returns the handle to a new DEFINEGROUPS or the handle to
%      the existing singleton*.
%
%      DEFINEGROUPS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DEFINEGROUPS.M with the given input arguments.
%
%      DEFINEGROUPS('Property','Value',...) creates a new DEFINEGROUPS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before definegroups_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to definegroups_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help definegroups

% Last Modified by GUIDE v2.5 21-Mar-2004 11:24:41

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @definegroups_OpeningFcn, ...
                   'gui_OutputFcn',  @definegroups_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before definegroups is made visible.
function definegroups_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to definegroups (see VARARGIN)

% Choose default command line output for definegroups
handles.output = hObject;

% Update handles structure
%guidata(hObject, handles);

% Position GUI
movegui(handles.fDefineGroups,'center');

% Inicialise GUI
handles = InitialiseGUI(handles);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes definegroups wait for user response (see UIRESUME)
 uiwait(handles.fDefineGroups);


% --- Outputs from this function are returned to the command line.
function varargout = definegroups_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

delete(handles.fDefineGroups);

%-------------------------------------------------------------------
%-------------------------------------------------------------------
%-------------------------------------------------------------------
function lbGroups_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%-------------------------------------------------------------------
function lbGroups_Callback(hObject, eventdata, handles)

selected  = get(hObject,'Value');
identical = diff(handles.DefinedGroups(selected));
if any(identical)
  set(handles.etGroup,'String','Mixed');
  set(handles.pbUpdate,'Enable','off');
elseif ~any(identical)
  set(handles.etGroup,'String',num2str(handles.DefinedGroups(selected(1))));
  set(handles.pbUpdate,'Enable','on');
end

%-------------------------------------------------------------------
function etGroup_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%-------------------------------------------------------------------
function etGroup_Callback(hObject, eventdata, handles)

group = str2double(get(hObject,'String'));
if isnan(group) | group > handles.Elements | rem(group,1) | isequal(group,0)
  uiwait(errordlg(['Wrong input! Input should be an integer value from [1:',num2str(handles.Elements),'].'],'Wrong input!','modal'))
  set(handles.pbUpdate,'Enable','off');
else
  set(handles.pbUpdate,'Enable','on');
  pbUpdate_Callback(hObject, eventdata, handles);
end
  
%-------------------------------------------------------------------
function pbUpdate_Callback(hObject, eventdata, handles)

selected  = get(handles.lbGroups,'Value');
handles.DefinedGroups(selected) = str2double(get(handles.etGroup,'String'));
guidata(hObject,handles);

UpdateListbox(handles);

%-------------------------------------------------------------------
function pbReset_Callback(hObject, eventdata, handles)

handles.DefinedGroups = [1:handles.Elements]';
guidata(hObject,handles);

UpdateListbox(handles);

%-------------------------------------------------------------------
function pbOK_Callback(hObject, eventdata, handles)

handles.output = handles.DefinedGroups;
guidata(hObject,handles);

uiresume(handles.fDefineGroups);

%-------------------------------------------------------------------
function pbCancel_Callback(hObject, eventdata, handles)

handles.output = [];
guidata(hObject,handles);

uiresume(handles.fDefineGroups);

%-------------------------------------------------------------------
%---------------------- USER FUNCTIONS BELOW -----------------------
%-------------------------------------------------------------------
function handles = InitialiseGUI(handles);

SensableHandle = findobj('Tag','fSensable');
if ~isempty(SensableHandle)
  SensableHandles = guidata(SensableHandle);
  children = get(SensableHandles.mEditDefineGroups,'Children');
  checked  = get(children,'Checked');
  child    = strmatch('on',flipud(checked));

  handles.GroupsMode    = child;
  handles.DefinedGroups = SensableHandles.DataSet.DefinedGroups{child};
  handles.Labels        = SensableHandles.DataSet.labels{(child-1)*2+1};  % Grouping only possible for Samples and Sensors.
  handles.Elements      = length(handles.DefinedGroups);
  
  UpdateListbox(handles);
  
end

%-------------------------------------------------------------------
function UpdateListbox(handles);
  set(handles.lbGroups,'String',horzcat(num2str([1:handles.Elements]'),...
                                char(ones(handles.Elements,5)*diag([58,ones(1,4)*32])),...
                                num2str(handles.DefinedGroups),...
                                char(ones(handles.Elements,5)*diag(ones(1,5)*32)),...
                                handles.Labels),'Value',[]);
