function [matrix,TIC,axis_min,axis_mz] = iCDF_load(filename)

% iCDF_load is a freeware program that loads netCDF files from different chromatographic software
% packages (e.g. ChemStation) from different instruments (e.g. Agilent, Bruker)
%
% INPUT
% filename    The name of the file as a structure e.g. 'Sample10.CDF'
%
% OUTPUT
% matrix      Data in a two-way array - matrix (elution time x m/z)
% TIC         Total Ion Current given as a one-way array - vector (elution time)
% axis_min    Axis labels of elution time dimension
% axis_mz     Axis labels of mass spectral dimension
%
% I/O: [matrix,TIC,axis_min,axis_mz] = iCDF_load(filename)
%
% Copyright 2007, thsk@life.ku.dk (261007)
%
% Updates: 010308 - more help lines included to ensure that iCDF is used and not icdf (from stats toolbox)
%                   see below under IMPORTANT
%
%%%%%%%%%%%%%%%% IMPORTANT IMPORTANT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% If you have the stats toolbox there will a function called icdf that is NOT related to this program. 
% Our icdf files must be written like this; iCDF (capital CDF) to be able to work (se below). This file 
% is NOT an m-file and thus if you type help iCDF the icdf (stats toolbox) will open. Write which iCDF to 
% make sure you call the right function using iCDF_load
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% ----- REFERENCE -----
% If this function is used for any publications please refer to:
%
% Skov T and Bro R. (2008) Solving fundamental problems in chromatographic
% analysis, Analytical and Bioanalytical Chemistry, 390 (1): 281-285. 
%
% ----- ADVANCED USE -----
% Note that iCDF can be used alone to see all variables and attributes and more contained in the netCDF file.
% To be able to do this simply type: data = iCDF('filename')
%

data = iCDF(filename);

matrix = zeros(length(data.variables.scan_index.data),max(round(data.variables.mass_values.data)));

data.variables.scan_index.data(length(data.variables.scan_index.data)+1) = length(data.variables.mass_values.data);

for i = 1:length(data.variables.scan_index.data)-1
    matrix(i,round(data.variables.mass_values.data(data.variables.scan_index.data(i)+1:data.variables.scan_index.data(i+1))))......
        = data.variables.intensity_values.data(data.variables.scan_index.data(i)+1:data.variables.scan_index.data(i+1));
end

TIC = data.variables.total_intensity.data;

axis_min = data.variables.scan_acquisition_time.data/60;
axis_mz = 1:round(max(data.variables.mass_range_max.data));
