function [ZCorrected,ModelParamNames,ZMod,ModelParam,CovModelParam,SModelParam,LocalEMSCResults,OptionsEMSC] ...
                        = EMSCDoDo(OptimizedPar,OptionsEMSC,OptionsSearch,OptionPlot);
                    
% Purpose: Estimate GoodC and BadC spectra by direct orthogonalization
% Made by. H. Martens March 2003 (c) Consensus Analysis AS
%
% Input: 
%   OptimizedPar    (see def. in xxx.m)
%   OptionsEMSC     (see def. in xxx.m)
%   OptionsSearch   (see def. in xxx.m)
%   OptionPlot      (see def. in xxx.m)
% 
% Output:(see def. in xxx.m)
%   ZCorrected
%   ModelParamNames
%   ZMod
%   ModelParam
%   CovModelParam
%   SModelParam
%   LocalEMSCResults
%
% Related files:
% Called from       EMSC_Main.m
% Calls:            EMSCEISC.m
%
% 0  Start: make initial physical EMSC default  
% 1 Model the corrected Z by a linear(polynomial)  model of Y 
%       ZCorrected=YB + 1b0+....+ F
%       ZModBad=Reconstruct the part of ZChem that was generated by last iterations' the BodC
%       (with EMSC/EISC correction of model parameters)
%       ZModGood=Reconstruct the part of ZChem that was generated by last iterations' the GoodC
%       (with EMSC/EISC correction of model parameters)
% 2  BadSpectra=svd(ZModBad+F),GoodSpectra=svd(ZModGood+B),
% 3 Critique data based on EMSC cov.
% 4 Make EMSC with GoodSpectra, BadSpectra
% 5  Make weights from EMSC fit
% 6 Make weighted EMSC with GoodSpectra, BadSpectra
% goto 1
%
%
MaxIter=5;
ResidualScalingFactor=0.3;% 0.10;
 
PlotIt = OptionPlot{1};

Z = OptionsEMSC{1};
ChannelWeights = OptionsEMSC{2}; 
CondNumber = OptionsEMSC{3};
MscOrIsc=OptionsEMSC{4}; % NB!
ModRef=OptionsEMSC{5}; 
ModOffset = OptionsEMSC{6}; % nB!
ModSqSpectrum = OptionsEMSC{7};
ModChannel = OptionsEMSC{8};
ModSqChannel = OptionsEMSC{9};
   
BadC=OptionsEMSC{11};PB=BadC;
GoodC=OptionsEMSC{12};PG=GoodC;
BadCName=OptionsEMSC{13};PBName=BadCName;
GoodCName=OptionsEMSC{14};PGName=GoodCName;

RefSpectrum=OptionsEMSC{10}; 
RefName=OptionsEMSC{15};      
Y = OptionsSearch{1};
% Defaults:
% Condition number:
DefaultCondNumberSqrt=10^6;
DefaultCondNumber=DefaultCondNumberSqrt^2;
if isempty(CondNumber),  CondNumber=DefaultCondNumber;end  % Default value of the condition number is used, if CondNumber=[]
  
%..............................
[nObj,nZVar]=size(Z);[nObjY,nYVar]=size(Y);
BadCInitial=BadC;GoodCInitial=GoodC;
BadCNameInitial=BadCName;GoodCNameInitial=GoodCName;
nBadInitial=size(BadCInitial,1);nGoodInitial=size(GoodCInitial,1);
if nBadInitial>0,
    nBadInitial
    disp('EMSCDoDo has not yet been implemented with input bad  spectra')
    error('remove the statement FileNameBad=...  in the DataCase definition in file EMSC_GetUserDefinedDataCases.m ')
end
if nGoodInitial>0,
    nGoodInitial
    disp('EMSCDoDo has not yet been implemented with input good  spectra')
    error('remove the statement FileNameGood=...  in the DataCase definition in file EMSC_GetUserDefinedDataCases.m ')
end

nOptBadSpectra=-OptimizedPar(2); % later: add input dimensions
nOptGoodSpectra=-OptimizedPar(3); %1; % May be modified later
nOptGoodSpectra=min(nOptGoodSpectra,nYVar);

if nOptBadSpectra==1
    OptBadCName='EstBad';
else
    OptBadCName=[];
    for j=1:nOptBadSpectra
        OptBadCName=[OptBadCName;cellstr(['EstBad',num2str(j)])];
    end %for j,
end % if nOptBadSpectra
OptBadCName=char(OptBadCName);

if nOptGoodSpectra==1
    OptGoodCName='EstGood';
else
    OptGoodCName=[];
    for j=1:nOptGoodSpectra
            OptGoodCName=[OptGoodCName;cellstr(['EstGood',num2str(j)])];
end %for j,
end % if nOptGoodSpectra
OptGoodCName=char(OptGoodCName);

Converged=0; Iter=0;
while Converged==0 %CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
    Iter=Iter+1;
    if Iter>=MaxIter
        Converged=-1;
    end % if Iter
    
    OptionsEMSC{11}=BadC;
    OptionsEMSC{12}=GoodC;
    OptionsEMSC{13}=BadCName;
    OptionsEMSC{14}=GoodCName;
    
    nBadSpectra=size(BadC,1);
    nGoodSpectra=size(GoodC,1);
    
    [ZCorrected,ModelParamNames,ZMod,ModelParam,CovModelParam,SModelParam,LocalEMSCResults] ...
                        = EMSCEISC(OptionsEMSC,OptionPlot);
        
                    
    if PlotIt>3
        figure,
        if nBadSpectra>0,        subplot(221),plot(BadC','r'),hold on,    end
        if nGoodSpectra>0,subplot(221),plot(GoodC','b'),end
        title(['Iter=',num2str(Iter),', r=BadC,b=GoodC']),
        subplot(222),plot(ZCorrected'),title(['Iter=',num2str(Iter),', ZCorrected'])
        if min(nBadSpectra,nGoodSpectra)>0
            subplot(223),plot(GoodC(1,:),BadC(1,:),'k'),hold on, plot(GoodC(1,:),BadC(1,:),'k.')
            xlabel('GoodC'),ylabel('BadC')
            r=corrcoef([GoodC(1,:)',BadC(1,:)']);r=r(1,2);
            title(['r=',num2str(r)])
        end %if min
        keyboard
    end % if Plotit
    
    YMean=mean(Y);
    F0=Y-ones(nObjY,1)*YMean;

    % Project corrected Z = YB+Y^2C+Y^3*D+F, 
    Y1=[ones(nObj,1) F0 ]; % Linear main model
    Y2=Y1;
    Y2=[Y2,  F0.^2 ]; % polynomial expansion
    Y2=[Y2,  F0.^3]; % polynomial expansion

    BY1=pinv(Y2)*ZCorrected;
    ZCorrectedHat=Y2*BY1;
    
    [nObjMod,nZMod]=size(ZMod); 
    
    if nOptBadSpectra>0
      iFirstBadSpectrum= ModOffset+ModSqSpectrum+ModChannel+ModSqChannel+1;
      iLastBadSpectrum= iFirstBadSpectrum -1 +nOptBadSpectra;
   
      % Bad spectra:
      BadResiduals=ZCorrected-ZCorrectedHat;    % Basis for new BadC
      % Already estimated BadC contribution:
      if nBadSpectra>0 %
        ZModBadC=ModelParam(:,iFirstBadSpectrum:iLastBadSpectrum);
        if ModRef==1
            ZModRef=ModelParam(:,nZMod);
            if MscOrIsc==1 % MSC or EMSC
                Denom=ZModRef*ones(1,nOptBadSpectra);
                ZModBadC=ZModBadC./max(eps, Denom ); 
            elseif MscOrIsc==(-1) % ISC or EISC
                Subtr=ZModRef*ones(1,nOptBadSpectra);
                ZModBadC=ZModBadC- Subtr; 
            else
               error('Wrong MSCOrISC method')
            end % if MscOrIsc
       end % if ModRef
       ZModBad=ZModBadC*BadC;
     else
       ZModBad=BadResiduals.*0;ZModBadC=zeros(nObj,nOptBadSpectra);
     end %if nBadSpectra>1
       
     ZBadTotal=ZModBad+ResidualScalingFactor*BadResiduals;
     if nObj>=nZVar
           [uB,sB,vB]=svd(ZBadTotal,0);
     else
           [vB,sB,uB]=svd(ZBadTotal',0);
     end % if nObj
     VB=vB*sB;
     sB=diag(sB)';
     BadC=vB(:,1:nOptBadSpectra)'; % Next candidate BadC
     SignC=sign(sum(BadC'))'; BadC=diag(SignC )*BadC;
     BadCName=OptBadCName;
     
 end % if nOptBadSpectra>0
       
 if nOptGoodSpectra>0
    iFirstGoodSpectrum=iLastBadSpectrum+1;
    iLastGoodSpectrum=iFirstGoodSpectrum-1 +nOptGoodSpectra;
    
    % Good spectra:
    ZCorrectedHatY=F0*BY1(2,:);
    GoodSpectralFitToY=ZCorrectedHatY;% BY1(2:nYVar+1,:); % Basis for new GoodC
    

    % Already estimated GodC contribution:
    if nGoodSpectra>0 %
        ZModGoodC=ModelParam(:,iFirstGoodSpectrum:iLastGoodSpectrum);
        if ModRef==1
            ZModRef=ModelParam(:,nZMod);
            if MscOrIsc==1 % MSC or EMSC
                Denom=ZModRef*ones(1,nOptGoodSpectra);
                ZModGoodC=ZModGoodC./max(eps, Denom ); 
            elseif MscOrIsc==(-1) % ISC or EISC
                Subtr=ZModRef*ones(1,nOptGoodSpectra);
                ZModGoodC=ZModGoodC- Subtr; 
            else
               error('Wrong MSCOrISC method')
           end %if MscOrIsc
        end % if ModRef
        ZModGood=ZModGoodC*GoodC;
    else
        ZModGood=GoodSpectralFitToY.*0;ZModGoodC=zeros(nObj,nOptGoodSpectra);
    end % if nGoodSpectra>1 %
    
    ZGoodTotal=ZModGood + ResidualScalingFactor*GoodSpectralFitToY;
    if nObj>=nZVar
           [uG,sG,vG]=svd(ZGoodTotal,0);
    else
           [vG,sG,uG]=svd(ZGoodTotal',0);
    end % if nObj
    VG=vG*sG;
    GoodC=vG(:,1:nOptGoodSpectra)'; % Next candidate BadC
    SignC=sign(sum(GoodC'))'; GoodC=diag(SignC)*GoodC;

    GoodCName=OptGoodCName;
    


end % if   nOptGoodSpectra>0


 

end % while Converged==0 %CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

    
if PlotIt>2
    
    figure,
    plot((ZCorrected-ones(nObj,1)*mean(ZCorrected))','k')
    hold on
    plot((ZCorrectedHat-ones(nObj,1)*mean(ZCorrectedHat))','r')
    plot((ZCorrectedHatY-ones(nObj,1)*mean(ZCorrectedHatY))','g')
    title('ZCorrected, mean centred, k=total, r=full reconstr, g=main')
    
     figure
     subplot(231),plot(ZBadTotal'),title('ZBadTotal')
     axis tight,     v=axis;
     subplot(232),plot(ResidualScalingFactor*BadResiduals'),title([num2str(ResidualScalingFactor),'*BadResiduals']),axis(v)
     subplot(233),plot(ZModBad'),title('ZModBad'),axis(v)     
     subplot(234),plot(VB(:,1:3)),title('VB1-3')
    subplot(235),plot(ZModBadC),title('ZModBadC')

    
     figure
     subplot(231),plot(ZGoodTotal'),title('ZGoodTotal')
     axis tight,     v=axis;
     subplot(232),plot(ResidualScalingFactor*GoodSpectralFitToY'),
     title([num2str(ResidualScalingFactor),'*GoodSpectralFitToY']),axis(v)
     subplot(233),plot(ZModGood'),title('ZModGood'),axis(v)
     subplot(234),plot(VG(:,1:3)),title('VG1-3')
     subplot(235),plot(ZModGoodC),title('ZModGoodC')
     
 end % if
    

    