function varargout = biplsGUI(varargin)
% BIPLSGUI M-file for biplsGUI.fig
%      BIPLSGUI, by itself, creates a new BIPLSGUI or raises the existing
%      singleton*.
%
%      H = BIPLSGUI returns the handle to a new BIPLSGUI or the handle to
%      the existing singleton*.
%
%      BIPLSGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BIPLSGUI.M with the given input arguments.
%
%      BIPLSGUI('Property','Value',...) creates a new BIPLSGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before biplsGUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to biplsGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help biplsGUI

% Last Modified by GUIDE v2.5 05-Apr-2006 14:18:42

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @biplsGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @biplsGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before biplsGUI is made visible.
function biplsGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to biplsGUI (see VARARGIN)

% Choose default command line output for biplsGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% Populate the listbox
%set(handles.ListMatrix,'Value',[])


% UIWAIT makes biplsGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = biplsGUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

vars = evalin('base','who');
set(handles.Ymatrix,'String',vars)
set(handles.ListAxis,'String',vars)
set(handles.IntervalsMatrix,'String',vars)
set(handles.Xmatrix,'String',vars)
% --- Executes on selection change in ListMatrix.
function ListMatrix_Callback(hObject, eventdata, handles)

% hObject    handle to ListMatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ListMatrix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ListMatrix


% --- Executes during object creation, after setting all properties.
function ListMatrix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ListMatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function NumberOfLvlBox_Callback(hObject, eventdata, handles)
% hObject    handle to NumberOfLvlBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NumberOfLvlBox as text
%        str2double(get(hObject,'String')) returns contents of NumberOfLvlBox as a double

% --- Executes during object creation, after setting all properties.
function NumberOfLvlBox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NumberOfLvlBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in preProcessListbox.
function preProcessListbox_Callback(hObject, eventdata, handles)
% hObject    handle to preProcessListbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns preProcessListbox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from preProcessListbox


% --- Executes during object creation, after setting all properties.
function preProcessListbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to preProcessListbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Intervals_Callback(hObject, eventdata, handles)
% hObject    handle to Intervals (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Intervals as text
%        str2double(get(hObject,'String')) returns contents of Intervals as a double


% --- Executes during object creation, after setting all properties.
function Intervals_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Intervals (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ListAxis.
function ListAxis_Callback(hObject, eventdata, handles)
function [myAxis] = get_Axis_names(handles)
list_entriesAxis = get(handles.ListAxis,'String')
index_selecteAxis = get(handles.ListAxis,'Value')
myAxis = list_entriesAxis{index_selecteAxis(1)}

% hObject    handle to ListAxis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ListAxis contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ListAxis

% --- Executes during object creation, after setting all properties.
function ListAxis_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ListAxis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in makeClasses.
function makeClasses_Callback(hObject, eventdata, handles)
assignin('base', 'classes',[1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;])

% --- Executes on button press in LoadDemoSet.
function LoadDemoSet_Callback(hObject, eventdata, handles)
nirbeer=load('Nirbeer');
assignin('base', 'nirbeer',nirbeer);
xaxis=nirbeer.xaxis;
Xcal=nirbeer.Xcal;
ycal=nirbeer.ycal; 
Xtest=nirbeer.Xtest;
ytest=nirbeer.ytest;
assignin('base', 'xaxis',xaxis);
assignin('base', 'Xcal',Xcal);
assignin('base', 'ycal',ycal);
assignin('base', 'Xtest',Xtest);
assignin('base', 'Xcal',Xcal);


% --- Executes on button press in UpdateWorkspace.
function UpdateWorkspace_Callback(hObject, eventdata, handles)

vars = evalin('base','who');
set(handles.Xmatrix,'String',vars)
set(handles.ListAxis,'String',vars)
set(handles.IntervalsMatrix,'String',vars)
set(handles.Ymatrix,'String',vars)

% --- Executes on button press in loadFilesButton.
function loadFilesButton_Callback(hObject, eventdata, handles)

filename = uigetfile ('*.*')
myfile= load (filename)
assignin('base', 'myfile', myfile)

% hObject    handle to loadFilesButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in doIpca.
function doIpca_Callback(hObject, eventdata, handles)


list_entriesXmatrix = get(handles.Xmatrix,'String');
index_selectedXmatrix = get(handles.Xmatrix,'Value');
mymatrix = evalin('base',list_entriesXmatrix{index_selectedXmatrix(1)});


list_entriesYmatrix = get(handles.Ymatrix,'String');
index_selectedYmatrix = get(handles.Ymatrix,'Value');
myYmatrix = evalin('base',list_entriesYmatrix{index_selectedYmatrix(1)});



list_entriesAxis = get(handles.ListAxis,'String');
index_selecteAxis = get(handles.ListAxis,'Value');
myAxis = evalin('base',list_entriesAxis{index_selecteAxis(1)});


list_IntervalsMatrix = get(handles.IntervalsMatrix,'String');
index_IntervalsMatrix = get(handles.IntervalsMatrix,'Value');
Intervals = evalin('base',list_IntervalsMatrix{index_IntervalsMatrix(1)});

preprocindex =  int2str(get(handles.preprocessListbox,'Value'));

 switch preprocindex
    case {'1'}
       preproc='none';
    case '2'
       preproc='mean';
    case '3'
       preproc='auto';
    case '4'
       preproc='mscmean';
    case '5'
       preproc='mscauto';
end
%assignin('base', 'preproc', preproc);

validation =  int2str(get(handles.validation,'Value'));

 switch validation
    case {'1'}
       valMethod='test';
    case '2'
       valMethod='full';
    case '3'
       valMethod='syst111';
    case '4'
       valMethod='syst123';
    case '5'
       valMethod='random';
end




modelname = get(handles.modelname,'String');


numberOfComponents = str2double(get(handles.NumberOfLvlBox,'String'));
numberOfIntervals = str2double(get(handles.IntervalsBox,'String'));
numberOfSegments = str2double(get(handles.Segments,'String'));


if (get(handles.checkIntervals,'Value') == get(handles.checkIntervals,'Max')) &  (get(handles.checkAxis,'Value') == get(handles.checkAxis,'Max'))
    Modelbipls=bipls(mymatrix,myYmatrix,numberOfComponents,preproc,Intervals,myAxis,valMethod,numberOfSegments);
elseif (get(handles.checkIntervals,'Value') == get(handles.checkIntervals,'Min')) &  (get(handles.checkAxis,'Value') == get(handles.checkAxis,'Min'))
    Modelbipls=bipls(mymatrix,myYmatrix,numberOfComponents,preproc,numberOfIntervals,[],valMethod,numberOfSegments);
elseif (get(handles.checkIntervals,'Value') == get(handles.checkIntervals,'Max')) &  (get(handles.checkAxis,'Value') == get(handles.checkAxis,'Min'))
    Modelbipls=bipls(mymatrix,myYmatrix,numberOfComponents,preproc,Intervals,[],valMethod,numberOfSegments);
else
    Modelipls=bipls(mymatrix,myYmatrix,numberOfComponents,preproc,numberOfIntervals,myAxis,valMethod,numberOfSegments);
end

assignin('base', modelname, Modelbipls)

 


% --- Executes on selection change in preprocessListbox.
function preprocessListbox_Callback(hObject, eventdata, handles)
%contents = get(handles.preprocessListbox,'String')



% hObject    handle to preprocessListbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns preprocessListbox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from preprocessListbox


% --- Executes during object creation, after setting all properties.
function preprocessListbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to preprocessListbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






function IntervalsBox_Callback(hObject, eventdata, handles)
% hObject    handle to IntervalsBox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of IntervalsBox as text
%        str2double(get(hObject,'String')) returns contents of IntervalsBox as a double



% --- Executes on button press in makeManualIntervals.
function makeManualIntervals_Callback(hObject, eventdata, handles)
%           VIS       NIR       NOISE
%        st1 end1  st2  end2  st3  end3
int_vec=[1   200   201  500   501  926];
assignin('base', 'int_vec',int_vec);
% hObject    handle to makeManualIntervals (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on selection change in intervalsMatrix.
function intervalsMatrix_Callback(hObject, eventdata, handles)
% hObject    handle to intervalsMatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns intervalsMatrix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from intervalsMatrix


% --- Executes during object creation, after setting all properties.
function intervalsMatrix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to intervalsMatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkIntervals.
function checkIntervals_Callback(hObject, eventdata, handles)
if (get(handles.checkIntervals,'Value') == get(handles.checkIntervals,'Max'))
    % then checkbox is not checked 
     set(handles.IntervalsBox,'Enable', 'off')
     set(handles.IntervalsMatrix,'Enable', 'on')
else
     set(handles.IntervalsBox,'Enable', 'on')
     set(handles.IntervalsMatrix,'Enable', 'off') 
end
% hObject    handle to checkIntervals (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkIntervals




% --- Executes on selection change in IntervalsMatrix.
function IntervalsMatrix_Callback(hObject, eventdata, handles)
% hObject    handle to IntervalsMatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns IntervalsMatrix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from IntervalsMatrix


% --- Executes during object creation, after setting all properties.
function IntervalsMatrix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to IntervalsMatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function segments_Callback(hObject, eventdata, handles)
% hObject    handle to segments (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of segments as text
%        str2double(get(hObject,'String')) returns contents of segments as a double


% --- Executes during object creation, after setting all properties.
function segments_CreateFcn(hObject, eventdata, handles)
% hObject    handle to segments (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in Ymatrix.
function Ymatrix_Callback(hObject, eventdata, handles)
% hObject    handle to Ymatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Ymatrix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Ymatrix


% --- Executes during object creation, after setting all properties.
function Ymatrix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ymatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function Segments_Callback(hObject, eventdata, handles)
% hObject    handle to Segments (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Segments as text
%        str2double(get(hObject,'String')) returns contents of Segments as a double


% --- Executes during object creation, after setting all properties.
function Segments_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Segments (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on selection change in validation.
function validation_Callback(hObject, eventdata, handles)
% hObject    handle to validation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns validation contents as cell array
%        contents{get(hObject,'Value')} returns selected item from validation


% --- Executes during object creation, after setting all properties.
function validation_CreateFcn(hObject, eventdata, handles)
% hObject    handle to validation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in checkAxis.
function checkAxis_Callback(hObject, eventdata, handles)
if (get(handles.checkAxis,'Value') == get(handles.checkAxis,'Max'))
   
     set(handles.ListAxis,'Enable', 'on')
    
else
     set(handles.ListAxis,'Enable', 'off')
     
end
% hObject    handle to checkAxis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkAxis




% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function modelname_Callback(hObject, eventdata, handles)
% hObject    handle to modelname (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of modelname as text
%        str2double(get(hObject,'String')) returns contents of modelname as a double


% --- Executes during object creation, after setting all properties.
function modelname_CreateFcn(hObject, eventdata, handles)
% hObject    handle to modelname (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function NameOfModelLabel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NameOfModelLabel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object deletion, before destroying properties.
function modelname_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to modelname (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object deletion, before destroying properties.
function NameOfModelLabel_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to NameOfModelLabel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on button press in BiplsTableButton.
function BiplsTableButton_Callback(hObject, eventdata, handles)
% hObject    handle to BiplsTableButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

list_entriesXmatrix = get(handles.Xmatrix,'String');
index_selectedXmatrix = get(handles.Xmatrix,'Value');
mymatrix = evalin('base',list_entriesXmatrix{index_selectedXmatrix(1)});

biplstable(mymatrix)

