function varargout = NipalsGUI(varargin)
% NIPALSGUI M-file for NipalsGUI.fig
% Algoritm in Brereton
% GUI for program created by Riccardo Leardi
%      NIPALSGUI, by itself, creates a new NIPALSGUI or raises the existing
%      singleton*.
%
%      H = NIPALSGUI returns the handle to a new NIPALSGUI or the handle to
%      the existing singleton*.
%
%      NIPALSGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in NIPALSGUI.M with the given input arguments.
%
%      NIPALSGUI('Property','Value',...) creates a new NIPALSGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before NipalsGUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to NipalsGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help NipalsGUI

% Last Modified by GUIDE v2.5 03-Apr-2006 15:44:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @NipalsGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @NipalsGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before NipalsGUI is made visible.
function NipalsGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to NipalsGUI (see VARARGIN)

% Choose default command line output for NipalsGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes NipalsGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = NipalsGUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

vars = evalin('base','who');
set(handles.Xmatrix,'String',vars)
set(handles.XTest,'String',vars)

% --- Executes on button press in Autoscale.
function Autoscale_Callback(hObject, eventdata, handles)
% hObject    handle to Autoscale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Autoscale


% --- Executes on selection change in Xmatrix.
function Xmatrix_Callback(hObject, eventdata, handles)
% hObject    handle to Xmatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns Xmatrix contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Xmatrix


% --- Executes during object creation, after setting all properties.
function Xmatrix_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Xmatrix (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in XTest.
function XTest_Callback(hObject, eventdata, handles)
% hObject    handle to XTest (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns XTest contents as cell array
%        contents{get(hObject,'Value')} returns selected item from XTest


% --- Executes during object creation, after setting all properties.
function XTest_CreateFcn(hObject, eventdata, handles)
% hObject    handle to XTest (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function st_Callback(hObject, eventdata, handles)
% hObject    handle to st (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of st as text
%        str2double(get(hObject,'String')) returns contents of st as a double


% --- Executes during object creation, after setting all properties.
function st_CreateFcn(hObject, eventdata, handles)
% hObject    handle to st (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function components_Callback(hObject, eventdata, handles)
% hObject    handle to components (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of components as text
%        str2double(get(hObject,'String')) returns contents of components as a double


% --- Executes during object creation, after setting all properties.
function components_CreateFcn(hObject, eventdata, handles)
% hObject    handle to components (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in FirstRun.
function FirstRun_Callback(hObject, eventdata, handles)


listX = get(handles.Xmatrix,'String');
indexX = get(handles.Xmatrix,'Value');
x = evalin('base',listX{indexX(1)});

[r,c]=size(x);
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
listXTest = get(handles.XTest,'String');
indexXTest = get(handles.XTest,'Value');
x2 = evalin('base',listXTest{indexXTest(1)});
[r2,c2]=size(x2);
end
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'min')
  xtot=x;
else
  xtot=[x;x2]; 
end
[o,v]=size(xtot);
if get(handles.Autoscale,'Value') == get(handles.Autoscale,'Max')
  xnorm=(xtot-ones(o,1)*mean(x))./(ones(o,1)*std(x));
  if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'min')
    x=xnorm;
  else
    x=xnorm(1:r,:);
    x2=xnorm(r+1:r+r2,:);
  end
end  

xt=x;
t=0;
vp=[];
vartot=sum(sum(x.^2));
st=str2double(get(handles.St,'String'));

while sum(vp)<st
  t=t+1;
  ss=sum(xt.^2);
  [a,b]=sort(ss);
  xmax=xt(:,b(c));
  s=xmax'*xmax;
  diff=1000;
  while diff>0.0000001
    rmax=xmax'*xt/s;
    rmaxsq=rmax*rmax';
    rmax=rmax/sqrt(rmaxsq);
    xmax=xt*rmax';
    s2=xmax'*xmax;
    diff=abs(s2-s);
    s=s2;
  end
  smat(:,t)=xmax;
  lmat(t,:)=rmax;
  varexp(t)=xmax'*xmax;
  vp(t)=varexp(t)/vartot*100;
  xt=xt-xmax*rmax;
end

disp(vp)
disp(cumsum(vp))
figure
plot(vp,'-r')
hold on
plot(vp,'or')
set(gca,'xlabel',text(0,0,['Component number' ]));
set(gca,'ylabel',text(0,0,['% of explained variance' ]));
set(gca,'XLim',[.5 size(vp,2)+.5])
figure(gcf)


% hObject    handle to FirstRun (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in TestsetCheckbox.
function TestCheck_Callback(hObject, eventdata, handles)
% hObject    handle to TestsetCheckbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of TestsetCheckbox


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
vars = evalin('base','who');
set(handles.Xmatrix,'String',vars)
set(handles.XTest,'String',vars)


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

listX = get(handles.Xmatrix,'String');
indexX = get(handles.Xmatrix,'Value');
x = evalin('base',listX{indexX(1)});

[r,c]=size(x);
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
listXTest = get(handles.XTest,'String');
indexXTest = get(handles.XTest,'Value');
x2 = evalin('base',listXTest{indexXTest(1)});
[r2,c2]=size(x2);
end
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'min')
  xtot=x;
else
  xtot=[x;x2]; 
end
[o,v]=size(xtot);
if get(handles.Autoscale,'Value') == get(handles.Autoscale,'Max')
  xnorm=(xtot-ones(o,1)*mean(x))./(ones(o,1)*std(x));
  if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'min')
    x=xnorm;
  else
    x=xnorm(1:r,:);
    x2=xnorm(r+1:r+r2,:);
  end
end  

xt=x;
t=0;
vp=[];
vartot=sum(sum(x.^2));
st=str2double(get(handles.St,'String'));

while sum(vp)<st
  t=t+1;
  ss=sum(xt.^2);
  [a,b]=sort(ss);
  xmax=xt(:,b(c));
  s=xmax'*xmax;
  diff=1000;
  while diff>0.0000001
    rmax=xmax'*xt/s;
    rmaxsq=rmax*rmax';
    rmax=rmax/sqrt(rmaxsq);
    xmax=xt*rmax';
    s2=xmax'*xmax;
    diff=abs(s2-s);
    s=s2;
  end
  smat(:,t)=xmax;
  lmat(t,:)=rmax;
  varexp(t)=xmax'*xmax;
  vp(t)=varexp(t)/vartot*100;
  xt=xt-xmax*rmax;
end

%disp(vp)
%disp(cumsum(vp))
%figure
%plot(vp,'-r')
%hold on
%plot(vp,'or')
%set(gca,'xlabel',text(0,0,['Component number' ]));
%set(gca,'ylabel',text(0,0,['% of explained variance' ]));
%set(gca,'XLim',[.5 size(st,2)+.5])
%figure(gcf)
nc=str2double(get(handles.components,'String'));
lmat=lmat(1:nc,:); %matrix of loadings
smat=smat(:,1:nc); %matrix of component
[a,b]=size(smat);
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
  smat2=x2*lmat';
end

t2=zeros(r,1);
vvv=zeros(nc,nc);
for i=1:nc
vvv(i,i)=varexp(i)/(r-1);
end
for i=1:r
  t2(i)=smat(i,1:nc)*inv(vvv)*smat(i,1:nc)';
end

for i=1:nc;  % T^2 contributions
  ssq(i,1)=vvv(i,i);
end  
tcont=x*lmat'*diag(1./sqrt(ssq))*lmat;

if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
  t22=zeros(r2,1);
  for i=1:r2
    t22(i)=smat2(i,1:nc)*inv(vvv)*smat2(i,1:nc)';
  end
  tcont2=x2*lmat'*diag(1./sqrt(ssq))*lmat;
end

% Computation of Q values based on cross-validation (ng deletion groups)
ng=str2double(get(handles.ng,'String'));
q=zeros(r,1);
qcont=zeros(r,v);
for g=1:ng
  smattr=[];
  lmattr=[];
  t=[g:ng:r];
  xtr=x;
  xtr(t,:)=[];
  xev=x(t,:);
  [rtr,c]=size(xtr);
  
  %%%%%%%%%%
  if get(handles.Autoscale,'Value') == get(handles.Autoscale,'Max')
    sst=std(xtr);
    [jj1,jj2]=min(sst);
    if jj1==0
      disp(['Error: variable ' int2str(jj2) ' constant in group ' int2str(g)])
      stop
    end 
    aa=autosc(xtr,xev);
    xtr=aa(1:rtr,:);
    xev=aa(rtr+1:size(aa,1),:);
  end
  xttr=xtr;
  tt=0;
  while tt<nc
    lmattr=zeros(nc,v);
    tt=tt+1;
    ss=sum(xttr.^2);
    [a2,b2]=sort(ss);
    xmax=xttr(:,b2(c));
    s=xmax'*xmax;
    diff=1000;
    while diff>0.0000001
      rmax=xmax'*xttr/s;
      rmaxsq=rmax*rmax';
      rmax=rmax/sqrt(rmaxsq);
      xmax=xttr*rmax';
      s2=xmax'*xmax;
      diff=abs(s2-s);
      s=s2;
    end
    smattr(:,tt)=xmax;
    lmattr(tt,:)=rmax;
    xttr=xttr-xmax*rmax;
  end
  smatev=xev*lmattr';
  reconstrev=smatev*lmattr;
  for i=1:size(xev,1)
    q(t(i))=(reconstrev(i,:)-xev(i,:))*(reconstrev(i,:)-xev(i,:))';
    qcont(t(i),:)=(reconstrev(i,:)-xev(i,:)).^2.*sign(xev(i,:)-reconstrev(i,:));
  end
end

if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
  q2=zeros(r2,1);
  qcont2=zeros(r2,v);
  reconstr2=smat2*lmat;
  for i=1:r2
    q2(i)=(reconstr2(i,:)-x2(i,:))*(reconstr2(i,:)-x2(i,:))';
    qcont2(i,:)=(reconstr2(i,:)-x2(i,:)).^2.*sign(x2(i,:)-reconstr2(i,:));
  end
end

assignin ('base','lmat',lmat)
assignin ('base','smat',smat)
assignin ('base','qcont',qcont)
assignin ('base','tcont',tcont)
setappdata (handles.pushbutton3,'lmat',lmat)
setappdata (handles.pushbutton3,'vp',vp)
setappdata (handles.pushbutton3,'c',c);
setappdata (handles.pushbutton3,'r',r);
setappdata (handles.pushbutton3,'smat',smat);
setappdata (handles.pushbutton3,'qcont',qcont);
setappdata (handles.pushbutton3,'tcont',tcont);
setappdata (handles.pushbutton3,'t2',t2);
setappdata (handles.pushbutton3,'q',q);

if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')


assignin ('base','smat2',smat2)
assignin ('base','qcont2',qcont2)
assignin ('base','tcont2',tcont2)
setappdata (handles.pushbutton3,'smat2',smat2)
setappdata (handles.pushbutton3,'qcont2',qcont2)
setappdata (handles.pushbutton3,'tcont2',tcont2)
setappdata (handles.pushbutton3,'t22',t22);
setappdata (handles.pushbutton3,'q2',q2);
setappdata (handles.pushbutton3,'r2',r2);
end
    
function v1_Callback(hObject, eventdata, handles)
% hObject    handle to v1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v1 as text
%        str2double(get(hObject,'String')) returns contents of v1 as a double


% --- Executes during object creation, after setting all properties.
function v1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function v2_Callback(hObject, eventdata, handles)
% hObject    handle to v2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of v2 as text
%        str2double(get(hObject,'String')) returns contents of v2 as a double


% --- Executes during object creation, after setting all properties.
function v2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to v2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in x3.
function x3_Callback(hObject, eventdata, handles)
% hObject    handle to x3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of x3


% --- Executes on button press in scoreplot.
function scoreplot_Callback(hObject, eventdata, handles)


smat = getappdata (handles.pushbutton3,'smat');
vp= getappdata (handles.pushbutton3,'vp');
r=getappdata (handles.pushbutton3,'r');
c=getappdata (handles.pushbutton3,'c');

if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')

smat2 = getappdata (handles.pushbutton3,'smat2');
r2=getappdata (handles.pushbutton3,'r2');

end

v1=str2double(get(handles.v1,'String'));
v2=str2double(get(handles.v2,'String'));
    figure
    h2=plot(smat(:,v1),smat(:,v2),'r.');
    if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
      hold on
      h3=plot(smat2(:,v1),smat2(:,v2),'g.');
    end
    minv1=min(smat(:,v1));
    minv2=min(smat(:,v2));
    maxv1=max(smat(:,v1));
    maxv2=max(smat(:,v2));
    if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
      minv1=min([smat(:,v1);smat2(:,v1)]);
      minv2=min([smat(:,v2);smat2(:,v2)]);
      maxv1=max([smat(:,v1);smat2(:,v1)]);
      maxv2=max([smat(:,v2);smat2(:,v2)]);
    end
    set(gca,'XLim',[minv1-0.05*(maxv1-minv1) maxv1+0.05*(maxv1-minv1)]);
    set(gca,'YLim',[minv2-0.05*(maxv2-minv2) maxv2+0.05*(maxv2-minv2)]);
    set(gca,'xlabel',text(0,0,['Eigenvector ' int2str(v1) ' (' int2str(vp(:,v1)) '% of variance)' ]));
    set(gca,'ylabel',text(0,0,['Eigenvector ' int2str(v2) ' (' int2str(vp(:,v2)) '% of variance)' ]));
    set(h2,'markersize',4);
    if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
      set(h3,'markersize',14);
    end
    tot=[vp(:,v1) vp(:,v2)];
    totcum=cumsum(tot);
    title(['Object scores on eigenvectors ' int2str(v1) '-' int2str(v2) ' (' int2str(totcum(1,2)) '% of total variance)']); 
    if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'min')
      for a=1:r;
        text(smat(a,v1),smat(a,v2),int2str(a))
      end
    end
    if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'max')& get(handles.x3,'Value') == get(handles.x3,'min')
      for a=1:r2;
        text(smat2(a,v1),smat2(a,v2),int2str(a))
      end
      if get(handles.Autoscale,'Value') == get(handles.Autoscale,'Max')
        rad1=sqrt((vp(v1)*((r-1)/r)*c/100)*finv(.95,2,r-2)*2*(r^2-1)/(r*(r-2))); %plot ellipses
        rad2=sqrt((vp(v2)*((r-1)/r)*c/100)*finv(.95,2,r-2)*2*(r^2-1)/(r*(r-2)));
        t=0:pi/50:2*pi;
        plot(sin(t)*rad1,cos(t)*rad2,'r')
        rad1=sqrt((vp(v1)*((r-1)/r)*c/100)*finv(.99,2,r-2)*2*(r^2-1)/(r*(r-2)));
        rad2=sqrt((vp(v2)*((r-1)/r)*c/100)*finv(.99,2,r-2)*2*(r^2-1)/(r*(r-2)));
        t=0:pi/50:2*pi;
        plot(sin(t)*rad1,cos(t)*rad2,'--r')
        rad1=sqrt((vp(v1)*((r-1)/r)*c/100)*finv(.999,2,r-2)*2*(r^2-1)/(r*(r-2)));
        rad2=sqrt((vp(v2)*((r-1)/r)*c/100)*finv(.999,2,r-2)*2*(r^2-1)/(r*(r-2)));
        t=0:pi/50:2*pi;
        plot(sin(t)*rad1,cos(t)*rad2,':r')
      end         
    end
    axis('equal')
  

%smat = getappdata (0,'smat');
%vp= getappdata (0,'vp');
%r=getappdata (0,'r');
%c=getappdata (0,'c');
%if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
%smat2 = getappdata (0,'smat');
%r2=getappdata (0,'r2');
%end



% hObject    handle to scoreplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in TQplot.
function TQplot_Callback(hObject, eventdata, handles)
% hObject    handle to TQplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

nc=str2double(get(handles.components,'String'));
q = getappdata (handles.pushbutton3,'q');
q2 = getappdata (handles.pushbutton3,'q2');
t2 = getappdata (handles.pushbutton3,'t2');
vp= getappdata (handles.pushbutton3,'vp');
r=getappdata (handles.pushbutton3,'r')
c=getappdata (handles.pushbutton3,'c');

if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
q22 = getappdata (handles.pushbutton3,'q22');
t22 = getappdata (handles.pushbutton3,'t22');
r2=getappdata (handles.pushbutton3,'r2')

end


figure
h=plot(t2,q,'r.');
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'min')
  maxt2=max(t2);
  mint2=min(t2);
  maxq=max(q);
  minq=min(q);
else
  maxt2=max([t2;t22]);
  mint2=min([t2;t22]);
  maxq=max([q;q2]);
  minq=min([q;q2]);
end
set(gca,'XLim',[0 maxt2+0.05*(maxt2-mint2)]);
set(gca,'YLim',[0 maxq+0.05*(maxq-minq)]);
set(gca,'xlabel',text(0,0,['T^2' ]));
set(gca,'ylabel',text(0,0,['Q' ]));
set(h,'markersize',10);
axis('square')
hold on
l95t=nc*(r-1)/(r-nc)*finv(.95,nc,r-nc);
l99t=nc*(r-1)/(r-nc)*finv(.99,nc,r-nc);
l999t=nc*(r-1)/(r-nc)*finv(.999,nc,r-nc);
l95q=10.^(tinv(.95,r-1)*std(log10(q))+mean(log10(q))); % approximated formula for Q limits (assuming their logarithms are normally distributed)
l99q=10.^(tinv(.99,r-1)*std(log10(q))+mean(log10(q)));
l999q=10.^(tinv(.999,r-1)*std(log10(q))+mean(log10(q)));
plot([l95t l95t],[0 maxq+0.05*(maxq-minq)],'g')
plot([l99t l99t],[0 maxq+0.05*(maxq-minq)],'--g')
plot([l999t l999t],[0 maxq+0.05*(maxq-minq)],':g')
plot([0 maxt2+0.05*(maxt2-mint2)],[l95q l95q],'g')
plot([0 maxt2+0.05*(maxt2-mint2)],[l99q l99q],'--g')
plot([0 maxt2+0.05*(maxt2-mint2)],[l999q l999q],':g')
for a=1:r;
  if t2(a)>l95t|q(a)>l95q
    text(t2(a),q(a),int2str(a))
  end
end
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
  h=plot(t22,q2,'g.');
  set(h,'markersize',10);
  for a=1:r2;
    if t22(a)>l95t|q2(a)>l95q
      text(t22(a),q2(a),int2str(a))
    end
  end
end

figure
normval=[t2./l999t q./l999q];
normdist=sqrt(sum((normval.^2)'));
plot(normdist,'r')
out=0;
for i=1:r
  if normdist(i)>1
    text(i,normdist(i),int2str(i))
    out=out+1;
  end
end
disp (' ')
disp([' ' int2str(out) ' outliers detected ']);
totob=r;
hold on
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
  normval2=[t22./l999t q2./l999q];
  normdist2=sqrt(sum((normval2.^2)'));
  absi=r+1:r+r2
  plot(r:r+1,[normdist(r) normdist2(1)],'g')
  plot(absi,normdist2,'g')
  out=0;
  for i=1:r2
    if normdist2(i)>1
      text(absi(i),normdist2(i),int2str(i))
      out=out+1;
    end
  end
  disp (' ')
  disp([' ' int2str(out) ' objects of the test set out of the model of the training set ']);
  totob=r+r2
end
plot([1 totob],[1 1],'--g')
%set(gca,'XLim',[.5 totob+.5]);
%set(gca,'xlabel',text(0,0,['object number' ]));
%set(gca,'ylabel',text(0,0,['normalized distance on the T^2-Q plane' ]));



% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


lmat = getappdata (handles.pushbutton3,'lmat');
c=getappdata (handles.pushbutton3,'c');
v1=str2double(get(handles.v1,'String'));
v2=str2double(get(handles.v2,'String'));
vp=getappdata (handles.pushbutton3,'vp');

figure
tot=[vp(:,v1) vp(:,v2)];
    totcum=cumsum(tot);
h=plot(lmat(v1,:),lmat(v2,:),'r.');
    limax=[max(abs(lmat(v1,:))) max(abs(lmat(v2,:)))];
    limite=max(limax);
    set(gca,'XLim',[(-limite-(0.1*limite)) (limite+(0.1*limite))]);
    set(gca,'YLim',[(-limite-(0.1*limite)) (limite+(0.1*limite))]);
    set(gca,'xlabel',text(0,0,['Eigenvector ' int2str(v1) ' (' int2str(vp(:,v1)) '% of variance)' ]));
    set(gca,'ylabel',text(0,0,['Eigenvector ' int2str(v2) ' (' int2str(vp(:,v2)) '% of variance)' ]));
    set(h,'markersize',4);
    title(['Variable loadings on eigenvectors ' int2str(v1) '-' int2str(v2) ' (' int2str(totcum(1,2)) '% of total variance)' ]);
    hold on
    plot(0,0,'+r')
    for a=1:c;
     text(lmat(v1,a),lmat(v2,a),int2str(a))
    end
    axis('equal')
 



% --- Executes on button press in TestsetCheckbox.
function TestsetCheckbox_Callback(hObject, eventdata, handles)
if get(handles.TestsetCheckbox,'Value') == get(handles.TestsetCheckbox,'Max')
    set(handles.XTest,'Enable', 'on')
  else
set(handles.XTest,'Enable', 'off')
end
% hObject    handle to TestsetCheckbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of TestsetCheckbox





function ng_Callback(hObject, eventdata, handles)
% hObject    handle to ng (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ng as text
%        str2double(get(hObject,'String')) returns contents of ng as a double


% --- Executes during object creation, after setting all properties.
function ng_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ng (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double


% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


