function newresult = eemizesort(result,method);

%EEMIZESORT for detecting goodness in different ways
%
% newresult=eemizesort(result,method);
%
% where result is the structure output from eemizer. Method 2 may be useful
% when data e.g. does not support split-half validation but still produces
% high core consistency models.
% 
% method = 1: Standard objective, maximize FIT*COREC*SPLTH
% method = 2: Maximize max(FIT*COREC,FIT*SPLTH)
% method = 3: Maximize FIT*COREC
% method = 4: Maximize FIT*SPLTH
% 

newresult = result;
for i=1:length(result)
    if isfield(result{i},'bestmodel'); % Otherwise its not calculated for that number of components
        alll = result{i}.allmeasures.data;
        if method==1
            loss = prod(alll(:,1:3),2);
            [a,b]=sort(loss);
            b = flipud(b);
        elseif method == 2;
            loss1 = prod(alll(:,1:2),2);
            loss2 = prod(alll(:,[1 3]),2);
            loss = max([loss1 loss2],[],2);
            [a,b]=sort(loss);
            b = flipud(b);
        elseif method == 3;
            loss = prod(alll(:,[1 3]),2);
            [a,b]=sort(loss);
            b = flipud(b);
        elseif method == 4;
            loss = prod(alll(:,[1 2]),2);
            [a,b]=sort(loss);
            b = flipud(b);
        else
            error('Method must be 1, 2, 3 or 4')
        end
    end
    newresult{i}.othermodels=result{i}.othermodels(b);
    newresult{i}.bestmodel=result{i}.othermodels{b(1)};
    newresult{i}.allmeasures=result{i}.allmeasures(b,:);
    newresult{i}.allmeasures.data(:,4)=flipud(a)/10000;
end
eemizer(result);