function toplot_coomans(distsimca,Fsimca, icx, icy, iclass, classtest,crit)

%%% Make Coomans plot class i vs. class j
%  toplot_coomans(distsimca,Fsimca,icx,icy,iclass, classtest,crit)
%

%% INPUT: 
%% distsimca, Fsimca = comes from make_Coomans_simca
%% icx = number of class on x-axis
%% icy = number of class on y-axis
%% iclass=class index for calibration set
%% classtest= class index for test set if any
%% crit = flag for type of distances to be computed, can be:
%% 'fit' ; 'cv '; 'fp '
%%
i=icx;
j=icy;
if lower(crit)=='fit'
    icrit=1
elseif lower(crit)=='cv '
    icrit=2
elseif lower(crit)=='fp '
    icrit=3
end
ntr_x=length(distsimca(1,i).Sp2train{icrit});
no_x=length(distsimca(1,i).Sp2_o{icrit});
if ~isempty(classtest)
    nts_x=length(distsimca(1,i).Sp2_est{icrit});
end
    

ntr_y=length(distsimca(1,j).Sp2train{icrit});
no_y=length(distsimca(1,j).Sp2_o{icrit});
if ~isempty(classtest)
    nts_y=length(distsimca(1,j).Sp2_est{icrit});
end

nc=nonzeros(unique(iclass));
ci_c=find(iclass);
classid=iclass(ci_c); 

nc_x=setdiff(nc,i);
indtr_x=find(classid==i);
indo_x=setdiff([1:length(classid)],indtr_x);
classo_x=classid(indo_x);

nc_y=setdiff(nc,j);
indtr_y=find(classid==j);
indo_y=setdiff([1:length(classid)],indtr_y);
classo_y=classid(indo_y);

col=['^r'; 'sb'; 'og'; 'dm'];
fcol=['r'; 'b';'g';'m'];
figure;plot(distsimca(1,i).Sp2train{icrit},distsimca(1,j).Sp2_o{icrit}(find(classo_y==i),:),col(i,:),'MarkerFaceColor',fcol(i,:),'Markersize',8)
hold on;plot(distsimca(1,i).Sp2_o{icrit}(find(classo_x==j),:),distsimca(1,j).Sp2train{icrit},col(j,:),'MarkerFaceColor',fcol(j,:),'Markersize',8)
nk=setdiff(nc,[i j]);
for k=1:length(nk)
    hold on;plot(distsimca(1,i).Sp2_o{icrit}(find(classo_x==nk(k)),:),distsimca(1,j).Sp2_o{icrit}(find(classo_y==nk(k)),:),col(nk(k),:),'MarkerFaceColor',fcol(nk(k),:),'Markersize',8)
end

% test
if ~isempty(classtest)
    for it=1:length(nc)
        hold on;plot(distsimca(1,i).Sp2_est{icrit}(find(classtest==it)),distsimca(1,j).Sp2_est{icrit}(find(classtest==it)),col(it,:),'Markersize',8)
    end
end

title('class on x-axis: red triangles; class on y-axis: blu square; [train: filled/ test: empty] ')
xlabel(strcat('Distance from CLASS ',int2str(i)),'fontsize',14,'fontweight','b');
ylabel(strcat('Distance from CLASS ',int2str(j)),'fontsize',14, 'fontweight','b');

if icrit==1
    vline(Fsimca(i).Flimtr,'k')
    hline(Fsimca(j).Flimtr,'k')
elseif icrit==2
    vline(Fsimca(i).FlimCV,'r')
    hline(Fsimca(j).FlimCV,'r')
elseif icrit==3
    vline(Fsimca(i).Flimfp,'m')
    hline(Fsimca(j).Flimfp,'m')
end
fnam=strcat('coomans',int2str(i),'_',int2str(j),crit);
hgsave('fnam')



