function toplot(ci_test)
%% toplot(ci_test)
% for plotting vs number of Factors
% 
%  ci_test = vector of class assignitation for test set if any

% toplot(ci_test)


load CVResults
load classResults
nc=size(SENSf,1);

figure(1);
figure(2);
if nc > 1; 
    figure(3);
    figure(4);
end
for i=1:nc
    nftot=size(SENSf,3);
    figure(1);subplot(nc,1,i);plot([1:nftot],shiftdim(SENSf(i,:,:)),'-d')
    title(strcat('CLASS ',int2str(i)))
    if nc>1
        hold on;subplot(nc,1,i);plot([1:nftot],shiftdim(SPECf(i,:,:)),':^')
        ylabel('SENS (solid lines) / SPEC (dotted lines)')
    else
        ylabel('SENS')
    end
    if i==1
        legend('H/Q-fit','H/Q-CVper','H/Q-fitAP','H/Q-CVAP','S-orig','S-origCV','S-origfp')
    end

    figure(2);subplot(nc,1,i);plot([1:nftot],shiftdim(SENSf_CV(i,:,:)),'-d')
    title(strcat('CLASS ',int2str(i)))
    
    if nc>1
        hold on;subplot(nc,1,i);plot([1:nftot],shiftdim(SPECf_CV(i,:,:)),':^')
        ylabel('SENS-CV (solid lines) / SPEC-CV (dotted lines)')
    else
       ylabel('SENS-CV')  
    end

    if i==1
        legend('H-CV/Q-CV fit lim','H-CV/Q-CV CV lim','H-CV/Q-CV lim fitAP','H-CV/Q-CV lim CVAP')
    end
    if nc > 1
        efficiency(i,:,:)=sqrt(shiftdim(SENSf(i,:,:)).*shiftdim(SPECf(i,:,:)));
        figure(3); subplot(nc,1,i); plot([1:nftot],(shiftdim(efficiency(i,:,:))'),'-d');
        title(strcat('CLASS ',int2str(i)))
        ylabel('EFFICIENCY')
        
        if i==1
            legend('H/Q-fit','H/Q-CVper','H/Q-fitAP','H/Q-CVAP','S-orig','S-origCV')
        end
        efficiency_CV(i,:,:)=sqrt(shiftdim(SENSf_CV(i,:,:)).*shiftdim(SPECf_CV(i,:,:)));
        figure(4); subplot(nc,1,i); plot([1:nftot],(shiftdim(efficiency_CV(i,:,:))'),'-d');
        title(strcat('CLASS ',int2str(i)))
        ylabel('EFFICIENCY-CV')
        
        if i==1
            legend('H-CV/Q-CV fit lim','H-CV/Q-CV CV lim','H-CV/Q-CV lim fitAP','H-CV/Q-CV lim CVAP')
        end
    end
end
figure(1);hgsave('SENS_SPEC_vs_Fac');
if nc > 1; figure(3);hgsave('Efficiency_vs_Fac'); end
figure(2);hgsave('SENSCV_SPECCV_vs_Fac');
if nc >1; figure(4);hgsave('EfficiencyCV_vs_Fac'); end

%xlabel('N Factors', 'fontsize', '14')
% bestF = number of user selected components for each class
bestF=input('Give the number of Components/Combinations to be used for each class');
% for constructing SENS SPEC table
for i=1:nc
    SENS_bF(i,:)=shiftdim(SENSf(i,:,bestF(i)));
    if nc > 1; SPEC_bF(i,:)=shiftdim(SPECf(i,:,bestF(i))); end
    if exist('ci_test')
        numc=length(find(ci_test==i));
        SENS_bF_test(i,:)=100*((sum(classtestf(bestF(i),i).cassTest(find(ci_test==i),:)))./numc);
        no=setdiff(find(ci_test),find(ci_test==i));
        SPECtot_bF_test(i,:)=100-100*((sum(classtestf(bestF(i),i).cassTest(no,:)))./length(no));
        if nc>1
            j=setdiff([1:nc],i);
            for k=1:length(j)
                SPEC_bF_test(i,:,k)=100-100*((sum(classtestf(bestF(i),i).cassTest(find(ci_test==j(k)),:)))./(length(find(ci_test==j(k)))));
            end
        else
            SPEC_bF_test(i,:,1)=100-100*((sum(classtestf(bestF(i),i).cassTest(find(ci_test==0),:)))./(length(find(ci_test==0))));
        end
        
    end
end
if nc > 1; save efficiency efficiency efficiency_CV; end
if nc > 1
    if exist('ci_test')
        save SENS_SPEC_best SENS_bF SPEC_bF SENS_bF_test SPEC_bF_test bestF SPECtot_bF_test
    else
        save SENS_SPEC_best SENS_bF SPEC_bF bestF
    end
else
    if exist('ci_test')
        save SENS_SPEC_best SENS_bF SENS_bF_test SPEC_bF_test bestF
    else
        save SENS_SPEC_best SENS_bF bestF
    end
    
end
