function vip = VIP3(Xfactors, ypred);
% calculation of VIP for mode 2 variables.
%INPUT:
%Xfactors, ypred  output from a npls run
%OUTPUT:
% vip  vip scores for each variable in Mode 2
%
wj=Xfactors{2};
[J A]=size(wj);
SSY=shiftdim(sum(sum(ypred.^2)));
SSYtot=SSY(A);
vip=sqrt(sum((wj.^2.*(ones(J,1)*((SSY*J)./(SSYtot*A))'))'));
