function view_models(out, data, best, int)
%VIEW_MODELS for viewing output of AUTOCHROME
% 
% visualizes the models included in "out", which 
% is the output from autochrome.m
%
% data:  holds the raw data
% best:  if ~= 0 it should be a vector with same length as 
%           the intervals included in out stating the specific 
%           model for each interval which one wants to inspect.
% int :    If only part of the intervals from out is to be 
%            plotted the interval number should be included.
% 
% I/O: view_models(out, data, best, int)

col = [0 0 1; 0 0.5 0; 1 0 0; 0 0.75 0.75; 0.75 0  0.75; 0.75 0.75 0; 0.25 0.25 0.25];

if nargin == 4;
    I = int;
else
    I = 1:size(out.int,1);
end

figure
for i1 = I
    x = data(:,out.int(i1,1):out.int(i1,2),:);
    rt = out.rt(out.int(i1,1):out.int(i1,2));
    if nargin < 3
        f = 2;
        F = out.totalFactors(i1);
    elseif nargin == 4 && isempty(best) == 1
        f = 2;
        F = out.totalFactors(i1);
    else
        f = best(1);
        F = best(end);
    end
    
    for i2 = f:F
        a = out.models{i1,i2}.loads{2};
        c = out.models{i1,i2}.loads{3};
        h = out.models{i1,i2}.loads{1}.H;
        p = out.models{i1,i2}.loads{1}.P;
        
        name = horzcat('Interval ', num2str(i1), ', with ', num2str(i2), ...
            ' factor(s). Best with ', num2str(out.nfactors(i1)), ...
            '. Pred. prob. = ', num2str(out.models{i1,i2}.predprob), ...
            '. Fit = ', num2str(out.models{i1,i2}.fit), ...
            '. Cc = ', num2str(out.parameters{i1,i2}(3)));
        set(gcf,'Name',name,'NumberTitle','off')
        subplot(2,3,1)
        for i3 = 1:length(p)
            plot(rt, p{i3}*h), hold on
        end
        hold off
        title('Elution profiles')
        xlabel('rt (min)')
        axis tight
        subplot(2,3,2)
        plot(rt, squeeze(sum(x,1)))
        title('TIC')
        xlabel('rt (min)')
        axis tight
        subplot(2,3,3)
        hbar = bar(a, 0.1);
        for i3 = 1:i2
            set(hbar(i3), 'FaceColor', col(i3,:))
            set(hbar(i3), 'Edgecolor', col(i3,:))
        end
        title('Compound spectra')
        xlabel('m/z')
        axis tight
        subplot(2,3,4)
        d = zeros(size(c,2));
        for i3 = 1:length(p)
            for ii = 1:size(c,2)
                d(ii,ii) = c(i3,ii);
            end
            plot(rt, p{i3}*h*d), hold on
        end
        hold off
        title('Weighted elution profiles')
        xlabel('rt (min)')
        axis tight
        subplot(2,3,5)
        e  = zeros(length(a), length(p{1,1}), length(c));
        for i3 = 1:size(p,2)
            d = zeros(size(c,2));
            for ii = 1:size(c,2)
                d(ii,ii) = c(i3,ii);
            end
            e(:,:,i3) = x(:,:,i3) - (a*d*(p{1,i3}*h)');
        end
        E = squeeze(sum(e));
        plot(rt, E)
        xlabel('rt (min)')
        title('"TIC" for residuals')
        axis tight
        subplot(2,3,6)
        plot(c)
        legend('show')
        title('Concentration profiles')
        xlabel('Sample no.')
        axis tight
        shg
        pause
        clear a c h p
    end
end