function pl=plotload(A,B,cl);

%PLOTLOAD function for plotting clusters from SMR
% 
% plotload(A,B);    

if nargin<3
    cl=1;
end


% Check if class exist and should be used.
col=colormap(summer);
if length(A.class{1,cl})==size(A,1)
    c1 = A.class{1,cl};
    uc1 = unique(c1);
else
    c1 = 0;
    uc1=0;
end
if length(B.class{2,cl})==size(B,1)
    c2 = B.class{2,cl};
    uc2 = unique(c2);
else
    c2 = 0;
    uc2=0;
end    
    
clf
F=size(A.data,2);
F1=round(sqrt(F));
F2=ceil(F/F1);

% Adjust fontsize to number of components
fntsze=max(5,round(20-F*.6));

for f=1:F,
    subplot(F1,F2,f)
    plotloads(A,B,f,fntsze,{c1 uc1 c2 uc2 col});
    title(['Cluster ',num2str(f)],'fontsize',fntsze*1.4,'fontweight','bold')
end

function pl=plotloads(A,B,f,sz,classes)

fnttype = 'Arial';

A = A(:,f);
B = B(:,f);
A.data = A.data/max(abs(A.data));
B.data = B.data/max(abs(B.data));
j1 = find(abs(A.data)>.2);
j2 = find(abs(B.data)>.2);
c1 = classes{1};uc1 = classes{2};
c2 = classes{3};uc2 = classes{4};
col = classes{5};
col1 = round(linspace(1,64,length(uc1)));
col2 = round(linspace(1,64,length(uc2)));

for i=1:length(j1)
    try
        txt = A.label{1}(j1(i),:);
    catch
        txt = ['Samp ',num2str(j1(i))];
    end

    magni=abs(A.data(j1(i),1)).^(.5);
    if length(uc1)>1
        [k1,k2]=find(uc1==c1(j1(i)));
        if A.data(j1(i),1)>0 % Use one color for positive and another for negative
            colr = col(col1(k2),:);
        else
            colr = [0 0 0];
            colr(1:2)=col(col1(k2),[2 3]);
        end
    else
        k2=1;
        colr = [0 0 0];
    end
    h=text(0,i,txt,'color',colr);
    set(h,'fontsize',sz*magni,'fontweight','bold','fontname',fnttype);
    hold on
    axis([0 1 0 length(j1)])
end
axis off

for i=1:length(j2)
    try
        txt = B.label{1}(j2(i),:);
    catch
        txt = ['Var ',num2str(j2(i))];
    end
    if isempty(deblank(txt)) % Add a variable name
        txt = ['Var ',num2str(j2(i))];
    end
    magni=B.data(j2(i),1).^(.5);
    h=text(2,i,txt);
    set(h,'fontsize',sz*magni,'fontweight','bold','fontname',fnttype);
    % set(h,'color',[1-magni 1-magni 1-magni]);
    set(h,'color',[0 0 0]);
    hold on
    axis([0 4 0 max(length(j2),length(j1))])
end
hold off
axis off