# Script to generate Au20Pd80 alloys by considering the (111) surface - TERRACE ATOMS 
# with the average bulk lattice parameter of the elements in the HEA
from ase.db import connect
from ase import Atoms, Atom
from ase.io import *
import numpy as np
import itertools as it
from copy import deepcopy
from ase.visualize import view

# Define elements and composition in the high-entropy alloys
elements = (['Au']*13 + ['Pd']*51)

# get lattice parameters of each metals (values taken from the optimized bulk structures, Angstroms)
lattice = dict(np.loadtxt('lattice.dat', dtype='U10,f4', delimiter=','))

if True:
    # call the optimized structure 
    slab = read('terrace.traj')
    # Be sure that elements and slab have the same array
    # If YES, then make a random alloys by using the random.shuffle function
    # If NOT, then you can modificate the array in elements
    assert(len(slab)%len(elements)==0)
    symbols = len(slab)//len(elements) * elements
    np.random.shuffle(symbols)
    slab.set_chemical_symbols(symbols)
    # calculate the average lattice parameter of elements in the alloy
    lat = np.mean([lattice[metal] for metal in symbols])
    # calculate the corresponding interatomic distance
    new_dist = lat / np.sqrt(2)
    print(new_dist)
    # get current interatomic distance
    old_dist = slab.get_distance(0, 1)
    # calculate the scaling to be applied to the unit cell to get a
    # slab with the lattice parameter dictated by the surface elements
    scaling = new_dist / old_dist
    # set new unit cell
    cell = slab.cell
    new_cell = cell*scaling
    slab.set_cell(new_cell, scale_atoms=True)
    slab.center(vacuum=10, axis=2)
    slab.write('slab.traj')
