#Optimize Au20Pd80 alloy without the terrace atom                 
from ase.io import read, write
from ase.visualize import view
from gpaw import GPAW, PW
from ase.optimize import QuasiNewton

#call the alloy structure
alloy = read('X.traj')
del alloy[14]
#symbolss = alloy.get_chemical_symbols()
#symbolss[14] = 'Au'
#alloy.set_chemical_symbols(symbolss)

#Set-up to optimize the X_alloy
calc = GPAW(mode=PW(400), xc='RPBE', kpts=(4,4,1), txt='notT.txt')
alloy.set_calculator(calc)
relax = QuasiNewton(alloy)
relax.run(fmax=0.05)
alloy.write('notT.traj')
