#Optimize Ag bulk                             
from ase import Atoms, Atom
from ase.io import *
import numpy as np
from ase.visualize import view
from ase.build import bulk
from gpaw import GPAW, PW
from ase.optimize import QuasiNewton
from ase.optimize import BFGS
from ase.constraints import StrainFilter

a= 3.8898 #from Wyckoff R W G
pd = bulk('Pd', 'fcc', a=a)

#Calculate the energy of Pt (211) with RPBE, PW, and KPOINTS
calc = GPAW(mode=PW(400), xc='RPBE', kpts=(10,10,10), txt='pd.txt')
pd.calc = calc 
sf = StrainFilter(pd)
opt = BFGS(sf)
opt.run(0.005)
pd.write('pd.traj')

