#Optimize Ag bulk                             
from ase import Atoms, Atom
from ase.io import *
import numpy as np
from ase.visualize import view
from ase.build import bulk
from gpaw import GPAW, PW
from ase.optimize import QuasiNewton
from ase.optimize import BFGS
from ase.constraints import StrainFilter

a= 4.0783 #from Wyckoff R W G
au = bulk('Au', 'fcc', a=a)

#Calculate the energy of Pt (211) with RPBE, PW, and KPOINTS
calc = GPAW(mode=PW(400), xc='RPBE', kpts=(10,10,10), txt='au.txt')
au.calc = calc 
sf = StrainFilter(au)
opt = BFGS(sf)
opt.run(0.005)
au.write('au.traj')

