# Script to generate Fig. 5
from ase.db import connect
import matplotlib.pyplot as plt
import numpy as np

# load the dB files for each type of atom
# Terrace ATOMS
tau = 'dB/Au_T.db'
tpd = 'dB/Pd_T.db'
notTer = 'dB/notT.db'
# Edge ATOMS
eau = 'dB/Au_E.db'
epd = 'dB/Pd_E.db'
notEdge = 'dB/notE.db'
# Kink ATOMS
kau = 'dB/Au_K.db'
kpd = 'dB/Pd_K.db'
notKink = 'dB/notK.db'
# Ad ATOMS
a_au = 'dB/Au_A.db'
a_pd = 'dB/Pd_A.db'
notAd = 'dB/notA.db'
w = 0.020

# Get the energy for the dissolution of each terrace, edge, kink, and adatoms from the databases, 
# then convert the values into potentials by using the standard electrode potentials for the 
# Pd and Au ions formation under HCl electrolyte vs SHE
# ====== Terrace atoms ======
y1 = []  # Au atoms
for row in connect(tau).select():
    slab = connect(tau).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notTer).select(SlabId=SlabId):
        energy = ref.energy - 2.56 - row.energy
        potential = 1.00 + energy/3
        y1.append(potential)
y1 = np.array(y1)

y2 = []  # Pd atoms
for row in connect(tpd).select():
    slab = connect(tpd).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notTer).select(SlabId=SlabId):
        energy = ref.energy - 3.22 - row.energy
        potential = 0.56 + energy/2
        y2.append(potential)
y2 = np.array(y2)

# ====== Edge atoms ======
y3 = []  # Au atoms
for row in connect(eau).select():
    slab = connect(eau).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notEdge).select(SlabId=SlabId):
        energy = ref.energy - 2.56 - row.energy
        potential = 1.00 + energy/3
        y3.append(potential)
y3 = np.array(y3)

y4 = []  # Pd atoms
for row in connect(epd).select():
    slab = connect(epd).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notEdge).select(SlabId=SlabId):
        energy = ref.energy - 3.22 - row.energy
        potential = 0.56 + energy/2
        y4.append(potential)
y4 = np.array(y4)

# ====== Kink atoms ======
y5 = []  # Au atoms
for row in connect(kau).select():
    slab = connect(kau).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notKink).select(SlabId=SlabId):
        energy = ref.energy - 2.56 - row.energy
        potential = 1.00 + energy/3
        y5.append(potential)
y5 = np.array(y5)

y6 = []  # Pd atoms
for row in connect(kpd).select():
    slab = connect(kpd).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notKink).select(SlabId=SlabId):
        energy = ref.energy - 3.22 - row.energy
        potential = 0.56 + energy/2
        y6.append(potential)
y6 = np.array(y6)

# ====== Ad atoms ======
y7 = []  # Au atoms
for row in connect(a_au).select():
    slab = connect(a_au).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notAd).select(SlabId=SlabId):
        energy = ref.energy - 2.56 - row.energy
        potential = 1.00 + energy/3
        y7.append(potential)
y7 = np.array(y7)

y8 = []  # Pd atoms
for row in connect(a_pd).select():
    slab = connect(a_pd).get_atoms(row.id)
    SlabId = row.SlabId
    for ref in connect(notAd).select(SlabId=SlabId):
        energy = ref.energy - 3.22 - row.energy
        potential = 0.56 + energy/2
        y8.append(potential)
y8 = np.array(y8)

# =============================
# Plot the distribution values
# =============================
# Plot setup
fig, ax = plt.subplots(figsize=(8, 6))
# ========================
# Draw the histograms
# ========================
ax.hist(y1, bins=np.arange(min(y1), max(y1) + w, w), label='Terrace', color='darkorange', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y3, bins=np.arange(min(y3), max(y3) + w, w), label='Edge', color='dodgerblue', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y5, bins=np.arange(min(y5), max(y5) + w, w), label='Kink', color='limegreen', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y7, bins=np.arange(min(y7), max(y7) + w, w), label='Ad', color='gold', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y2, bins=np.arange(min(y2), max(y2) + w, w), label='', color='darkorange', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y4, bins=np.arange(min(y4), max(y4) + w, w), label='', color='dodgerblue', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y6, bins=np.arange(min(y6), max(y6) + w, w), label='', color='limegreen', alpha=0.85, histtype='stepfilled', ec='black')
ax.hist(y8, bins=np.arange(min(y8), max(y8) + w, w), label='', color='gold', alpha=0.85, histtype='stepfilled', ec='black')

# Draw experimental potential for each element on HCl electrolyte
x7, y7 = [1.00, 1.00], [0, 33]
plt.plot(x7, y7, color='red', lw=2)
x8, y8 = [0.56, 0.56], [0, 32.5]
plt.plot(x8, y8, color='dodgerblue', lw=2)

# Extra lines
x1, y1 = [0.252, 1.01], [32.5, 32.5]
x2, y2 = [0.252, 0.252], [30, 32.5]
x3, y3 = [1.01, 1.01], [30, 32.5]
plt.plot(x1, y1, x2, y2, x3, y3, color='black')

x4, y4 = [0.95, 1.48], [33, 33]
x5, y5 = [0.95, 0.95], [30, 33]
x6, y6 = [1.48, 1.48], [30, 33]
plt.plot(x4, y4, x5, y5, x6, y6, color='black')

# ======== Labels ========
ax.text(1.0750, 37, 'Au$_{0.20}$Pd$_{0.80}$', fontsize=20, weight='bold')
ax.text(0.6, 30, 'Pd', fontsize=20, weight='bold', color='dodgerblue')
ax.text(1.3, 30, 'Au', fontsize=20, weight='bold', color='red')
plt.legend(loc="upper left", ncol=2, fontsize=12)
# =========
plt.subplots_adjust(left=0.05, bottom=0.11, right=0.99, top=0.99, wspace=None, hspace=None)

# Define the limits
plt.xticks(fontsize=16)
plt.yticks([])
plt.xlabel('$\ E°_\mathrm{diss}$ [V, vs SHE]', x=0.5, y=0.05, fontsize=18)
plt.ylabel('Frequency', x=0.0, y=0.50, fontsize=18)
plt.xlim(0.24, 1.495)
plt.ylim(0, 40)

# Save image to file
plt.savefig('Fig5.tif', bbox_inches='tight', dpi=1200)
plt.show()

