# Script to make a nanoparticle of approximately D = 2.20nm
from ase.io import *
import numpy as np
from ase.cluster import wulff_construction
from ase.neighborlist import NeighborList

# ================================== Step 1 - Generate a random Nanoparticle ================================= #
# Define the exposed crystallographic facets in the nanoparticle 
surfaces = [(1, 1, 1), (1, 0, 0), (1, 1, 0)]  # Exposed crystallographic facets
esurf = [1.36, 1.54, 1.60]  # Surface energies, from Phys. Chem. Chem. Phys., 2021, 23, 14649–14661, at PBE
lc = 3.9627 # we used the optimized Pd lattice parameter with RPBE functional 
size = 350  
# Make a Pd nanoparticle with D = 2.16nm
nano_p = wulff_construction('Pd', surfaces, esurf, size, 'fcc', rounding='above', latticeconstant=lc)
nano_p.write('catlow_pbe.traj')

