# Script to make a nanoparticle of approximately D = 3.60nm
from ase.io import *
import numpy as np
from ase.cluster import wulff_construction
from ase.neighborlist import NeighborList

# ================================== Step 1 - Generate a random Nanoparticle ================================= #
# Define the exposed crystallographic facets in the nanoparticle 
surfaces = [(1, 1, 1), (1, 0, 0)]  # Exposed crystallographic facets
esurf = [1.0, 1.0]  # Surface energies
lc = 3.9627  # we used the optimized Pb bulk lattice parameter at RPBE
size = 1200
# Make a Pd nanoparticle with D = 3.53nm
nano_p = wulff_construction('Pd', surfaces, esurf, size, 'fcc', rounding='above', latticeconstant=lc)
nano_p.write('our_1Jm.traj')

