# Script to get a database with the dissolution percentage of a given
# nanoparticle of approximately D = 4.14 nm, Fig. 5d
from statistics import mean
from ase.db import connect
import csv

# define the nanoparticle databases
databases = {
    "au10": "au10/au10end.db",
    "au15": "au15/au15end.db",
    "au20": "au20/au20end.db",
    "au25": "au25/au25end.db",
    "au30": "au30/au30end.db",
    "au35": "au35/au35end.db",
    "au40": "au40/au40end.db",
    "au45": "au45/au45end.db",
    "au50": "au50/au50end.db",
}

# Define a function to count the remaining atoms for a given database 
def count_atoms(database):
    results = []
    for row in connect(database).select():
        line = row.symbols
        n_pd = line.count("Pd")
        n_au = line.count("Au")
        results.append(n_pd + n_au)
    return results

# Calculate the mean remaining atoms in the NPs and the dissolution percentage       
# For a given Au molar fraction 
data = []
for Aufraction, database in databases.items():
    results = count_atoms(database)
    mean_remained_atoms = mean(results)
    dissolution_per = round((100 - (mean_remained_atoms / 2129) * 100), 2)
    data.append((Aufraction, mean_remained_atoms, dissolution_per))

# save the results to a CSV file
with open("dataDISS4.14nm.csv", "w", newline="") as f:
    writer = csv.writer(f)
    writer.writerow(["Au fraction", "Mean remaining atoms", "Dissolution Percentage"])
    for row in data:
        writer.writerow(row)
