# ----------------------------------------------------------------------------------
# Script to generate Fig. S3
# ----------------------------------------------------------------------------------
from matplotlib import pyplot as plt
import pandas as pd
# ----------------------------------------------------------------------------------

# ----------------------------------------------------------------------------------
# Read the databases
# ----------------------------------------------------------------------------------
df1 = pd.read_csv('np2.20nm/dataSurfAtoms2.20nm.csv')
df2 = pd.read_csv('np2.48nm/dataSurfAtoms2.48nm.csv')
df3 = pd.read_csv('np3.17nm/dataSurfAtoms3.17nm.csv')
df4 = pd.read_csv('np4.14nm/dataSurfAtoms4.14nm.csv')
# ----------------------------------------------------------------------------------

# ----------------------------------------------------------------------------------
# Define colors, X variable, and error bars with fixed value ±1.5
# ----------------------------------------------------------------------------------
color_list = ['indianred', 'forestgreen', 'dodgerblue', 'magenta', 'darkorange',
              'pink', 'limegreen', 'lightcoral', 'lightseagreen']

X = ["Au$_{0.10}$", "Au$_{0.15}$", "Au$_{0.20}$", "Au$_{0.25}$",
     "Au$_{0.30}$", "Au$_{0.35}$", "Au$_{0.40}$", "Au$_{0.45}$", "Au$_{0.50}$"]

error = 1.5
# ----------------------------------------------------------------------------------

# ----------------------------------------------------------------------------------
# Panel 6(a)
# ----------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (0, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y1 = df1['% of Pd atoms at surface']
graph = plt.bar(X, Y1, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y1, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y1):
    plt.text(x=index-0.285, y=data+4, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(a) D=2.20nm', fontsize=10)  # weight='bold'
# ----------------------------------------------------------------------------------

# ----------------------------------------------------------------------------------
# Panel 6(b)
# ----------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (1, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y2 = df2['% of Pd atoms at surface']
graph = plt.bar(X, Y2, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y2, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y2):
    plt.text(x=index-0.285, y=data+4, s=f"{data}", fontdict=dict(fontsize=9))

plt.tight_layout()

# Define the limits
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(b) D=2.48nm', fontsize=10)  # weight='bold'
# ----------------------------------------------------------------------------------

# ----------------------------------------------------------------------------------
# Panel 6(c)
# ----------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (2, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y3 = df3['% of Pd atoms at surface']
graph = plt.bar(X, Y3, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y3, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y3):
    plt.text(x=index-0.285, y=data-17, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(c) D=3.17nm', fontsize=10)  # weight='bold'
# ----------------------------------------------------------------------------------

# ----------------------------------------------------------------------------------
# Panel 6(d)
# ----------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (3, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y4 = df4['% of Pd atoms at surface']
graph = plt.bar(X, Y4, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y4, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y4):
    plt.text(x=index-0.285, y=data-17, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xlabel('Gold molar fraction', x=0.5, y=0.05, fontsize=12)
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(d) D=4.14nm', fontsize=10)  # weight='bold'
# ----------------------------------------------------------------------------------

# Subplots adjust
plt.subplots_adjust(left=0.10, bottom=0.10, right=0.99, top=0.97, wspace=None, hspace=0.35)
# plt.subplots_adjust(hspace=0.35)
plt.ylabel('Pd at the surface %', x=0, y=2.5, fontsize=12)

# Intructions for the exit format: png, eps, ps, svg$
plt.savefig('FigS3.tif', bbox_inches='tight', dpi=1200)
plt.show()
