# --------------------------------------------------------------------------------------
# Script to generate Fig. 3
# ---------------------------------------------------------------------------------------
from matplotlib import pyplot as plt
import pandas as pd
# ---------------------------------------------------------------------------------------

# --------------------------------------------------------------------------------------
# Read the databases for each nanoparticle
# --------------------------------------------------------------------------------------
df1 = pd.read_csv('np1.80nm/dataDISS1.80nm.csv')
df2 = pd.read_csv('np2.90nm/dataDISS2.90nm.csv')
df3 = pd.read_csv('np3.60nm/dataDISS3.60nm.csv')
df4 = pd.read_csv('np5.25nm/dataDISS5.25nm.csv')
# ---------------------------------------------------------------------------------------

# ---------------------------------------------------------------------------------------
# Define colors, X variable, and error bars with fixed value ±1.5
# ---------------------------------------------------------------------------------------
color_list = ['indianred', 'forestgreen', 'dodgerblue', 'magenta', 'darkorange',
              'pink', 'limegreen', 'lightcoral', 'lightseagreen']

X = ["Au$_{0.10}$", "Au$_{0.15}$", "Au$_{0.20}$", "Au$_{0.25}$",
     "Au$_{0.30}$", "Au$_{0.35}$", "Au$_{0.40}$", "Au$_{0.45}$", "Au$_{0.50}$"]

error = 1.5
# --------------------------------------------------------------------------------------

# ---------------------------------------------------------------------------------------
# Panel 3(a)
# ---------------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (0, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y1 = df1['Dissolution Percentage']
graph = plt.bar(X, Y1, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y1, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y1):
    plt.text(x=index-0.285, y=data-14.5, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(a) D=1.80nm', fontsize=10)  # weight='bold'


# -----------------------------------------------------------------------------------------
# Panel 3(b)
# -----------------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (1, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y2 = df2['Dissolution Percentage']
graph = plt.bar(X, Y2, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y2, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y2):
    plt.text(x=index-0.285, y=data+4, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(b) D=2.90nm', fontsize=10)  # weight='bold'

# ------------------------------------------------------------------------------------------
# Panel 3(c)
# ------------------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (2, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y3 = df3['Dissolution Percentage']
graph = plt.bar(X, Y3, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y3, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y3):
    plt.text(x=index-0.285, y=data+4, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(c) D=3.60nm', fontsize=10)  # weight='bold'

# -----------------------------------------------------------------------------------------
# Panel 3(d)
# -----------------------------------------------------------------------------------------
ax = plt.subplot2grid((4, 1), (3, 0))
ax.axes.get_xaxis().set_visible(True)
# Plot the mean values in a bar plot
Y4 = df4['Dissolution Percentage']
graph = plt.bar(X, Y4, color=color_list, alpha=0.90, ec='black', width=0.85)
plt.errorbar(X, Y4, yerr=error, fmt='none', color='black', capsize=8)
for index, data in enumerate(Y4):
    plt.text(x=index-0.285, y=data+4, s=f"{data}", fontdict=dict(fontsize=9))
plt.tight_layout()

# Define the limits
plt.xlabel('Gold molar fraction', x=0.5, y=0.05, fontsize=12)
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.ylim(0.0, 100)
ax.text(7.1, 82, '(d) D=5.25nm', fontsize=10)  # weight='bold'

# Subplots adjust
plt.subplots_adjust(left=0.10, bottom=0.10, right=0.99, top=0.97, wspace=None, hspace=0.35)
# plt.subplots_adjust(hspace=0.35)
plt.ylabel('Dissolution %', x=0, y=2.5, fontsize=12)

# Intructions for the exit format: png, eps, ps, svg$
plt.savefig('Fig3.tif', bbox_inches='tight', dpi=1200)
plt.show()
