import pandas as pd
import matplotlib.pyplot as plt

fig, ax = plt.subplots(figsize=(6, 4))
# Define the custom x-axis labels
x_labels = ["Pd", "Au$_{20}$Pd$_{80}$", "Au$_{40}$Pd$_{60}$", "Blank"]

# Read and plot each file
df1 = pd.read_csv('data.csv')
plt.scatter(range(len(x_labels)), df1['Pd'], marker="s", label='Pd', color='black')
plt.plot(range(len(x_labels)), df1['Pd'], linestyle='solid', lw=1, color='black')

df2 = pd.read_csv('data.csv')
plt.scatter(range(len(x_labels)), df2['Au'], marker="o", label='Au', color='red')
plt.plot(range(len(x_labels)), df2['Au'], linestyle='solid', lw=1, color='red')

# Set the custom x-axis labels
plt.xticks(range(len(x_labels)), x_labels)

# Customize the plot
plt.xlabel('Samples', fontsize=14)
plt.ylabel('Concentration (ppb)', fontsize=14)
plt.legend()
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)
plt.ylim(-5, 80)

ax.text(0.08, 72, '74', fontsize=12, color='black')  # weight='bold'
ax.text(-0.025, 4.25, '2', fontsize=12, color='red')  # weight='bold'
ax.text(0.97, 4.25, '2', fontsize=12, color='red')  # weight='bold'
ax.text(0.97, 28, '26', fontsize=12, color='black')  # weight='bold'
ax.text(1.975, 7.5, '5', fontsize=12, color='black')  # weight='bold'
ax.text(1.975, -1, '5', fontsize=12, color='red')  # weight='bold'
ax.text(2.975, 6, '4', fontsize=12, color='red')  # weight='bold'
ax.text(3.040, -4, '-3', fontsize=12, color='black')  # weight='bold'


plt.subplots_adjust(left=0.11, bottom=0.15, right=0.99, top=0.96, wspace=None, hspace=None)
# Save the plot
plt.savefig('FigS7.tif', dpi=600)

# Display the plot
plt.show()
