function varargout = treshGui(varargin)
% TRESHGUI M-file for treshGui.fig
%      TRESHGUI, by itself, creates a new TRESHGUI or raises the existing
%      singleton*.
%
%      H = TRESHGUI returns the handle to a new TRESHGUI or the handle to
%      the existing singleton*.
%
%      TRESHGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TRESHGUI.M with the given input arguments.
%
%      TRESHGUI('Property','Value',...) creates a new TRESHGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before treshGui_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to treshGui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help treshGui

% Last Modified by GUIDE v2.5 24-Nov-2011 10:38:47

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @treshGui_OpeningFcn, ...
                   'gui_OutputFcn',  @treshGui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before treshGui is made visible.
function treshGui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to treshGui (see VARARGIN)

% Choose default command line output for treshGui
handles.output = hObject;

hMainGui   = getappdata(0       , 'hMainGui');
filenumber = getappdata(hMainGui, 'filenumber');
x          = getappdata(hMainGui, 'dataAll');
noiseW     = getappdata(hMainGui, 'noiseW');
noise      = str2double(get(handles.editThres, 'string'));

X = x(:,filenumber(1));
Xstd = zeros(length(X),1);
for i = 1:size(X,1)-noiseW
    Xstd(i+(noiseW/2),:) = std(X(i:i+noiseW,:));
end

t = ones(1,length(X))*noise;
plot(1:length(X), Xstd, 1:length(X), X, 1:length(X), t)
axis tight
l = strcat('Thres = ', num2str(noise));
legend('Moving standard deviation','Raw data', l)

axes(handles.axes1)

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes treshGui wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = treshGui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in buttonClose.
function buttonClose_Callback(hObject, eventdata, handles)
% hObject    handle to buttonClose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

close treshGui

function editThres_Callback(hObject, eventdata, handles)
% hObject    handle to editThres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hMainGui   = getappdata(0       , 'hMainGui');
filenumber = getappdata(hMainGui, 'filenumber');
x          = getappdata(hMainGui, 'dataAll');
noiseW     = getappdata(hMainGui, 'noiseW');
noise      = str2double(get(handles.editThres, 'string'));

X = x(:,filenumber(1));
Xstd = zeros(length(X),1);
for i = 1:length(X)-noiseW
    Xstd(i+(noiseW/2),:) = std(X(i:i+noiseW,:));
end

t = ones(1,length(X))*noise;
plot(1:length(X), Xstd, 1:length(X), X, 1:length(X), t)
axis tight
l = strcat('Thres = ', num2str(noise));
legend('Moving standard deviation','Raw data', l)

axes(handles.axes1)
% Hints: get(hObject,'String') returns contents of editThres as text
%        str2double(get(hObject,'String')) returns contents of editThres as a double

% --- Executes during object creation, after setting all properties.
function editThres_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editThres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in tbuttonZoom.
function tbuttonZoom_Callback(hObject, eventdata, handles)
% hObject    handle to tbuttonZoom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val=get(hObject, 'value');
if val==1
    zoom on;
else
    zoom off;
end



