function export
% Subfunction to FastChrom.
% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 1.0
% Lea Gioertz Johnsen
%
% Latest opdate: 16-08-2011
%%
hMainGui = getappdata(0       , 'hMainGui');    H        = getappdata(hMainGui, 'H');
R        = getappdata(hMainGui, 'R');           W        = getappdata(hMainGui, 'W');
name     = getappdata(hMainGui, 'name');        direc    = getappdata(hMainGui, 'excelsave');
SampID   = getappdata(hMainGui, 'SampID');      V1       = getappdata(hMainGui, 'V1');
V2       = getappdata(hMainGui, 'V2');          tresh    = getappdata(hMainGui, 'tresh');
delta    = getappdata(hMainGui, 'd');           excel    = getappdata(hMainGui, 'excel');
phi      = getappdata(hMainGui, 'phi');         a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');           rawDir   = getappdata(hMainGui, 'rawDir');
avgRt    = getappdata(hMainGui, 'avgRt');       KI       = getappdata(hMainGui, 'KI');
avgKI    = getappdata(hMainGui, 'avgKI');       KIonOff  = getappdata(hMainGui, 'KIonOff');
avgW     = getappdata(hMainGui, 'avgW');        avgH     = getappdata(hMainGui, 'avgH');
M        = getappdata(hMainGui, 'M');           scanF    = getappdata(hMainGui, 'scanF');
msStart  = getappdata(hMainGui, 'msStart');     smooth   = getappdata(hMainGui, 'smooth');      
noiseW   = getappdata(hMainGui, 'noiseW');

%% Export to excel

[num, txt, raw] = xlsread(excel);

Series  = cell2mat(raw(3:length(name)+2,5)');

% # series
S       = max(Series)-2;
%Matrix only with columns containing peaks and index (j)
i  = std(H);
j  = find(i~=0);
j2 = find((Series-1)==0); %Control samples
j2 = [j2 find((Series-2)==0)]; % KI samples
% height, rt and width for peaks in control samples:
cH  = H(j2,j);
cR  = R(j2,j);
cW  = W(j2,j);
cM  = M(j2,:); %all scans must be preserved in M
cI  = KI(j2,j);
cID = SampID(1,j2);

for i = 1:S %for each serie
    J     = find((i+2-Series)==0);      % samples from i+1 is identified
    Rr    = [cR; R(J,j)];               % Control samples are included
    Ri    = find(Rr==0);
    Rr    = round((Rr/scanF + msStart)*1000)/1000;    % Retentiontime is rounded
    Rr(Ri)= 0;
    m     = size(Rr,1);
    ID    = [cID'; SampID(1,J)'];
    Ww    = [cW; W(J,j)];               % Control samples are included in width
    Hh    = [cH; H(J,j)];               % Control samples are included in hight
    Hh    = round(Hh);                  % hight is rounded
    Mm    = [cM; M(J,:)];               % control samples are included, but still all scans are preserved 
    D     = zeros(m,3+(length(j)*4-4)); % data to be exportet to excel
    A     = cell(1, 2+(length(j)*4-4)); % mean retentiontime for peak group
    T     = cell(1, 2+(length(j)*4));   % Text for the excel "Import" sheet

    if KIonOff == 1
        Ii    = [cI; KI(J,j)];          % control samples are included in KI index
    end

    for i3=1:length(j);
        T{1,2+(i3*4-4)} = 'Rt [min]';
        T{1,3+(i3*4-4)} = 'Index';
        T{1,4+(i3*4-4)} = 'Height';
        T{1,5+(i3*4-4)} = 'Width';
        A{1,2+(i3*4-4)} = avgRt(i3);
        A{1,4+(i3*4-4)} = avgH(i3);
        A{1,5+(i3*4-4)} = avgW(i3);
        
        if KIonOff == 1
            A{1,3+(i3*4-4)}            = avgKI(i3);
            D(:,1+(i3*4-4):4+(i3*4-4)) = [Rr(:,i3) Ii(:,i3) Hh(:,i3) Ww(:,i3)];
        else
            D(:,1+(i3*4-4):4+(i3*4-4)) = [Rr(:,i3) zeros(m,1) Hh(:,i3) Ww(:,i3)];
        end
        
    end

    E   = txt{4+i,2};
    e   = '.xls';
    exp = strcat(direc,'\', E, e);
    N   = name([j2 J],1);
    l   = ceil(length(D)/240);

    % export of data
    for ii = 1:l
        I  = ['Import' int2str(ii)];
        i1 = ii*60*4-60*4+1;
        if ii <= l-1
            i2 = ii*60*4;
        else
            i2 = length(A);
        end

        xlswrite(exp, N           , I  , 'A3'); % name of gc-file
        xlswrite(exp, ID          , I  , 'B3'); % sample names
        xlswrite(exp, D(:,i1:i2-1), I  , 'C3'); % data
        xlswrite(exp, A(:,i1+1:i2), I  , 'C2'); % mean retentiontime for peaks
        xlswrite(exp, T(:,i1+1:i2), I  , 'C1');
    end

    % export of settings
    excel = cellstr(excel);
    rawDir= cellstr(rawDir);
    t     = cellstr('Tresh: Treshold for the moving std avg. values below this is regarded as noise and baseline');
    v1    = cellstr('V1: Minimum peak width');
    v2    = cellstr('V2: Maximum peak width');
    d     = cellstr('delta: Maximal peak shift');
    p     = cellstr('Minimum peak hight');
    A1    = cellstr('Initial rt');
    a     = a/scanF + msStart;
    b     = b/scanF + msStart;
    B     = cellstr('Final rt');
    e     = cellstr('Layout xls flie');
    r     = cellstr('Raw data');
    s     = cellstr('ms Start time');
    f     = cellstr('Scan frequency in min.');
    w1    = cellstr('Width of window for determination of moving deviation');
    sm    = cellstr('Width of smoothing window (1: No smoothing)');

    xlswrite(exp, tresh  , 'Settings', 'B1') ; xlswrite(exp, t , 'Settings', 'A1');
    xlswrite(exp, V1     , 'Settings', 'B2') ; xlswrite(exp, v1, 'Settings', 'A2');
    xlswrite(exp, V2     , 'Settings', 'B3') ; xlswrite(exp, v2, 'Settings', 'A3');
    xlswrite(exp, delta  , 'Settings', 'B4') ; xlswrite(exp, d , 'Settings', 'A4');
    xlswrite(exp, phi    , 'Settings', 'B5') ; xlswrite(exp, p , 'Settings', 'A5');
    xlswrite(exp, a      , 'Settings', 'B6') ; xlswrite(exp, A1, 'Settings', 'A6');
    xlswrite(exp, b      , 'Settings', 'B7') ; xlswrite(exp, B , 'Settings', 'A7');
    xlswrite(exp, excel  , 'Settings', 'B8') ; xlswrite(exp, e , 'Settings', 'A8');
    xlswrite(exp, rawDir , 'Settings', 'B9') ; xlswrite(exp, r , 'Settings', 'A9');
    xlswrite(exp, msStart, 'Settings', 'B10'); xlswrite(exp, s , 'Settings', 'A10');
    xlswrite(exp, scanF  , 'Settings', 'B11'); xlswrite(exp, f , 'Settings', 'A11');
    xlswrite(exp, smooth , 'Settings', 'B12'); xlswrite(exp, sm, 'Settings', 'A12');
    xlswrite(exp, noiseW , 'Settings', 'B13'); xlswrite(exp, w1, 'Settings', 'A13'); 
    
    % export of peak index
    [m,n] = size(Mm);
    scans = 1:n;
    scans = scans';
    Msum  = sum(Mm);
    if length(N)>240
        N = N{1:240};
        Mm = Mm(1:240,:);
    end
    
    xlswrite(exp, N'                  , 'Peaks', 'D1');
    xlswrite(exp, scans               , 'Peaks', 'A2');
    xlswrite(exp, scans/scanF+msStart , 'Peaks', 'B2');
    xlswrite(exp, Msum'               , 'Peaks', 'C2');
    xlswrite(exp, Mm'                 , 'Peaks', 'D2');
end