function XLS_MAT
% subfunction used if the raw data is in .mat format
% Gui for treating GC-FID and TIC chromatograms
%
% FastChrom version 2.008
% Lea Girtz Johnsen
%
% Latest update: 6-10-2011
%%
hMainGui = getappdata(0       , 'hMainGui');
x        = getappdata(hMainGui, 'x');
a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');
mode     = getappdata(hMainGui, 'mode');
%%

if mode == 0
    KIsamp = getappdata(hMainGui, 'KIsamp');
end

rtMax   = x(end, 1);
msStart = x(1, 1);
scanF   = size(x,1)/(rtMax-msStart);

if a <= msStart
    a = 1;
    b = round(scanF*(b-msStart));
else
    a = round(scanF*(a-msStart));
    b = round(scanF*(b-msStart));
end

if b > size(x, 1)
    b = size(x, 1);
end

dataAll = x(:,2:end);
for i = 1:size(dataAll,2)
    name{i,1} = num2str(i);
end

if mode == 0 
    for i = 1:length(KIsamp)
        KIname{i,1} = name{KIsamp(i)};
    end
    setappdata(hMainGui, 'KIdata' , dataAll(a:b,KIsamp));
    setappdata(hMainGui, 'KIname' , KIname);
    setappdata(hMainGui, 'scanF'  , scanF);
    setappdata(hMainGui, 'msStart', msStart);
    setappdata(hMainGui, 'a'      , a);
    setappdata(hMainGui, 'b'      , b);
    setappdata(hMainGui, 'name'   , name);
else
    hMax = max(dataAll);

    setappdata(hMainGui, 'hMax'   , hMax);
    setappdata(hMainGui, 'data'   , dataAll(a:b,:));
    setappdata(hMainGui, 'dataAll', dataAll);
    setappdata(hMainGui, 'name'   , name);
    setappdata(hMainGui, 'scanF'  , scanF);
    setappdata(hMainGui, 'msStart', msStart);
    setappdata(hMainGui, 'a'      , a);
    setappdata(hMainGui, 'b'      , b);
end