% Subfunction to FastChrom. 
% 
% Version 1.0
% 
% Lea Gioertz Johnsen
% 
% Latest opdate: 03-08-2011

function varargout = VOCki(varargin)
% VOCKI M-file for VOCki.fig
%      VOCKI, by itself, creates a new VOCKI or raises the existing
%      singleton*.
%
%      H = VOCKI returns the handle to a new VOCKI or the handle to
%      the existing singleton*.
%
%      VOCKI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VOCKI.M with the given input arguments.
%
%      VOCKI('Property','Value',...) creates a new VOCKI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before VOCki_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to VOCki_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help VOCki

% Last Modified by GUIDE v2.5 27-May-2011 07:42:57

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @VOCki_OpeningFcn, ...
                   'gui_OutputFcn',  @VOCki_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before VOCki is made visible.
function VOCki_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to VOCki (see VARARGIN)

% Choose default command line output for VOCki
handles.output = hObject;

hMainGui    = getappdata(0       , 'hMainGui');
KIdata      = getappdata(hMainGui, 'KIdata');
KIrt        = getappdata(hMainGui, 'KIrt');
KIindex     = getappdata(hMainGui, 'KIindex');
KIcompounds = getappdata(hMainGui, 'KIcompounds');
KIname      = getappdata(hMainGui, 'KIname');
scanF       = getappdata(hMainGui, 'scanF');
msStart     = getappdata(hMainGui, 'msStart');
filetype    = getappdata(hMainGui, 'filetype');

name{1,1} = 'KI';
for i = 2:length(KIname)+1
    name{i,1} = KIname{i-1};
end

u = [0 ones(1, length(KIname))];
d = [KIindex KIrt; u];

KIcompounds{length(KIcompounds)+1,1} = 'Use';

set(handles.table, 'ColumnName' , name);
set(handles.table, 'RowName', KIcompounds);
set(handles.table, 'data'   , d);

rt = 1:length(KIdata);
if filetype == 1
    rt = rt/scanF;
else
    rt = rt/scanF + msStart;
end

axes(handles.axes1);
plot(rt, KIdata);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes VOCki wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = VOCki_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in buttonOK.
function buttonOK_Callback(hObject, eventdata, handles)
% hObject    handle to buttonOK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

data  = get(handles.table, 'data');
[m,n] = size(data);
I     = find(data(m,:));
if length(I) > 1
    KIrt2 = missmean(data(1:m-1,I)');
else
    KIrt2 = data(1:m-1,I)';
end

i=isnan(KIrt2);
KIrt2(i)=[];

hMainGui = getappdata(0, 'hMainGui');
setappdata(hMainGui, 'KIrt2'  , KIrt2);
setappdata(hMainGui, 'KIindex', data(1:m-1,1));

close VOCki

% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val=get(hObject, 'value');
if val==1
    zoom on;
else
    zoom off;
end
% Hint: get(hObject,'Value') returns toggle state of pushbutton4


