function NoiseRemoval
% Subfunction used for removal of noise and baseline
% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 2.007
% Lea Gioertz Johnsen
%
% Latest update: 16-08-2011
%%
hMainGui = getappdata(0       , 'hMainGui');
tres     = getappdata(hMainGui, 'tresh');
mode     = getappdata(hMainGui, 'mode');
moo      = getappdata(hMainGui, 'noiseW');
v        = getappdata(hMainGui, 'smooth');
%% Baseline + noise are removed

if mode == 0
    data = getappdata(hMainGui, 'KIdata');
else
    data = getappdata(hMainGui, 'data');
end

%Smoothing (moving average)
[m1,n1] = size(data);
a1      = 1:m1;
Sx      = zeros(m1,n1);
iv      = round(v/2);

for i = v:m1-iv+1
    Sx(i-iv+1, :) = mean(data(a1(i-v+1):a1(i), :));
end

data_baselined = zeros(n1,m1);
Base           = zeros(n1,m1);
for I = 1:n1 %from sample 1 to n1
    sx   = Sx(:,I);
    x    = data(:,I);
    l    = length(x);
    j    = l-moo;
    Mstd = zeros(1,m1);

    for i=1:j;
        Mstd(1,i)=std(sx(i:i+moo-1));
    end;

    %Noiese is separated from peaks by making a matrix only containing noise:
    noise = x(1:m1,1);
    for i=6:m1
        if Mstd(1,i)<tres && Mstd(1,i-5)<tres && x(i)<50000000
            noise(i) = x(i);
        else
            noise(i) = NaN;
        end;
    end;

    base = x';
    %The baseline is estimated as straight line from start to stop of intervals:
    x_baselined = zeros(1,m1);
    N = isnan(noise);
    c = 0;
    for i = 2:length(N);
        if N(i-1) == 0 && N(i) == 1 && c <= i
            start = i;
            stop  = find(N(i:end)-1, 1, 'first')+i-2;
            c     = stop + 1;

            slope                   = (x(stop+1)-x(start-1)) / (stop - start+1);
            base(start:stop)        = x(start) + (1:(stop-start+1))*slope;
            x_baselined(start:stop) = (x(start:stop)'-base(start:stop));

            [x_baselined, base, S1]       = Baseline(x_baselined, start, stop, x, I, base);
            if S1 ~= 0
                [x_baselined, base, S2]       = Baseline(x_baselined, start, S1, x, I, base);
                [x_baselined, base, S3]       = Baseline(x_baselined, S1, stop, x, I, base);
                if S2 ~= 0 && S3 ~= 0
                    [x_baselined, base, S]        = Baseline(x_baselined, start, S2, x, I, base);
                    [x_baselined, base, S]        = Baseline(x_baselined, S2, S1, x, I, base);
                    [x_baselined, base, S]        = Baseline(x_baselined, S1, S3, x, I, base);
                    [x_baselined, base, S]        = Baseline(x_baselined, S3, stop, x, I, base);
                elseif S2 ~= 0
                    [x_baselined, base, S]        = Baseline(x_baselined, start, S2, x, I, base);
                    [x_baselined, base, S]        = Baseline(x_baselined, S2, S1, x, I, base);
                elseif S3 ~= 0
                    [x_baselined, base, S]        = Baseline(x_baselined, S1, S3, x, I, base);
                    [x_baselined, base, S]        = Baseline(x_baselined, S3, stop, x, I, base);
                end
            end

        elseif c < i
            base(i) = noise(i);
            x_baselined(i) = (x(i)-base(i));
        end

    end




    %baseline and noise are removed from raw data
    Base(I,:) = base;
    for i = 1:m1;
        if x_baselined(i)<0
            x_baselined(i) = 0;
        end
    end

    data_baselined(I,:) = x_baselined;
end

setappdata(hMainGui, 'data_baselined', data_baselined);
setappdata(hMainGui, 'Base'          , Base);

