function importRAX
% Subfunction used for import of RAX files
% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 2.007
% Lea Gioertz Johnsen
%
% Baseline optimated
%
% Latest opdate: 16-08-2011
%%
hMainGui = getappdata(0       , 'hMainGui');
files    = getappdata(hMainGui, 'files');
a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');
mode     = getappdata(hMainGui, 'mode');
direc    = getappdata(hMainGui, 'direc');

if mode == 0
    KIsamp = getappdata(hMainGui, 'KIsamp');
end

cd(direc)

x    = zeros((b-a+1),length(files));
name = cell(length(files),1);
for i=1:length(files);
    name{i,1} = files(i).name;
    filename  = files(i).name;
    RAX       = importdata(filename, ',', 48);
    data      = RAX.data(:,1);
    [n,m]     = size(data);
    [nn,mm]   = size(x);

    if nn<n
        xtemp = zeros((n-nn),mm);
        x     = vertcat(x, xtemp);
    elseif nn>n
        xtemp = zeros(nn-n,m);
        data  = vertcat(data, xtemp);
    end

    x(:,i) = data;
end

if b > size(x, 1)
    b = size(x, 1);
end
setappdata(hMainGui, 'b'        , b);

    if mode ==0 
        setappdata(hMainGui, 'KIdata'   , x(a:b,KIsamp));
        setappdata(hMainGui, 'KIname'   , name(KIsamp,:));
        setappdata(hMainGui, 'msStart'  , 0);
        setappdata(hMainGui, 'name'   , name);
    else
        hMax = max(x);

        setappdata(hMainGui, 'hMax'   , hMax);
        setappdata(hMainGui, 'dataAll', x);
        setappdata(hMainGui, 'data'   , x(a:b,:));
        setappdata(hMainGui, 'name'   , name);
        setappdata(hMainGui, 'msStart'  , 0);
    end
end

