function importCDF
% Subfunction used for import of cdf files
% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 1.0
% Lea Gioertz Johnsen
%
% Latest opdate: 16-08-2011
%%
hMainGui = getappdata(0       , 'hMainGui');
files    = getappdata(hMainGui, 'files');
a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');
mode     = getappdata(hMainGui, 'mode');
direc    = getappdata(hMainGui, 'direc');
%% Data is imported

if mode == 0
    KIsamp = getappdata(hMainGui, 'KIsamp');
end

cd(direc)

x    = zeros(1,length(files));
name = cell(length(files),1);
for i=1:length(files);
    name{i,1} = files(i).name;
    filename  = files(i).name;
    [matrix,TIC, axis_min] = iCDF_load(filename);
    [n,m]     = size(TIC);
    [nn,mm]   = size(x);

    if nn<n
        xtemp = zeros((n-nn),mm);
        x     = vertcat(x, xtemp);
    elseif nn>n
        xtemp = zeros(nn-n,m);
        TIC   = vertcat(TIC, xtemp);
    end
    
    x(:,i) = TIC;
end

rtMax   = max(axis_min);
msStart = min(axis_min);
scanF   = size(TIC,1)/(rtMax - msStart);

if  a <= msStart
    a = 1;
    b = round(scanF*(b-msStart));
else
    a = round(scanF*(a-msStart));
    b = round(scanF*(b-msStart));
end

if b > size(x, 1)
    b = size(x, 1);
end

if mode ==0
    setappdata(hMainGui, 'KIdata' , x(a:b,KIsamp));
    setappdata(hMainGui, 'KIname' , name(KIsamp,:));
    setappdata(hMainGui, 'scanF'  , scanF);
    setappdata(hMainGui, 'msStart', msStart);
    setappdata(hMainGui, 'a'      , a);
    setappdata(hMainGui, 'b'      , b);
    setappdata(hMainGui, 'name'   , name);
else
    hMax = max(x);

    setappdata(hMainGui, 'hMax'   , hMax);
    setappdata(hMainGui, 'dataAll', x);
    setappdata(hMainGui, 'data'   , x(a:b,:));
    setappdata(hMainGui, 'name'   , name);
    setappdata(hMainGui, 'scanF'  , scanF);
    setappdata(hMainGui, 'msStart', msStart);
    setappdata(hMainGui, 'a'      , a);
    setappdata(hMainGui, 'b'      , b);
end
end

