
function identification
% Function used by FastChrom to identified peaks and group them accros
% samples.
% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 1.0
% Lea Gioertz Johnsen
%
% Latest opdate: 16-08-2011

%%
hMainGui       = getappdata(0       , 'hMainGui');
data_baselined = getappdata(hMainGui, 'data_baselined');
V1             = getappdata(hMainGui, 'V1');
V2             = getappdata(hMainGui, 'V2');
delta          = getappdata(hMainGui, 'd');
phi            = getappdata(hMainGui, 'phi');
a              = getappdata(hMainGui, 'a');
b              = getappdata(hMainGui, 'b');
SampID         = getappdata(hMainGui, 'SampID');
Series         = getappdata(hMainGui, 'Series');
classes        = getappdata(hMainGui, 'classes');
raw            = getappdata(hMainGui, 'raw');
KIonOff        = getappdata(hMainGui, 'KIonOff');
scanF          = getappdata(hMainGui, 'scanF');
msStart        = getappdata(hMainGui, 'msStart');
v              = getappdata(hMainGui, 'smooth');
%%
if KIonOff == 1
    KIrt2   = getappdata(hMainGui, 'KIrt2');
    KIindex = getappdata(hMainGui, 'KIindex');
end

%% Peaks are identified
%out: TotalPeaks: start, maks, slut, hjde, bredde

data    = data_baselined;
[n, m]  = size(data);
I       = isnan(data);
data(I) = 0;
a1      = 1:m;
sx      = zeros(n,m);
iv      = round(v/2);
for i = v:m-iv+1
    sx(:,i-iv+1) = mean(data(:,a1(i-v+1):a1(i)), 2);
end

for ii = 1:n%for each sample
    d      = diff(sx(ii,:),1,2);
    [n0,m] = size(d);
    Peaks  = [];

    S = []; M = [];
    % Determination of peak start (S), max (M) and end slut (S)
    for i2 = 3:m % from the first to the last scan
        if d(1,i2-1)<=0 && d(1,i2)>0 || d(1,i2-1)<0 && d(1,i2)>=0
            S = [S i2];
        end;
        if d(1,i2-2)>0 && d(1,i2-1)>=0 && d(1,i2)<=0 && d(1,i2+1)<0
            M = [M i2];
        end;
    end;
    l = length(M);
    %Test of if the identified start/end/max is fullfilling the
    %requirements
    for i2 = 1:l;
        [j,J] = min(abs(S-M(1,i2)));
        %start must be located before max
        x2 = 0;

        if M(1,i2)>S(J)&& J<length(S)
            x1 = S(J);
            x2 = M(1,i2);
            x3 = S(J+1);
        elseif J>1 && M(1,i2)<S(J)
            x1 = S(J-1);
            x2 = M(1,i2);
            x3 = S(J);
        end

        if x2 == 0
            continue
        end

        %peakheight at start(y1), max(y2) and end(y3)
        y2 = data(ii,x2);
        %peak width in half height
        [C1,I1] = min(abs(data(ii,x1:x2)-(y2*0.5)));%The closest point left of apex.
        [C2,I2] = min(abs(data(ii,x2:x3)-(y2*0.5)));%The closest point right of apex.
        w = (x2+I2)-(x1+I1);
        P = [];

        if w>V1 && w<V2 && y2>phi
            p = [x1; x2; x3];%start peak end
            A = mean(sx(ii,x1:x3));
            c = 0;

            for i4 = x1:x3 %The signal must only cross average twice
                if sx(ii,i4)<A && sx(ii,i4+1)>A || sx(ii,i4)>A && sx(ii,i4+1)<A
                    c = c+1;
                end
            end

            if c<=4
                P = [p'+a y2 w];
            end

        end

        if isempty(P)==0
            Peaks = [Peaks; P];
        end

    end

    %If no peaks are detected
    if isempty(Peaks)==1
        Peaks(1,5) = 0;
    end;
    TotalPeaks{ii,1} = Peaks;% peaks consiste of start, apex, end, height, width
end

%% Peaks are grouped
l         = length(TotalPeaks);
hights    = zeros(l,b);
Width     = zeros(l,b);
retention = zeros(l,b);
for i1 = 1:l
    peaks  = TotalPeaks{i1,1};
    n = size(peaks, 1);
    i2     = 1:n;
    s      = peaks(i2,2);%scan no. for apex
    if s(1,1) > 0
        hights(i1,s)    = peaks(i2,4);
        Width(i1,s)     = peaks(i2,5);
        retention(i1,s) = peaks(i2,2);
    end
end

I     = find(hights);
[m,n] = size(hights);
M     = zeros(m,n);
M(I)  = 1;
Msum  = sum(M);     % Index of how many apeks found in each scan no.
I     = find(Msum); % Index of in which scans peaks are found
c     = 0;
H     = zeros(l,b); % Heights
R     = zeros(l,b); % Retention time
W     = zeros(l,b); % Width
KI    = zeros(l,b);

save Msum Msum M

for i = I
    if c < i && i < b-delta-1
        [C, I1] = max(Msum(i:i+delta-1));

        % If there maximum is one peak pr scan in the window:
        if C == 2
            Mavg = zeros(delta,1);
            cc = 1;
            for iii=i+2:i+delta
                Mavg(cc,1) = mean(Msum(1,iii-2:iii+1));
                cc         = cc+1;
            end
            [C, I1] = max(Mavg);
            I1      = I1+i-1;
        else
            I1 = I1+i-1;
        end

        % if the first peaks is to far away from the main group a seperate
        % group is made with a smaller window
        if I1 > i + delta * 0.5
            [H1, I2] = max(hights(:,i:I1-0.5*delta-1),[],2);
            I2       = I2 + i-1;
            H(:,i)  = H1;
            %conversion to linear indexing
            in = 1:l;
            LinIn = (I2-1) * l + in';
            % The width of the peak is stored
            W(:,i)  = Width(LinIn);
            % The original retetiontime for each peak is stored
            R(:,i) = retention(LinIn);

            %c is updatet
            c = I1-0.5*delta-1;
            KIi = i;
            
        else % if there only is one peak group inside the window
            
            if (I1+0.5*delta) > b
                [H1, I2] = max(hights(:,c+1:b),[],2);
            else
                [H1, I2] = max(hights(:,c+1:I1+0.5*delta),[],2);
            end
            
            I2       = I2 + c;
            H(:,I1)  = H1;
            %conversion to linear indexing
            in      = 1:l;
            LinIn   = (I2-1) * l + in';
            % The width of the peak is stored
            W(:,I1) = Width(LinIn);
            % The original retetiontime for each peak is stored
            R(:,I1) = retention(LinIn);
            % c is updated
            c       = I1+delta*0.5;
            KIi = I1;
            
        end
        
        % Conversion to KI
        if KIonOff == 1
            L      = length(KIrt2);
            alfaI  = KIindex(2:L) - KIindex(1:L-1);
            alfaR  = KIrt2(2:L) - KIrt2(1:L-1);
            KIalfa = zeros(L-1,1);

            for ii = 1:L-1
                KIalfa(ii,1) = alfaI(ii)/alfaR(ii);
            end

            KIrt3        = KIrt2;
            KIrt3(1,1)   = 0;
            KIrt3(1,L) = inf;
            for i2 = 1:l
                if R(i2,KIi) ~= 0
                    for ii = 1:L-1
                        if R(i2,KIi)/scanF + msStart >= KIrt3(ii) && R(i2,KIi)/scanF + msStart < KIrt3(ii+1)
                            KI(i2,KIi) = round((KIalfa(ii) * (R(i2,KIi)/scanF + msStart - KIrt2(ii)) + KIindex(ii)) * 10)/10;
                        end
                    end
                end
            end

        end
    end
end

% number of series:
S  = max(Series)-2;
n2 = size(classes, 1);
%Matrix with peaks and index (j)
i       = std(H);
j       = find(i~=0);
Rr      = R(:,j);
Kr      = KI(:,j);
Wr      = W(:,j);
Hr      = H(:,j);

%calculation of the average rt, Ki, widt and height
avgRt = zeros(length(j),1); avgW = zeros(length(j),1);
avgKI = zeros(length(j),1); avgH = zeros(length(j),1);
for i = 1:length(j)
    [C,I]      = find(Rr(:,i)~=0);
    Rt         = Rr(C,i);
    Ki         = Kr(C,i);
    Ww         = Wr(C,i);
    Hh         = Hr(C,i);
    avgRt(i,1) = (round((mean(Rt/scanF) + msStart)*1000))/1000;
    avgKI(i,1) = (round(mean(Ki)*10)/10);
    avgW(i,1)  = mean(Ww);
    avgH(i,1)  = round(mean(Hh));
end

%% Dataset for PCA
j2 = find((Series-1)==0);
%height, rt and width in control samples:
control = H(j2,j);
for i = 1:S %for each serie
    J     = find((i+2-Series)==0); %samples from serie i+1 is identified
    ID    = [SampID(:,j2) SampID(:,J)];
    x     = dataset([control; H(J,j)]);

    x.axisscale{2,2}     = j;
    x.axisscalename{2,2} = 'Scan #';
    x.axisscale{2,1}     = avgRt';
    x.axisscalename{2,1} = 'RT [min]';
    x.axisscale{2,3}     = avgKI';
    x.axisscalename{2,3} = 'KI';
    x.label{2,2}         = num2str(avgKI);
    x.label{2,1}         = num2str(avgRt);
    x.label{1,1}         = (ID');

    for i2=1:n2
        Cl=[];
        for i3 = 1:m
            Cl(i3) = char(classes{i2,i3});
        end
        if i2 == 1
            ki = find(Cl==2);
            Cl(ki) = [];
        else
            Cl(ki) = [];
        end
        x.class{1,i2}     = Cl;
        x.classname{1,i2} = raw(2,4+i2);
    end

    evalc(['pcaDATA.serie' num2str(i+2) '=x;']);
end

%% storage of variables in hMainGui handle
setappdata(hMainGui, 'H'      , H);
setappdata(hMainGui, 'R'      , R);
setappdata(hMainGui, 'W'      , W);
setappdata(hMainGui, 'series' , 3:(S+2));
setappdata(hMainGui, 'j'      , j);
setappdata(hMainGui, 'pcaDATA', pcaDATA);
setappdata(hMainGui, 'avgRt'  , avgRt);
setappdata(hMainGui, 'avgKI'  , avgKI);
setappdata(hMainGui, 'avgH'   , avgH);
setappdata(hMainGui, 'avgW'   , avgW);
setappdata(hMainGui, 'KI'     , KI);
setappdata(hMainGui, 'M'      , M);