% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 1.0
% Lea Gioertz Johnsen
%
% Latest update: 16-08-2011

function varargout = VOCgui(varargin)
%VOCGUI M-file for VOCgui.fig
%      VOCGUI, by itself, creates a new VOCGUI or raises the existing
%      singleton*.
%
%      H = VOCGUI returns the handle to a new VOCGUI or the handle to
%      the existing singleton*.
%
%      VOCGUI('Property','Value',...) creates a new VOCGUI using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to VOCgui_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      VOCGUI('CALLBACK') and VOCGUI('CALLBACK',hObject,...) call the
%      local function named CALLBACK in VOCGUI.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help VOCgui

% Last Modified by GUIDE v2.5 09-May-2022 18:13:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @VOCgui_OpeningFcn, ...
    'gui_OutputFcn',  @VOCgui_OutputFcn, ...
    'gui_LayoutFcn',  [], ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before VOCgui is made visible.
function VOCgui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for VOCgui
handles.output = hObject;

% UIWAIT makes VOCgui wait for user response (see UIRESUME)
% uiwait(handles.figure1);
setappdata(0, 'hMainGui', gcf);

% Update handles structure
guidata(hObject, handles);


% --- Outputs from this function are returned to the command line.
function varargout = VOCgui_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in listboxSamples.
function listboxSamples_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0       , 'hMainGui');
dataAll  = getappdata(hMainGui, 'dataAll');
j        = getappdata(hMainGui, 'j');
hMax     = getappdata(hMainGui, 'hMax');
Base     = getappdata(hMainGui, 'Base');
H        = getappdata(hMainGui, 'H');
a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');
rt       = getappdata(hMainGui, 'avgRt');
scanF    = getappdata(hMainGui, 'scanF');
msStart  = getappdata(hMainGui, 'msStart');

H = H(:,j);

i2      =      get(hObject            , 'value');
name    =      get(hObject            , 'string');
i1      =      get(handles.listboxComp, 'value');
d       = eval(get(handles.edit4      , 'string'));
I       =      get(handles.tbuttonBase, 'value');
legendC =      get(handles.listboxComp, 'string');

axes(handles.axesComp)
plot(H(:,i1), '-o');
legend(legendC(i1,:))
hold on
plot(i2, H(i2,i1), 'line', 'none', 'marker', 'x', 'color', 'r', 'markersize', 14 )
hold off

m = size(dataAll, 1);

axes(handles.axesCrom)
cla
plot((1:m)/scanF + msStart, dataAll(:,i2));
legend(name(i2,:))
for i=1:length(i1)
    rectangle('Position',[rt(i1(i),1)-(0.5*d/scanF),0,d/scanF,max(hMax(:,i2))])
end
hold on

if I == 0
    hold off
else
    plot((a:b)/scanF + msStart, Base(i2,:)', 'color', [0.5 0.5 0.5])
    hold off
end

% --- Executes during object creation, after setting all properties.
function listboxSamples_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in listboxComp.
function listboxComp_Callback(hObject, eventdata, handles)
i1      = get(hObject, 'value');
legendC = get(hObject, 'string');
d       = eval(get(handles.edit4, 'string'));
i2      = get(handles.listboxSamples, 'value');
name    = get(handles.listboxSamples, 'string');
I       = get(handles.tbuttonBase, 'value');

hMainGui = getappdata(0       , 'hMainGui');
H        = getappdata(hMainGui, 'H');
j        = getappdata(hMainGui, 'j');
hMax     = getappdata(hMainGui, 'hMax');
dataAll  = getappdata(hMainGui, 'dataAll');
Base     = getappdata(hMainGui, 'Base');
a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');
rt       = getappdata(hMainGui, 'avgRt');
scanF    = getappdata(hMainGui, 'scanF');
msStart  = getappdata(hMainGui, 'msStart');

H   = H(:,j);

axes(handles.axesComp)
plot(H(:,i1), '-o');
legend(legendC(i1,:))
hold on
plot(i2, H(i2,i1), 'line', 'none', 'marker', 'x', 'color', 'r', 'markersize', 14 )
hold off

[m,n] = size(dataAll);

axes(handles.axesCrom)
cla
plot((1:m)/scanF + msStart, dataAll(:,i2));
legend(name(i2,:))
for i=1:length(i1)
    rectangle('Position',[rt(i1(i),1)-(0.5*d/scanF),0,d/scanF,max(hMax(:,i2))])
end
hold on

if I == 0
    hold off
else
    plot((a:b)/scanF + msStart, Base(i2,:)', 'color', [0.5 0.5 0.5])
    hold off
end

% --- Executes during object creation, after setting all properties.
function listboxComp_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in tbuttonZoom.
function tbuttonZoom_Callback(hObject, eventdata, handles)
val=get(hObject, 'value');
if val==1
    zoom on;
else
    zoom off;
end

function edit2_Callback(hObject, eventdata, handles)
value = eval(get(hObject, 'string'));

if value ~= round(value) || value < 0
    set(hObject, 'string', 7);
    warndlg('V1 must be a positive integer', 'Warning', 'modal');
end

% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit3_Callback(hObject, eventdata, handles)
value = eval(get(hObject, 'string'));

if value ~= round(value) || value < 0
    set(hObject, 'string', 25);
    warndlg('V2 must be a positive integer', 'Warning', 'modal');
end

% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit4_Callback(hObject, eventdata, handles)
value = eval(get(hObject, 'string'));

if value ~= round(value) || value < 0 || value/2 ~= round(value/2)
    set(hObject, 'string', 16);
    warndlg('The shift must be a positive, even integer', 'Warning', 'modal');
end

% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function editXls_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function editXls_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in buttonPath2.
function buttonPath2_Callback(hObject, eventdata, handles)
dir = uigetdir;
set(handles.textPath2, 'string', dir)
guidata(hObject, handles);

% --- Executes on button press in ButtonCalc.
function ButtonCalc_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0    , 'hMainGui');
files    = getappdata(hMainGui, 'files');
filetype = getappdata(hMainGui, 'filetype');

tresh  = eval(get(handles.edit1    , 'string'));
V1     = eval(get(handles.edit2    , 'string'));
V2     = eval(get(handles.edit3    , 'string'));
d      = eval(get(handles.edit4    , 'string'));
a      = eval(get(handles.edit5    , 'string'));
b      = eval(get(handles.edit6    , 'string'));
phi    = eval(get(handles.edit7    , 'string'));
noiseW = eval(get(handles.edit31   , 'string'));
scanF  = eval(get(handles.edit32   , 'string'));
smooth = eval(get(handles.edit33   , 'string'));
excel  =      get(handles.textFile , 'string');
direc  =      get(handles.textPath2, 'string');
direc2 =      get(handles.textPath , 'string');
%% Initial chek
if isempty(excel)==1
    warndlg('Please load the excel file with the experimental layout', 'Warning', 'modal');
    return
end

if get(handles.RTindex, 'value') == 1
    KIrt2   = getappdata(hMainGui, 'KIrt2');
    if isempty(KIrt2) == 1
        warndlg('Please calculate the index first', 'Warning', 'modal');
        return
    end
end

[num, txt, raw] = xlsread(excel);
S               = (raw(3:end,4))';
I = 1;
for i = 1:length(S)
    if isnan(S{i})~=1
        SampID{I}=S{i};
        I=I+1;
    end
end

if length(SampID)~=length(files)
    warndlg('The number of files in the chosen directory does not match the layout in the xls file', 'Warning', 'modal');
    return
end

Series          = cell2mat(raw(3:length(files)+2,5)');

classes         = raw(3:length(files)+2,5:end)';

%%
setappdata(hMainGui, 'tresh'    , tresh);
setappdata(hMainGui, 'rawDir'   , direc2);
setappdata(hMainGui, 'V1'       , V1);
setappdata(hMainGui, 'V2'       , V2);
setappdata(hMainGui, 'excel'    , excel);
setappdata(hMainGui, 'd'        , d);
setappdata(hMainGui, 'excelsave', direc);
setappdata(hMainGui, 'phi'      , phi);
setappdata(hMainGui, 'SampID'   , SampID);
setappdata(hMainGui, 'Series'   , Series);
setappdata(hMainGui, 'classes'  , classes);
setappdata(hMainGui, 'raw'      , raw);
setappdata(hMainGui, 'mode'     , 1);
setappdata(hMainGui, 'noiseW'   , noiseW);
setappdata(hMainGui, 'scanF'    , scanF);
setappdata(hMainGui, 'smooth'   , smooth);
%%
h = waitbar(0, 'Please wait, calculation in progress');

if filetype == 1
    if a == 0 && filetype ==1
        a = 1;
        b = round(scanF*b);

    else
        a = round(scanF*a);
        b = round(scanF*b);
    end
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    importRAX
    
elseif filetype == 2
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    importCDF

    scanF = getappdata(hMainGui, 'scanF');
    set(handles.edit32, 'string', scanF)
    guidata(hObject, handles);
elseif filetype == 3
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    XLS_MAT
    
    scanF = getappdata(hMainGui, 'scanF');
    set(handles.edit32, 'string', scanF)
    guidata(hObject, handles);
else
    if a == 0
        a = 1;
        b = round(scanF*b);

    else
        a = round(scanF*a);
        b = round(scanF*b);
    end
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    importXLS
end

NoiseRemoval
identification

hMainGui = getappdata(0       , 'hMainGui');
dataAll  = getappdata(hMainGui, 'dataAll');
name     = getappdata(hMainGui, 'name');
H        = getappdata(hMainGui, 'H');
j        = getappdata(hMainGui, 'j');
series   = getappdata(hMainGui, 'series');
avgRt    = getappdata(hMainGui, 'avgRt');
avgKI    = getappdata(hMainGui, 'avgKI');
scanF    = getappdata(hMainGui, 'scanF');
msStart  = getappdata(hMainGui, 'msStart');

axes(handles.axesCrom)
m  = size(dataAll, 1);
rt = 1:m;
RT = rt/scanF + msStart;
plot(RT, dataAll(:,1));
legend(name(1,:))

set(handles.listboxSamples, 'string', name, 'value', 1)
Rt = str2cell(num2str(avgRt));
H  = H(:,j);
axes(handles.axesComp)
plot(H(:,1)', '-o')
hold on
plot(H(1,1)', 'marker', 'x', 'color', 'r', 'markersize', 14 )
hold off
legend(Rt{1,:})

A= num2str(avgRt);
l=size(A,1);
% listboxComp should show both rt and index. A string is created which
% contains both
for i=1:l
    t(i,:) = '   /   ';
end
B=num2str(avgKI);
s = (strcat(A, t, B));

set(handles.listboxComp, 'string', s , 'value', 1)
set(handles.popupSeries, 'string', series, 'value', 1);

close(h);

guidata(hObject, handles);


% --- Executes on key press with focus on ButtonCalc and none of its controls.
function ButtonCalc_KeyPressFcn(hObject, eventdata, handles)

function edit1_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit7_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit7_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit6_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit5_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in buttonLayout.
function buttonLayout_Callback(hObject, eventdata, handles)
[file, dir] = uigetfile('*.xls');
excel       = strcat(dir, file);

set(handles.textFile, 'string', excel);
guidata(hObject, handles);

% --- Executes on button press in buttonRT.
function buttonRT_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0       , 'hMainGui');
j        = getappdata(hMainGui, 'j');
R        = getappdata(hMainGui, 'R');

r  = get(handles.listboxComp, 'value');
rt = get(handles.listboxComp, 'string');

R = R(:,j);

figure
plot(R(:,r));
legend(rt(r,:))
title('Actual retentimes')

% --- Executes on button press in buttonWidth.
function buttonWidth_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0        , 'hMainGui');
W        = getappdata(hMainGui , 'W');
j        = getappdata(hMainGui , 'j');

r  = get(handles.listboxComp, 'value');
rt = get(handles.listboxComp, 'string');

W=W(:,j);

figure
plot(W(:,r))
legend(rt(r,:))
title('Peak widths')

% --- Executes on button press in buttonExclude.
function buttonExclude_Callback(hObject, eventdata, handles)
i1       = get(handles.listboxComp , 'value');
hMainGui = getappdata(0            , 'hMainGui');
pcaDATA  = getappdata(hMainGui     , 'pcaDATA');
series   = getappdata(hMainGui     , 'series');

%The peak marked in listboxComp is excluded from the dataset.
for i=3:max(series)
    evalc(['x=pcaDATA.serie' num2str(i)]);

    I              = x.include{2,1};
    r              = find(I==i1);
    I(r)           = [];
    x.include{2,1} = I;

    evalc(['pcaDATA.serie' num2str(i) '=x;']);
end

setappdata(hMainGui, 'pcaDATA', pcaDATA);

% --- Executes on button press in buttonPCA.
function buttonPCA_Callback(hObject, eventdata, handles)
i1       = get(handles.popupSeries, 'value');
hMainGui = getappdata(0           , 'hMainGui');
pcaDATA  = getappdata(hMainGui    , 'pcaDATA');

% xp is set to data from the serie chosen in "popupSeries"
evalc(['xp=pcaDATA.serie' num2str(i1+2)]);

save xp xp

%pls toolbox is started
pca

% --- Executes on selection change in popupSeries.
function popupSeries_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function popupSeries_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in tbuttonBase.
function tbuttonBase_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0       , 'hMainGui');
dataAll  = getappdata(hMainGui, 'dataAll');
j        = getappdata(hMainGui, 'j');
hMax     = getappdata(hMainGui, 'hMax');
Base     = getappdata(hMainGui, 'Base');
a        = getappdata(hMainGui, 'a');
b        = getappdata(hMainGui, 'b');
scanF    = getappdata(hMainGui, 'scanF');
msStart  = getappdata(hMainGui, 'msStart');
filetype = getappdata(hMainGui, 'filetype');

% if the files are from gc-fid msStart should be set to zero
if filetype == 1
    msStart = 0;
end

i2   = get(handles.listboxSamples, 'value');
name = get(handles.listboxSamples, 'string');
i1   = get(handles.listboxComp, 'value');
d    = eval(get(handles.edit4, 'string'));
I    = get(hObject, 'value');

m  = size(dataAll,1);
rt = round(1000*((1:m)/scanF+msStart))/1000;
rt = rt(1,j);
rt = rt(1,i1);

axes(handles.axesCrom)
set(gca,'Layer', 'top')
plot((1:m)/scanF+msStart, dataAll(:,i2));
legend(name(i2,:))
for i=1:length(i1)
    rectangle('Position',[rt(1,i)-(0.5*d/scanF+msStart),0,d/scanF,max(hMax(:,i2))])
end
hold on

if I == 0
    hold off
else
    plot((a:b)/scanF+msStart, Base(i2,:)', 'color', [0.5 0.5 0.5])
    hold off
end

% --- Executes on button press in buttonExport.
function buttonExport_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0        , 'hMainGui');
H        = getappdata(hMainGui , 'H');

if isempty(H)==1
    warndlg('Please perform calculations before exporting to excel', 'Warning', 'modal');
    return
else
    export
end

% --- Executes on button press in RTindex.
function RTindex_Callback(hObject, eventdata, handles)
KIonOff = get(hObject,'Value');
hMainGui = getappdata(0, 'hMainGui');
setappdata(hMainGui, 'KIonOff', KIonOff);

% --- Executes on button press in buttonRTindex.
function buttonRTindex_Callback(hObject, eventdata, handles)
tresh   = eval(get(handles.edit1    , 'string'));
a       = eval(get(handles.edit5    , 'string'));
b       = eval(get(handles.edit6    , 'string'));
phi     = eval(get(handles.edit7    , 'string'));
excel   =      get(handles.textFile , 'string');
smooth  = eval(get(handles.edit33   , 'string'));
scanF   = eval(get(handles.edit32   , 'string'));
noiseW  = eval(get(handles.edit31   , 'string'));

hMainGui = getappdata(0       , 'hMainGui');
filetype = getappdata(hMainGui, 'filetype');
files    = getappdata(hMainGui, 'files');

if isempty(excel)==1
    warndlg('Please load the excel file with the experimental layout', 'Warning', 'modal');
    return
end

[num, txt, raw] = xlsread(excel, 'Samples');
SampID          = (raw(3:length(files)+2,4))';
Series          = cell2mat(raw(3:length(files)+2,5)');

if length(SampID)~=length(files)
    warndlg('The number of files in the chosen directory does not match the layout in the xls file', 'Warning', 'modal');
    return
end

KIsamp = find(Series==2);

if isempty(KIsamp)==1
    warndlg('There are no KI files indicated in the excel layout sheet', 'Warning', 'modal');
    return
end

setappdata(hMainGui, 'mode'     , 0);
setappdata(hMainGui, 'KIsamp'   , KIsamp);
setappdata(hMainGui, 'tresh'    , tresh);
setappdata(hMainGui, 'noiseW'   , noiseW);
setappdata(hMainGui, 'scanF'    , scanF);
setappdata(hMainGui, 'smooth'   , smooth);

h = waitbar(0, 'Please wait, calculation in progress');

if filetype == 1
    if a == 0 && filetype ==1
        a = 1;
        b = round(scanF*b);

    else
        a = round(scanF*a);
        b = round(scanF*b);
    end
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    importRAX
    
elseif filetype == 2
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    importCDF
    
    scanF = getappdata(hMainGui, 'scanF');
    set(handles.edit32, 'string', scanF)
    guidata(hObject, handles);
else
    setappdata(hMainGui, 'a'        , a);
    setappdata(hMainGui, 'b'        , b);
    XLS_MAT
    
    scanF = getappdata(hMainGui, 'scanF');
    set(handles.edit32, 'string', scanF)
    guidata(hObject, handles);
end

scanF   = getappdata(hMainGui, 'scanF');
msStart = getappdata(hMainGui, 'msStart');
b       = getappdata(hMainGui, 'b');

NoiseRemoval

data_baselined = getappdata(hMainGui, 'data_baselined');

[num, txt, raw] = xlsread(excel, 'KI');

KIcompounds = raw(2:end, 1); % names of Ki compounds
KIindex     = num(1:end, 1); % Index as stated in excel.xls

KIwin(:,1)  = round(((num(1:end, 2) - num(1:end, 3)) - msStart) .* scanF); %beginning of windows for KI peaks
KIwin(:,2)  = round(((num(1:end, 2) + num(1:end, 3)) - msStart) .* scanF); %end of windows for KI peaks

KIrt     = zeros(size(num,1),length(KIsamp));
KIheight = zeros(size(num,1),length(KIsamp));
I = isnan(KIwin(:,1));
KIwin(I,:)=[];
for i = 1:size(KIwin,1)
    if b >= KIwin(i,2)
        %KI peaks are the highest peak within windows
        [KIheight(i,:), KIrt(i,:)] = max(data_baselined(:,KIwin(i,1):KIwin(i,2)), [], 2);
        % in order to obtain the true scan number for the peaks the initial
        % scan number of the relevant window is added
        KIrt(i,:) = KIrt(i,:) + KIwin(i,1);
    elseif b > KIwin(i,1)
        [KIheight(i,:), KIrt(i,:)] = max(data_baselined(:,KIwin(i,1):b), [], 2);
        KIrt(i,:) = KIrt(i,:) + KIwin(i,1);
    end
end

%Peaks smaller than the minimum peak height are deleted
I           = find(KIheight < phi);
KIrt(I)     = NaN;
KIheight(I) = NaN;

setappdata(hMainGui, 'KIcompounds', KIcompounds);
setappdata(hMainGui, 'KIindex'    , KIindex);
setappdata(hMainGui, 'KIheight'   , KIheight);

if filetype == 1
    setappdata(hMainGui, 'KIrt'       , KIrt./scanF);
else
    setappdata(hMainGui, 'KIrt'       , KIrt./scanF + msStart);
end

close(h);

VOCki

% --- Executes on button press in buttonViewRT.
function buttonViewRT_Callback(hObject, eventdata, handles)
VOCki

% --- Executes on button press in buttonClose.
function buttonClose_Callback(hObject, eventdata, handles)
%deletes hMainGui, and closes the main gui
rmappdata(0, 'hMainGui');

close VOCgui

% --- Executes on button press in buttonTresh.
function buttonTresh_Callback(hObject, eventdata, handles)
hMainGui = getappdata(0       , 'hMainGui');
files    = getappdata(hMainGui, 'files');
H        = getappdata(hMainGui, 'H');

if isempty(files) == 1
    warndlg('Please load your data before the threshold is determined')
    return
end

if isempty(H) == 1
    warndlg('Please make an initial calculation')
    return
end

filenumber = get(handles.listboxSamples, 'value');

setappdata(hMainGui, 'filenumber', filenumber);
treshGui

% --- Executes on button press in buttonV1.
function buttonV1_Callback(hObject, eventdata, handles)

% --- Executes on button press in buttonV2.
function buttonV2_Callback(hObject, eventdata, handles)

% --- Executes on button press in buttonShift.
function buttonShift_Callback(hObject, eventdata, handles)

% --- Executes on button press in boxM.
function boxM_Callback(hObject, eventdata, handles)

% --- Executes on button press in buttonBase.
function buttonBase_Callback(hObject, eventdata, handles)

function edit31_Callback(hObject, eventdata, handles)
% noiseW


% --- Executes during object creation, after setting all properties.
function edit31_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit31 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in buttonNoise.
function buttonNoise_Callback(hObject, eventdata, handles)

function edit32_Callback(hObject, eventdata, handles)
% ScanF


% --- Executes during object creation, after setting all properties.
function edit32_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit32 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit33_Callback(hObject, eventdata, handles)
% msStart

% --- Executes during object creation, after setting all properties.
function edit33_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit33 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupLoad.
function popupLoad_Callback(hObject, eventdata, handles)

v     = get(hObject, 'value');

if v == 1
    path = uigetdir;
    cd(path)
    files = dir('*.RAX');

    if isempty(files)==1
        warndlg('There are no RAX files in the chosen directory', 'Warning', 'modal');
        return
    end

    hMainGui = getappdata(0, 'hMainGui');
    setappdata(hMainGui, 'filetype', 1);
    setappdata(hMainGui, 'files', files);
elseif v == 2
    path = uigetdir;
    cd(path)
    files = dir('*.CDF');

    if isempty(files)==1
        warndlg('There are no CDF files in the chosen directory', 'Warning', 'modal');
        return
    end

    hMainGui = getappdata(0, 'hMainGui');
    setappdata(hMainGui, 'filetype', 2);
    setappdata(hMainGui, 'files', files);
elseif v == 3
    [file, path] = uigetfile('*.mat');
    cd(path)
    load(file)
    
    hMainGui = getappdata(0, 'hMainGui');
    setappdata(hMainGui, 'filetype', 3);
    setappdata(hMainGui, 'files', 1:size(x,2)-1);
    setappdata(hMainGui, 'x', x);

elseif v == 4
    [file, path] = uigetfile('*.xls', 'MultiSelect','on');
    cd(path)
    hMainGui = getappdata(0, 'hMainGui');
    setappdata(hMainGui, 'filetype', 4);
    setappdata(hMainGui, 'files', file);
end

setappdata(hMainGui, 'direc', path);

set(handles.textPath , 'string', path)
set(handles.textPath2, 'string', path)
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupLoad_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupLoad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
