function [x_baselined, base S] = Baseline(x_baselined, start, stop, x, I, base)
% Sub-sub function used in baseline estimation
% GUI for treating GC-fid and TIC chromatograms
%
% FastChrom version 1.0
% Lea Gioertz Johnsen
%
% Latest opdate: 16-08-2011
%%
% hMainGui = getappdata(0    , 'hMainGui');
% V1       = getappdata(hMainGui, 'V1');
V1= 5;
neg  = find(x_baselined(start:stop)<0);

%if there are no more than  V1 instances below zero the
%for loop should terminate
if length(neg) < ceil(V1/2)
    S = 0;
    return
end
neg  = [neg inf];
% zeroes in Ii indicates that two consecetive
% valeus are below zero, 5 in a row indicates 6 places
% below zero in a row
Ii = neg(1:end-1)-neg(2:end)+1;

% Ii2 is a index showing where the non-zeroes are placed in
% Ii
Ii2 = find(Ii);
Ii2 = [0 Ii2];
% if there only is one non-zero in the range
if length(Ii2) == 1 && isempty(Ii2)==0 Ii2 > ceil(V1/2)
    [Xmin, S]        = min(x_baselined(start:stop));
    S                = S + start -1;
    slope1           = (x(S)-x(start-1)) /(S - start + 1);
    slope2           = (x(stop+1)-x(S)) /(stop -S + 1);
    base(start:(S-1))= x(start-1) + (1:(S-start))*slope1;
    base((S+1):stop) = x(S) + (1:(stop-S))*slope2;
    base(S)          = x(S);
elseif max(Ii2(2:end)-Ii2(1:end-1)) > ceil(V1/2)
    [Xmin, S]        = min(x_baselined(start:stop));
    S                = S + start -1;
    slope1           = (x(S)-x(start-1)) /(S - start + 1);
    slope2           = (x(stop+1)-x(S)) /(stop -S + 1);
    base(start:(S-1))= x(start-1) + (1:(S-start))*slope1;
    base((S+1):stop) = x(S) + (1:(stop-S))*slope2;
    base(S)          = x(S);
else
    S                = 0;
end
x_baselined(start:stop) = (x(start:stop)'-base(start:stop));

