function [part,Yrep,Yc]=statpred(Y,Yp,rep)
%[part,Yrep,Yc]=statpred(Y,Yp,rep)
%
% INPUT
%  Y     Measured values
%  Yp    Predicted values
%  rep   Vector with same number for replicates
%
% OUTPUT
%  part  Struct with RMSEP, SEP, SEPCorr, Slope, Intercept, Bias, R^2,
%         Samples, Range and RepAb
%  Yrep  Reference Y. Replicates removed (if present)
%  Yc    Cell-array. (1) Uncorrected
%                    (2) Bias corrected
%                    (3) Slope corrected

[Ym,Yr]=repmean([Y Yp],rep);
p=size(Ym,2)-1;
Yrep=Ym(:,1);
part.RMSEP=sqrt(mean((Ym(:,ones(p,1))-Ym(:,2:end)).^2));
Yc{1}=Ym(:,2:end);
temp=corrcoef(Ym);
part.R2=temp(1,2:end);
if size(Ym,1)>2
    part.Bias=mean(Ym(:,ones(p,1))-Ym(:,2:end));
    Yc{2}=Ym(:,2:end)+part.Bias(ones(size(Ym,1),1),:);
    part.SEP=std(Ym(:,ones(p,1))-Ym(:,2:end));
else
    part.Bias=NaN;
    part.SEP=NaN;
    Yc{2}=Ym(:,2:end);
end
if size(Ym,1)>3
    for i=1:p
        temp=polyfit(Ym(:,i+1),Ym(:,1),1);
        part.Slope(i)=temp(1);
        part.Inter(i)=temp(2);
        Ym(:,i+1)=Ym(:,i+1)*temp(1)+temp(2);
    end
    part.SEPCorr=sqrt(sum((Ym(:,ones(p,1))-Ym(:,2:end)).^2)/(size(Ym,1)-2));
else
    part.Slope(1:p)=NaN;
    part.Inter(1:p)=NaN;
    part.SEPCorr=NaN;
end
Yc{3}=Ym(:,2:end);
part.RepAb=repab(Yp,rep);
part.Samples=fjernlike([size(Ym,1);size(Y,1)])';
part.Range=[min(Y) max(Y)];