function x=repab(Yp,rep)

[temp,Yr]=repmean(Yp,rep);
if size(Yp,1)~=size(temp,1)
    [j,k]=fjernlike(rep);
    %Remove those samples that only have one replicate
    ind=find(~isnan(k(:,2)));
    ind=vec(k(ind,:)');
    ind=ind(~isnan(ind));
    %Calculate the difference from mean
    res=(Yr(ind,:)-Yp(ind,:)).^2;
    %Find replicates
    [f,g]=fjernlike(rep(ind));
    %In case there is a mixture of samples with and without replicates,
    %the samples without replicates have to be removed
    f(isnan(g(:,2)))=[];
    g(isnan(g(:,2)),:)=[];
    %Set index for sparse matrix
    u=vec((1:length(f))'*ones(1,size(g,2)));
    t=vec(ones(size(f))*(1:size(g,2)));
    f=vec(g);
    u(isnan(f))=[];
    t(isnan(f))=[];
    f(isnan(f))=[];
    %Calculate repeatability per column in Yp
    for i=1:size(Yp,2)
        w=sparse(u,t,res(f,i));
        w=sqrt(sum(w')'./(sum(~isnan(g'))'-1));
        x(i)=full(mean(w));
    end
else
    x=ones(1,size(Yp,2))*NaN;
end