%In this script 'x' is your X-matrix and 'y' makes up your dependent
%variable, your y-vector (only one variable)

load feed
y = feedprot.data;
x = snv( feednir.data);
%There are "only" 221 samples with reference values
x( isnan( y), :) = [];
y( isnan( y) ) = [];
ropt = rpls;
%Selects three factors as the optimal number of factors
ropt.nLV = 4;
%The second number indicate how large difference between the smallest and
%the largest regression coefficient which is allowed.
ropt.Set = [Inf 1e14];
%This make a 10 segmented cross-validation
ropt.Val.ind = cvind( y, [], 10);
%Calculate the rPLS model
[mod, evo] = rpls( x, y, ropt);
