function [matrix,TIC,axis_min,axis_mz] = netCDFload(filename)

% Load netCDF files from different chromatographic software packages, and 
% arrange in matrices for further processing. 
% This file is an adaptation of iCDF_load (Skov and Bro 2008) to
% interface with new built-in MATLAB capabilities, and uses ncread.m
% available in MATLAB R2011a and later versions. 
%
% INPUT
% filename    The netCDF file to be loaded e.g. 'Sample10.CDF'
%
% OUTPUT
% matrix      Data in a two-way array - matrix (elution time x m/z)
% TIC         Total Ion Current given as a one-way array - vector (elution time)
% axis_min    Axis labels of elution time dimension, in minutes
% axis_mz     Axis labels of mass spectral dimension, i.e. m/z values
%
% I/O: [matrix,TIC,axis_min,axis_mz] = netCDFload(filename)
%
% ----- REFERENCES -----
% K.R. Murphy, P. Wenig, G. Parcsi, T. Skov, R.M. Stuetz (in press) Characterizing odorous emissions 
% using new software for identifying peaks in chemometric models of GC-MS datasets. Chem Intel Lab Sys.
% doi: 10.1016/j.chemolab.2012.07.006
%
% Skov T and Bro R. (2008) Solving fundamental problems in chromatographic
% analysis, Analytical and Bioanalytical Chemistry, 390 (1): 281-285. 
%
% KR Murphy, Water Research Laboratory, The University of New South Wales, Sydney, Australia

scan_index = ncread(filename,'scan_index');
mass_values = ncread(filename,'mass_values');
intensity_values = ncread(filename,'intensity_values');
total_intensity = ncread(filename,'total_intensity');
scan_acquisition_time = ncread(filename,'scan_acquisition_time');
mass_range_max = ncread(filename,'mass_range_max');

matrix = zeros(length(scan_index),max(round(mass_values)));
scan_index(length(scan_index)+1)= length(mass_values);

for i = 1:length(scan_index)-1
    matrix(i,round(mass_values(scan_index(i)+1:scan_index(i+1))))......
        = intensity_values(scan_index(i)+1:scan_index(i+1));
end

TIC = total_intensity;

axis_min = scan_acquisition_time/60; %Elution time in minutes
axis_mz = 1:round(max(mass_range_max)); %m/z values
