function B = SMREW(X,A,B,lambda)

% ell-1 based sparse matrix regression:
% Given X, A, find B to 
% min ||X-A*B.'||_2^2 + lambda*sum(sum(abs(B)))
%
% N. Sidiropoulos, July 2009
% nikos@telecom.tuc.gr
%
% This version: uses element-wise coordinate descent; 
% current B estimate given as input;
% Each element-wise update can be solved analytically (in closed form) 

[I,J]=size(X);
[I,F]=size(A);

DontShowOutput = 1;
maxit=1000;
convcrit = 1e-9;
showfitafter=1;
it=0;
Oldfit=1e100;
Diff=1e100;

while Diff>convcrit&it<maxit
    it=it+1;
    for j=1:J, 
        for f=1:F, 
            data = X(:,j) - A*B(j,:).' + A(:,f)*B(j,f); 
            alpha = A(:,f);
            if alpha.'*alpha > 10*eps                
                if alpha.'*data > lambda/2
                    B(j,f) = (alpha.'*data - lambda/2)/(alpha.'*alpha);
                elseif alpha.'*data <  -lambda/2 
                    B(j,f) = (alpha.'*data + lambda/2)/(alpha.'*alpha);
                else % Nikos fixed bug, Aug. 14, 2009
                    B(j,f) = 0; % Nikos fixed bug, Aug. 14, 2009
                end
            else
                B(j,f) = 0;
            end            
        end
    end

    fit=norm(X-A*B.','fro')^2+lambda*sum(sum(abs(B)));
    if Oldfit < fit 
        disp(['*** bummer! *** ',num2str(Oldfit-fit)]) 
    end
    Diff=abs(Oldfit-fit);
    Oldfit=fit;
    
    if ~DontShowOutput
        % Output text
        if rem(it,showfitafter)==0
            disp([' SMREW Iterations:', num2str(it),' fit: ',num2str(fit)])
        end
    end
    
end


            
        
        
        

